% lp : light position
% ld : light direction (normal)
% lt : light tangent
% lb : light bitangent
% hp : hit position
% n  : hit position normal

%% point light (pos)
clearvars 
lp = sym('lp',[3,1],'real');
hp = sym('hp',[3,1],'real');
n = sym('n',[3,1],'real');
syms tinyEps real;

rd = lp - hp;
rl = norm(rd);
rd = rd./rl;

cosOverR2 = simplify(dot(n, rd)/(rl*rl+tinyEps));

pointLight = simplify( gradient( cosOverR2, lp ) );
%fcn = matlabFunction(pointLight);
ccode(pointLight','File','codegen/_codegen_pointLightDerivs.h')

%% spotlight (pos/rotation)
clearvars 
lp = sym('lp',[3,1],'real');
hp = sym('hp',[3,1],'real');
n = sym('n',[3,1],'real');
ld = sym('ld',[3,1],'real');
%syms light_angle_scale light_angle_offset tinyEps real;
syms ia oa tinyEps real; % inner/outer angle

rd = lp - hp;
rl = norm(rd);
rd = rd./rl;

cosOverR2 = simplify(dot(n, rd)/(rl*rl+tinyEps));

cd = dot(ld, -rd);
light_angle_scale = 1 / (cos(ia) - cos(oa));
light_angle_offset = -cos(oa) * light_angle_scale;

angularAttenuation = cd * light_angle_scale + light_angle_offset;
angularAttenuation = piecewise(angularAttenuation < 0, 0, angularAttenuation > 1, 1, angularAttenuation);
angularAttenuation = angularAttenuation * angularAttenuation;

spot = simplify(cosOverR2 * angularAttenuation);

spotPos = (gradient(spot, lp));
spotDir = (gradient(spot, ld));
spotInnerAngle = (gradient(spot, ia));
spotOuterAngle = (gradient(spot, oa));
ccode([[spotPos; spotInnerAngle] [spotDir; spotOuterAngle]]','File','codegen/_codegen_spotLightDerivs.h')

%% area light (pos/rotation)
clearvars 

lp = sym('lp',[3,1],'real'); % light position
ld = sym('ld',[3,1],'real'); % light direction
lt = sym('lt',[3,1],'real'); % light tangent
lb = sym('lb',[3,1],'real'); % light bitangent
hp = sym('hp',[3,1],'real'); % hit location
n = sym('n',[3,1],'real'); % surface normal at hit location
syms dimX dimY dx dy tinyEps real; % offset along t and b

newlp = lp + dx*lt*dimX + dy*lb*dimY;

rd = newlp - hp;
rl = norm(rd);
rd = rd./rl;
cd = dot(ld, -rd);
area = dimX * dimY;
cosN = dot(n, rd);

solidAngleToArea = abs(cosN) .* area .* abs(cd) ./ (rl * rl);
arealight = solidAngleToArea;

areaPos = ( gradient(arealight, lp) );
areaDir = ( gradient(arealight, ld) );
areaT = ( gradient(arealight, lt) );
ccode([areaPos areaDir areaT]','File','codegen/_codegen_rectLightDerivs.h')

%% ies light (pos/rotation)

% Intensity I = texture( uv( r ) ), r = light to hit point in light's tangent space, normalized
% 
% 1. d(texture)/d(uv)
% 
% 2. d(uv)/dr
% 
% 3. dr/dp
% 
% 4. dr/dT*dT/dn, dr/dT*dT/dt ... change of tangent space with light orientation
% 
% dI/dp = d(tex)/d(uv) * d(uv)/dr * dr/dp
% dI/dn = d(tex)/d(uv) * d(uv)/dr * dr/dn
% dI/dt = d(tex)/d(uv) * d(uv)/dr * dr/dt

clearvars 

lp = sym('lp',[3,1],'real'); % light position
ld = sym('ld',[3,1],'real'); % light direction
lt = sym('lt',[3,1],'real'); % light tangent
lb = sym('lb',[3,1],'real'); % light bitangent
hp = sym('hp',[3,1],'real'); % hit location
rangeUV = sym('rangeUV',[2,1],'real'); % effective uv range
syms maxVAngle minVAngle maxHAngle minHAngle tinyEps real;

rd = hp - lp;
rl = norm(rd);
rd = rd./rl;

vAngleDeg = simplify(acos(dot(ld,rd)) * 180/pi);
hAngleDeg = simplify(atan2(dot(lb,rd), dot(lt,rd)) * 180/pi);

vDenom = maxVAngle - minVAngle;
hDenom = maxHAngle - minHAngle;

uv = [
    (vAngleDeg - minVAngle) / vDenom
    (hAngleDeg - minHAngle) / hDenom
];

uv(1) = piecewise(vDenom < tinyEps, 0, simplify(uv(1)));
uv(2) = piecewise(hDenom < tinyEps, 0, simplify(uv(2)));

uv = 0.5 + rangeUV .* uv;

duvdp = jacobian( uv, lp );
duvdn = jacobian( uv, ld );
duvdt = jacobian( uv, lt );

ccode(transpose([ duvdp, duvdn, duvdt ]),'File','codegen/_codegen_iesLightDerivs.h');
%% bilinear filtering (pixelUV)
clearvars 
pixelUV = sym('pixelUV',[2,1],'real');
cd = sym('cd',[4,1],'real');

% bilinear interpolation
top = cd(1) * (1-pixelUV(1)) + cd(2) * pixelUV(1);
bottom = cd(4) * (1-pixelUV(1)) + cd(3) * pixelUV(1);
bilinear = simplify(bottom * (1-pixelUV(2)) + top * pixelUV(2));

deriv = simplify( gradient( bilinear, pixelUV ) );
ccode(deriv','File','codegen/_codegen_bilinearFilteringDerivs.h')
