%% brdf wo
% complete grad 
% dDiffuse/dLp + dSpecular/dLp

clearvars

lp = sym('lp',[3,1],'real');

metallic = sym('metallic',[1,1],'real');
[~,~,~,~,diffuseLambert,specularGGX] = getGGXFunction(lp);

% diffuse
gradDiffuse = gradient( diffuseLambert(1), lp );
ccode(transpose(gradDiffuse),'File','codegen/_codegen_diffuseBrdfDerivs.h');

% specular (GGX)
gradSpecularGGX = gradient( specularGGX, lp );
ccode(transpose(gradSpecularGGX),'File','codegen/_codegen_specularBrdfDerivs.h');

% full
%ccode(transpose(gradDiffuse) + transpose(gradSpecularGGX),'File','codegen/_codegen_fullBrdfDerivs.h');

%% brdf wi
% complete grad 
% dDiffuse/dLp(wi) + dSpecular/dLp(wi)

clearvars

lp = sym('lp',[3,1],'real');

metallic = sym('metallic',[1,1],'real');
[~,~,~,~,diffuseLambert,specularGGX] = getGGXFunctionWi(lp);

% diffuse
gradDiffuse = gradient( diffuseLambert, lp );
ccode(transpose(gradDiffuse),'File','codegen/_codegen_diffuseBrdfDerivsWi.h');

% specular (GGX)
gradSpecularGGX = gradient( specularGGX, lp );
ccode(transpose(gradSpecularGGX),'File','codegen/_codegen_specularBrdfDerivsWi.h');
