clear all; clc;
% geometric term cos(incoming angle) / distance^2
p = sym('p',[3,1],'real'); % light position
x = sym('x',[3,1],'real'); % hit location
n = sym('n',[3,1],'real'); % hit normal
syms tinyEps real;

rd = p - x;
rl = norm(rd);
rd = rd./rl;

cosOverR2 = simplify(dot(n, rd)/(rl*rl+tinyEps));

dCosOverR2dp = simplify( gradient( cosOverR2, p ) );
fcn = matlabFunction( dCosOverR2dp);
cfcn = ccode(dCosOverR2dp)
cfc2 = ccode( cosOverR2 )
