% area light derivatives (replaces areaLightCosOutDeriv.mlx)
clear variables; clc;

lp = sym('lp',[3,1],'real'); % light position
ln = sym('ln',[3,1],'real'); % light direction
lt = sym('lt',[3,1],'real'); % light tangent (don't use 't' to avoid confusion with temporary code-gen vars
hx = sym('hx',[3,1],'real'); % hit location
hn = sym('hn',[3,1],'real'); % surface normal at hit location
syms tinyEps dx dy real; % world-space (non-relative!) offset along t and t2

lb = cross(ln,lt); % bi-tangent

ro = lp + dx*lt./norm(lt) + dy*lb./norm(lb);
rd = (hx-ro)./( norm(hx-ro)+tinyEps );

cosout = simplify ( dot( rd , ln./norm(ln) ) );

cosinOverR2 = simplify( dot( -rd, hn ) /( dot((hx-ro), (hx-ro)) + tinyEps ) );

%%
% cosine term leaving the light source
dcodp = simplify( gradient( cosout, lp) );
dcodn = simplify( gradient( cosout, ln) );
dcodt = simplify( gradient( cosout, lt) );
%%
% geometric term on receiving surface: cos(in)/r^2
dcir2dp = simplify( gradient( cosinOverR2, lp) );
dcir2dn = simplify( gradient( cosinOverR2, ln) );
dcir2dt = simplify( gradient( cosinOverR2, lt) );

%%
ccode( [dcodp, dcodn, dcodt, dcir2dp, dcir2dn, dcir2dt]', 'File','_codegen_rectLightDerivs.h')
%%
matlabFunction( [dcodp, dcodn, dcodt, dcir2dp, dcir2dn, dcir2dt]', 'File','codegen_rectLightDerivs.m' )

