clear variables; clc;
co=[0 0 0
    1 0 0
    0 1 0];
el=[1 2 3];

rd = [-2.2 -0.5 -1]; rd=rd./norm(rd);

opt.specular=1;
opt.sphm_bands=7;

%% project reflected ray (Dirac delta function) and smooth afterwards
psf = projectSpecularReflection_SPHM(el,co, 1,0,0,rd,1, opt)';
psf = psf(2:end); % skip separate diffuse coeff
for l=(1:opt.sphm_bands)-1
    for m=-l:l
        h = (l*(l+1)).^2; % see also page 19 in StupidSH36.pdf
        psf(l*(l+1) + m +1) = psf(l*(l+1) + m +1) / (1 + 1e-3*h);
    end
end
figure;
sphm_plot(psf,opt.sphm_bands, 0.8,[0;0;0],3*18,3*36, 0); axis equal;
title('project \delta and smooth');

%% build zonal harmonic BRDF and rotate towards ray direction
zh = zeros(opt.sphm_bands,1);
for l=(2:opt.sphm_bands)-1
    h = (l*(l+1)).^2; % Smoothing: see also page 7 & 19 in StupidSH36.pdf
    zh(l+1) = 1 / (1 + 1e-3*h);
    zh(1) = zh(1) - zh(l+1) * sphm_Y(l,0,pi,0) / sphm_K(0,0); % zh(ONE), not L (add offset to const. part to make ZH in -z direction (pi,0) == 0)
end
zh = zh2sh(zh,opt.sphm_bands);
figure;
[~,v]=sphm_plot(zh,opt.sphm_bands, 0.8,[0;0;0],3*18,3*36, 0); axis equal;
min(min(v))
title('zonal harmonic (smoothed)');

% now apply rotation ...
% f_l^m = n_l * z_l * y_l^m(phi, theta), n_l = sqrt( 4*pi / (2*l+1) )

% rd = rd.*[1 1 -1];
rd = [0.6; 1; 0.2]; rd = rd./norm(rd);
[phi, theta] = cart2sph(rd(1),rd(2),rd(3));
theta = pi/2 - theta; % [-pi/2 pi/2] --> [0 pi] (0 --> +z direction)
psf = zeros(opt.sphm_bands.^2,1);
for l=(1:opt.sphm_bands)-1
    for m=-l:l
        psf(l*(l+1) + m +1) = sqrt( 4*pi / (2*l+1) ) * zh(l*(l+1) + 0 +1) * sphm_Y(l,m,theta,phi);
    end
end
figure;
sphm_plot(psf,opt.sphm_bands, 0.8,[0;0;0],3*18,3*36, 0); axis equal;
xlabel('x'); ylabel('y'); zlabel('z');
title('rotated zonal harmonic');

%%
clear variables;
% GGXinSHandZHresult32;
GGXinSHandZHresult54;
%
bands = length(ZH_coeffs);
% figure; sphm_plot(SH_coeffs,7,1,[0;0;0],4*36,4*18,0); axis equal;
figure; sphm_plot(zh2sh(ZH_coeffs,bands),bands,1,[0;0;0],4*36,4*18,0); axis equal;

x=ggxSamples(:,1); y=ggxSamples(:,2); z=ggxSamples(:,3);
v=ggxSamples(:,4);
hold on; scatter3(x,y,z,16,v,'filled'); axis equal;

int_SH = SH_coeffs(1)*sqrt(4*pi) %#ok
int_ZH = ZH_coeffs(1)*sqrt(4*pi) %#ok
int_MC = sum(v)/length(v)*4*pi %#ok

%%

function sh = zh2sh(zh,bands)
    % map zonal harmonic coefficients into spherical harmonic coefficients (padding with zeros where m~=0)
    sh = zeros(bands.^2,1);
    l = (1:bands)-1; % m==0
    sh( l.*(l+1)+1 ) = zh;
end


