%% draw individual spherical harmonic functions ...
% clc;
l = 3; % >= 0
m = 3;% in [ -l l ] (lower-case-L not 1)
theta = linspace(0, pi, 20*18); % theta is out of xy plane
phi = linspace(0, 2*pi, 20*36);
[theta, phi] = meshgrid(theta, phi);

v = zeros(size(theta));
for i=1:size(v,1)
    for j=1:size(v,2)
        v(i,j) = sphm_Y(l, m, theta(i,j), phi(i,j));
    end
end
figure;
[x,y,z] = sph2cart(phi,pi/2-theta,abs(v)+0.01);
surf(x,y,z,v); axis equal; shading interp;
