
clc; clear variables; close all;
obj = read_wobj('tilted_plane.obj');
co = obj.vertices;
el = obj.objects( strcmp({obj.objects(:).type}, 'f') ).data.vertices;

% add second plate with linear transform
R = axang2rotm([2 -1 0 0.3*pi]); p = (0*co(:,1)+1)*[1 1 1];
el = [ el ; el+size(co,1) ];
co = [ co ; co*R'+p ];

% obj = read_wobj('twoplanes_lowres.obj'); % note different order of elems in this file!
% co = obj.vertices;
% el = obj.objects( strcmp({obj.objects(:).type}, 'f') ).data.vertices;


opt.specular=0.7/(4*pi); % ratio of specular reflection (diffuse will be 1-s)
opt.specularDrawScale=0.07; % size of specular balls in plots
[opt.usph_el, opt.usph_co] = readIcoSphereFromMesh();

opt.debugPlot = 0;
opt.n_th = 15;
opt.n_rh = 36;
opt.lth = 15; % spot light cone angle (deg)
opt.edge_th = 5; % soft edge angle (deg)
p = [0 0 0];

opt.lightDisplacement = [-0.5 0 0.5];
pw_target = mytestAdjoint(el,co, opt, []);
title('target'); drawnow;
% saveas(gcf,'_img/target.png');

% integrate pw over mesh == should equal 1 (only on lower plane, only if not using soft edge spot light!)
int_pw = 0; pw = pw_target;
% trisurf( el(1:ceil(size(el,1)/2),:), co(:,1), co(:,2), co(:,3))
for k=1:ceil(size(el,1)/2)
    % linear fcn within el --> avg. of corners * area
    avg = ( pw(el(k,1),:) + pw(el(k,2),:) +pw(el(k,3),:) ) / 3;
    ar = 0.5*( norm(cross( co(el(k,2),:)-co(el(k,1),:) , co(el(k,3),:)-co(el(k,1),:) )));
    int_pw = int_pw + avg*ar;
end
if  isfield(opt, 'specular')
    int_ps = 0; int_ar = 0;
    for k=1:size(opt.usph_el,1) % integrate specular component over unit sphere (this integration should probably be done first if the domain is not flat)
        % linear fcn within el --> avg. of corners * area
        avg = ( int_pw(opt.usph_el(k,1)+1) + int_pw(opt.usph_el(k,2)+1) + int_pw(opt.usph_el(k,3)+1) ) / 3;
        ar = 0.5*( norm(cross( opt.usph_co(opt.usph_el(k,2),:)-opt.usph_co(opt.usph_el(k,1),:) , opt.usph_co(opt.usph_el(k,3),:)-opt.usph_co(opt.usph_el(k,1),:) )));
        int_ps = int_ps + avg*ar;
        int_ar = int_ar + ar;
    end
    int_ps = int_ps + int_ar*int_pw(1) % diffuse component
else
    int_pw
end


%%
% % replace target with const. 0.5
% close all;
% pw_target = 0*pw_target + 0.5;
%%

opt.lightDisplacement = p;
[pw, phi, dphidp] = mytestAdjoint(el,co, opt, pw_target);

[pw_d, dpwdx,dpwdy,dpwdz] = mytestDirect(el,co, opt);
[phi_d, dphidpw] = mytestObjective(pw_d, pw_target, el,co);
dphidp_d  = (dphidpw(:)') * [dpwdx(:), dpwdy(:), dpwdz(:)];

disp('compare adjoint - direct ...');
abs(phi-phi_d)
max(max(abs(pw-pw_d)))
abs(dphidp - dphidp_d)
disp('grads:');
[ dphidp ; dphidp_d ] %#ok

% phi=phi_d; pw=pw_d; dphidp = dphidp_d;
if  0
    disp('FD-check ...');
    fd_h=1e-7;
    dphidp_fd = 0*dphidp;
    dpwdx_fd = 0*dpwdx;
    dpwdy_fd = 0*dpwdy;
    dpwdz_fd = 0*dpwdz;
    for ll=1:3
        opt.lightDisplacement = p;
        opt.lightDisplacement(ll) = opt.lightDisplacement(ll) + fd_h;

%         [~,phi_fd]  = mytestAdjoint(el,co, opt ,pw_target);

        pw_fd = mytestDirect(el,co, opt);
        phi_fd = mytestObjective(pw_fd, pw_target, el,co);
        if     ll==1, dpwdx_fd = (pw_fd - pw) / fd_h;
        elseif ll==2, dpwdy_fd = (pw_fd - pw) / fd_h;
        elseif ll==3, dpwdz_fd = (pw_fd - pw) / fd_h;
        end
        
        dphidp_fd(ll) = (phi_fd - phi) / fd_h;
    
    end
    disp(max(max(abs(dphidp - dphidp_fd))));
    disp(max(max(abs(dpwdx - dpwdx_fd))));
    disp(max(max(abs(dpwdy - dpwdy_fd))));
    disp(max(max(abs(dpwdz - dpwdz_fd))));
    disp('... FD done');
end

%%


% for vw = 40:10:200
%     view(vw,20); drawnow;
%     saveas(gcf,['_img/target_view_' num2str(vw,'%03u') '.png']);
% end

p = [0 0 0];
phi_iters = [];
%%
% for j=1:150
%     [phi,dphidp] = optfunHelper(p, pw_target, el,co,opt);
%     
%     phi_iters = [phi_iters; phi]; %#ok
% 
%     title(['step ' num2str(length(phi_iters),'%3u') ', p = [' num2str(p,'%.3f ') '], \Phi = ' num2str(phi,'%.3e')]);  drawnow;
% %     saveas(gcf,['_img/grad_desc_' num2str(j,'%03u') '.png']);
%     p = p - 0.2*dphidp; % basic gradient descent step
% end
% figure; plot(phi_iters);


% proper optimization ...
j=1; % f-eval counter
optimopts = optimoptions(@fminunc,'Algorithm','quasi-newton','SpecifyObjectiveGradient',true,'Display','iter-detailed');
optfun = @(p) optfunHelper(p, pw_target, el,co,opt);
p = fminunc(optfun,p,optimopts);
% disp(max(abs(p- [-0.5 0 0.5])));

% %%
% for vw = 40:10:200
%     view(vw,20); drawnow;
%     saveas(gcf,['_img/result_view_' num2str(vw,'%3u') '.png']);
% end


%%
function [phi,dphidp] = optfunHelper(p, pw_target, el,co,opt)
    opt.lightDisplacement = p;

%     [~, phi, dphidp] = mytestAdjoint(el,co, opt, pw_target);
    
    [pw, dpwdx,dpwdy,dpwdz] = mytestDirect(el,co, opt);
    [phi, dphidpw] = mytestObjective(pw, pw_target, el,co);
    dphidp = (dphidpw(:)') * [dpwdx(:), dpwdy(:), dpwdz(:)];
    
    j=evalin('base','j'); assignin('base','j',j+1);
    title(['step ' num2str(j,'%3u') ', p = [' num2str(p,'%.3f, ') ']']); drawnow;
%     saveas(gcf,['_img/qnewton_' num2str(j,'%03u') '.png']);
end

%%
function [phi, dphidpw] = mytestObjective(pw, pw_target, el,co)
%     [qp,qw] = gaussQuadratureTri();
%     if  0 % measure only secondary surface (second half of co and el arrays)
%         idx = ceil(size(el,1)/2):size(el,1);
%     else % measure the entire mesh against the target
%         idx = 1:size(el,1);
%     end
%     
%     phi = 0;
%     dphidpw = 0*pw_target;
%     % integrate over elements (midpoint rule)
%     for k = idx % loop over indexed elements only
%         % wrong: not linear! ... linear fcn within el --> avg. of corners * area
%         ar = 0.5*( norm(cross( co(el(k,2),:)-co(el(k,1),:) , co(el(k,3),:)-co(el(k,1),:) ))); % element area
%         for j = 1:length(qw) % loop over quadrature points .. ToDo: analytic integral
%             val = qp(j,:) * [ pw(el(k,1),:) ; pw(el(k,2),:) ; pw(el(k,3),:) ];
%             val_target = qp(j,:) * [ pw_target(el(k,1),:) ; pw_target(el(k,2),:) ; pw_target(el(k,3),:) ];
% 
%             phi = phi + 0.5*ar*qw(j)*sum((val-val_target).^2); %ToDo: also integrate specular components over unit sphere instead of summing
%             dphidpw(el(k,1),:) = dphidpw(el(k,1),:) + ar*qw(j)*qp(j,1) *(val-val_target);
%             dphidpw(el(k,2),:) = dphidpw(el(k,2),:) + ar*qw(j)*qp(j,2) *(val-val_target);
%             dphidpw(el(k,3),:) = dphidpw(el(k,3),:) + ar*qw(j)*qp(j,3) *(val-val_target);
%         end
%     end
% 
%     phi_test = phi;
%     dphidpw_test = dphidpw;
    
    M = consistentMass(el,co);
    phi = trace( 0.5*(pw-pw_target)'*M*(pw-pw_target) ); % in the specular case we get a 43x43 matrix, whose trace is the sum we compute above (still ToDo: proper integral over unit sphere)
    dphidpw = M*(pw-pw_target);
    
%     assert( abs(phi-phi_test)<1e-10 );
%     assert( max(max(abs(dphidpw-dphidpw_test)))<1e-10 );
end


function [pw, phi, dphidp] = mytestAdjoint(el,co, opt, pw_target)
    geometricDerivative = @(lp1,lp2,lp3,n1,n2,n3,qp1,qp2,qp3)[n1.*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(3.0./2.0)-(lp1.*2.0-qp1.*2.0).*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(5.0./2.0).*(lp1.*n1+lp2.*n2+lp3.*n3-n1.*qp1-n2.*qp2-n3.*qp3).*(3.0./2.0);n2.*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(3.0./2.0)-(lp2.*2.0-qp2.*2.0).*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(5.0./2.0).*(lp1.*n1+lp2.*n2+lp3.*n3-n1.*qp1-n2.*qp2-n3.*qp3).*(3.0./2.0);n3.*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(3.0./2.0)-(lp3.*2.0-qp3.*2.0).*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(5.0./2.0).*(lp1.*n1+lp2.*n2+lp3.*n3-n1.*qp1-n2.*qp2-n3.*qp3).*(3.0./2.0)];
    blendFcnDerivative  = @(edgeAngle,ld1,ld2,ld3,lp1,lp2,lp3,qp1,qp2,qp3)[(1.0./sqrt(-(ld1.*lp1+ld2.*lp2+ld3.*lp3-ld1.*qp1-ld2.*qp2-ld3.*qp3).^2./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2)+1.0).*(ld1.*1.0./sqrt((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2)-(lp1.*2.0-qp1.*2.0).*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(3.0./2.0).*(ld1.*lp1+ld2.*lp2+ld3.*lp3-ld1.*qp1-ld2.*qp2-ld3.*qp3).*(1.0./2.0)).*-1.8e2)./(edgeAngle.*pi);(1.0./sqrt(-(ld1.*lp1+ld2.*lp2+ld3.*lp3-ld1.*qp1-ld2.*qp2-ld3.*qp3).^2./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2)+1.0).*(ld2.*1.0./sqrt((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2)-(lp2.*2.0-qp2.*2.0).*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(3.0./2.0).*(ld1.*lp1+ld2.*lp2+ld3.*lp3-ld1.*qp1-ld2.*qp2-ld3.*qp3).*(1.0./2.0)).*-1.8e2)./(edgeAngle.*pi);(1.0./sqrt(-(ld1.*lp1+ld2.*lp2+ld3.*lp3-ld1.*qp1-ld2.*qp2-ld3.*qp3).^2./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2)+1.0).*(ld3.*1.0./sqrt((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2)-(lp3.*2.0-qp3.*2.0).*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(3.0./2.0).*(ld1.*lp1+ld2.*lp2+ld3.*lp3-ld1.*qp1-ld2.*qp2-ld3.*qp3).*(1.0./2.0)).*-1.8e2)./(edgeAngle.*pi)];

    M = consistentMass(el,co);
    
    dataPerNode = 1;
    if  isfield(opt, 'specular')
        tmp = projectSpecularReflection([],[],-1,[],[],[],[],opt);
        dataPerNode = length(tmp);
    end
    pw = zeros(size(co,1),dataPerNode);
    dphidp = [0 0 0];

    if  opt.debugPlot
        figure; trimesh(el,co(:,1),co(:,2),co(:,3),'FaceAlpha',0,'EdgeAlpha',0.2,'EdgeColor','k'); axis equal; hold on;
    end

    lp = [0.1,3,-0.2];
    if  isfield(opt,'lightDisplacement')
        lp = lp + opt.lightDisplacement;
    end
    [ldx,ldy,ldz] = sph2cart(-pi/2,0,1); ld = [ldx,ldy,ldz]; clear ldx ldy ldz;

    if  opt.debugPlot
        quiver3(lp(:,1),lp(:,2),lp(:,3), ld(:,1),ld(:,2),ld(:,3));
    end

    h1=simplePerpendicularVector(ld);
    h1=h1./norm(h1);

    th_vals = linspace(0,opt.lth,opt.n_th+1); th_vals = th_vals(2:end)-(th_vals(2)-th_vals(1))*0.5;
    rh_vals = linspace(0,360,opt.n_rh+1); rh_vals = rh_vals(2:end);
    avg_th = sum(th_vals)/opt.n_th; assert( abs(avg_th - opt.lth/2) < 1e-10 );
    
    for th = th_vals
        for rh = rh_vals
            R1 = axang2rotm([h1 th/180*pi]);
            R2 = axang2rotm([ld rh/180*pi]);
            rd = (R2*R1*ld')'; % ray direction
            
            if  opt.debugPlot
                quiver3(lp(:,1),lp(:,2),lp(:,3), rd(:,1),rd(:,2),rd(:,3), 'g');
            end

            for k = 1:size(el,1)
                [isHit, u, v, d] = rayTriangleIntersection(lp, rd, co(el(k,1),:), co(el(k,2),:), co(el(k,3),:));
                if  isHit && d > 2*eps(single(1.0))
                    if  opt.debugPlot
                        hx = co(el(k,1),:) + u*(co(el(k,2),:)-co(el(k,1),:)) + v*(co(el(k,3),:)-co(el(k,1),:));
                        plot3(hx(1),hx(2),hx(3),'bo');
                    end

                    % can't be outside of cone ... if  dot(rd,ld)>cos(lth/180*pi) % cos( light angle ) > spot cone
                    rth = th; % == acos( dot(rd,ld) )*180/pi;
                    if  rth>(opt.lth-opt.edge_th)
                        blend = (opt.lth-rth)/(opt.edge_th); 
                    else
                        blend = 1;
                    end                    
                    
                    % distribute 1/(n_th*n_rh) of the total radiative power to the three nodes
                    ph = 1/(opt.n_th*opt.n_rh) * (th / avg_th) * blend;
                    if  isfield(opt, 'specular')
                        psf = projectSpecularReflection(el,co, k,u,v,rd,1.0, opt);
                        pw(el(k,:),:) = pw(el(k,:),:) + [1-u-v ; u ; v]*psf*ph;
%                         pw(el(k,1),:) = pw(el(k,1),:) + (1-u-v)*ps;
%                         pw(el(k,2),:) = pw(el(k,2),:) +    u   *ps;
%                         pw(el(k,3),:) = pw(el(k,3),:) +      v *ps;
                    else
                        pw(el(k,:)) = pw(el(k,:)) + [1-u-v ; u ; v]*ph;
                    end
                    
                    % compute second bounce (simple version: perfect reflection)
                    % incoming ray (lp, rd) reflected on triangle k (at location u,v in bary.coords.)
                    % results in outgoing ray (x,R*rd), where x is world-space location of (u,v)
                    % and R reflects the direction rd around the triangle normal
                    
                    rlp = (1-u-v)*co(el(k,1),:) + u*co(el(k,2),:) + v*co(el(k,3),:);
                    %drlpdp = ((-dudp-dvdp)'*co(el(k,1),:) + dudp'*co(el(k,2),:) + dvdp'*co(el(k,3),:))'; % coords->rows, params->cols
                    n = cross(co(el(k,2),:)-co(el(k,1),:) , co(el(k,3),:)-co(el(k,1),:));
                    n = n'./norm(n); % for now, assume n constant (flat elements)
                    % reflect: d' = d - 2*(d-d.nn
                    % (lp,rd) -> (x,R*rd)
                    R = eye(3) - 2*(n*n');
                    rrd = R*rd'; % if rd and R are const, no additional deriv. terms here

                    if  opt.debugPlot
                        quiver3( rlp(1),rlp(2),rlp(3) , rrd(1),rrd(2),rrd(3) ,0,'g');
                    end
                    
                    % process outgoing ray (rlp, rrd) ... clean up code !!!
                    % -----------------------------------------------------
                    for kk = 1:size(el,1)
                        [isHit, u, v, d] = rayTriangleIntersection(rlp, rrd, co(el(kk,1),:), co(el(kk,2),:), co(el(kk,3),:));
                        if  isHit && d > 2*eps(single(1.0)) % reflection ray origin is on a triangle (+/- rounding error) so d must be significantly positive
                            if  opt.debugPlot
                                hx = co(el(kk,1),:) + u*(co(el(kk,2),:)-co(el(kk,1),:)) + v*(co(el(kk,3),:)-co(el(kk,1),:));
                                plot3(hx(1),hx(2),hx(3),'bo');
                            end

                            % Assumption: secondary rays produce diffuse-only lighting (kinda assumes that the "other" surface is only diffuse)

                            % distribute specular fraction of the total radiative power to the three nodes
                            if  isfield(opt, 'specular'), ph = opt.specular*ph;
                            %else, ph = ph; % ToDo: unrealistic - should use a random sampling diffuse transport.
                            end
                            pw(el(kk,1),1) = pw(el(kk,1),1) + (1-u-v)*ph;
                            pw(el(kk,2),1) = pw(el(kk,2),1) +    u   *ph;
                            pw(el(kk,3),1) = pw(el(kk,3),1) +      v *ph;
                        end
                    end
                    % -----------------------------------------------------
            
                    
                    % ToDo: stochastic 2nd bounce? (too slow in Matlab?)
                    
                    break; % end loop once we've found an intersection
                end
            end
        end
    end
    
    pw = M\pw; % L2-projection
    
    if  isempty(pw_target)
        phi=1e299;
        dphidp = [0 0 0];
    else
        % evaluate objective function
        [phi, dphidpw] = mytestObjective(pw, pw_target, el,co);
        
        dphidpw = M\dphidpw; % L2-projection
        
        % adjoint simulation ...       
        for th = th_vals
            for rh = rh_vals
                R1 = axang2rotm([h1 th/180*pi]);
                R2 = axang2rotm([ld rh/180*pi]);
                rd = (R2*R1*ld')'; % ray direction
                dphidpwOnRay = 0; % collect dphidpw along this ray (with weights according to transport ~ "adjoint scattering")
                
                for k = 1:size(el,1)
                    [isHit, u, v, rl] = rayTriangleIntersection(lp, rd, co(el(k,1),:), co(el(k,2),:), co(el(k,3),:));
                    if  isHit && rl > 2*eps(single(1.0))
                        % compute second bounce (simple version: perfect reflection)
                        % incoming ray (lp, rd) reflected on triangle k (at location u,v in bary.coords.)
                        % results in outgoing ray (x,R*rd), where x is world-space location of (u,v)
                        % and R reflects the direction rd around the triangle normal
                        
                        rlp = (1-u-v)*co(el(k,1),:) + u*co(el(k,2),:) + v*co(el(k,3),:);
                        % drlpdp = ((-dudp-dvdp)'*co(el(k,1),:) + dudp'*co(el(k,2),:) + dvdp'*co(el(k,3),:))'; % coords->rows, params->cols
                        % drlpdp =  (co'*Bk)*[dudp ; dvdp];
                        n = cross(co(el(k,2),:)-co(el(k,1),:) , co(el(k,3),:)-co(el(k,1),:));
                        n = n'./norm(n); % for now, assume n constant (flat elements)
                        % reflect: d' = d - 2*(d-d.nn
                        % (lp,rd) -> (x,R*rd)
                        R = eye(3) - 2*(n*n');
                        rrd = R*rd'; % if rd and R are const, no additional deriv. terms here

                        % process outgoing ray (rlp, rrd) ... clean up code !!!
                        % -----------------------------------------------------
                        for kk = 1:size(el,1)
                            [isHit2, uu, vv, dd] = rayTriangleIntersection(rlp, rrd, co(el(kk,1),:), co(el(kk,2),:), co(el(kk,3),:));
                            if  isHit2 && dd > 2*eps(single(1.0)) % reflection ray origin is on a triangle (+/- rounding error) so d must be significantly positive
                                % Assumption: secondary rays produce diffuse-only lighting (kinda assumes that the "other" surface is only diffuse)

                                % distribute specular fraction of the total radiative power to the three nodes
                                if  isfield(opt, 'specular'), tf=opt.specular; %dph2dp = opt.specular*dphdp;
                                else, tf=1.0;%dph2dp = dphdp; % ToDo: unrealistic - should use a random sampling diffuse transport.
                                end
%                                 dphido = dphido + ph*dphidpw(el(kk,:),1)'*B*[duudrlp ; dvvdrlp];
%                                 dphidp = dphidp + (dphidpw(el(kk,:),1)' * [1-uu-vv ; uu ; vv]*dph2dp'); % ToDo: only transport dphidpw along secondary ray, then multiply dphdp only for the primary ray
                                    dphidpwOnRay = dphidpwOnRay + tf * dphidpw(el(kk,:),1)' * [1-uu-vv ; uu ; vv];
                                break; % end element loop once intersection found
                            end
                        end
                        % -----------------------------------------------------

                        
                        % first intersection ...
%                         dphido = dphido * (co(el(k,:),:)'*B*[dudp;dvdp]); % apply derivative of reflected ray origin wrt. incoming ray origin to contribution of element kk
                        % add contribution of element k
                        if  isfield(opt, 'specular')
                            psf = projectSpecularReflection(el,co, k,u,v,rd,1.0, opt);
%                             dphido = dphido + ps*dphidpw(el(k,:),:)'*B*[dudp;dvdp];
%                             dphidp = dphidp + (psf*dphidpw(el(k,:),:)' * [1-u-v ; u ; v]*dphdp');
                            dphidpwOnRay = dphidpwOnRay + psf*dphidpw(el(k,:),:)' * [1-u-v ; u ; v];
                        else
%                             dphido = dphido + ph*dphidpw(el(k,:),1)'*B*[dudp;dvdp];
%                             dphidp = dphidp + (dphidpw(el(k,:))' * [1-u-v ; u ; v]*dphdp');
                            dphidpwOnRay = dphidpwOnRay + dphidpw(el(k,:),1)' * [1-u-v ; u ; v];
                        end
                        
                        
                        % n = cross( co(el(k,2),:)-co(el(k,1),:) , co(el(k,3),:)-co(el(k,1),:) );
                        % n = n./norm(n); % normal already done above
                        qpx = [1-u-v , u , v] * co(el(k,:),:);

                        % can't be outside of cone ... if  dot(rd,ld)>cos(lth/180*pi) % cos( light angle ) > spot cone
                        rth = acos( dot(rd,ld) )*180/pi; assert( abs(rth-th)<1e-10 );
                        if  rth>(opt.lth-opt.edge_th)
                            blend = (opt.lth-rth)/(opt.edge_th); 
                            dblenddp = blendFcnDerivative( opt.edge_th , ld(1),ld(2),ld(3),lp(1),lp(2),lp(3),qpx(1),qpx(2),qpx(3));
                        else
                            blend = 1; dblenddp = 0;
                        end

                        % distribute 1/(n_th*n_rh) of the total radiative power to the three nodes
                        ph = 1/(opt.n_th*opt.n_rh) * (th / avg_th)*blend;
                        % assume that ph = rayWeight * blend*dot(n,-rd)/(rl*rl) as in reverseRays case, with some constant rayWeight
                        rayWeight = ph / (blend*dot(n,-rd))*(rl*rl); assert(abs(  ph - rayWeight * blend*dot(n,-rd)/(rl*rl) )<1e-14 );

                        dpwdp = rayWeight *blend* geometricDerivative(lp(1),lp(2),lp(3),n(1),n(2),n(3),qpx(1),qpx(2),qpx(3)) ...
                              + rayWeight *dot(n,-rd)/(rl*rl)*dblenddp;

                        dphidp = dphidp + dphidpwOnRay * dpwdp';
                        break; % end loop once we've found an intersection
                    end
                end % element loop
            end
        end
        
    end
    
    
    if ~opt.debugPlot,  figure; end
    trisurf(el,co(:,1),co(:,2),co(:,3),pw(:,1)); axis equal; shading interp;
    colormap('hot'); caxis([min(pw(:)) max(pw(:))]);
    %%
    if  isfield(opt, 'specular')
        hold on;
        for i = 1:size(co,1)
            trisurf(opt.usph_el, ...
                opt.usph_co(:,1)*opt.specularDrawScale+co(i,1), ...
                opt.usph_co(:,2)*opt.specularDrawScale+co(i,2), ...
                opt.usph_co(:,3)*opt.specularDrawScale+co(i,3), ...
                pw(i,1)+pw(i,2:end),'FaceAlpha',1); axis equal; shading interp;
            colormap('hot');
        end
        for k = 1:size(el,1)
            trisurf(opt.usph_el, ...
                opt.usph_co(:,1)*opt.specularDrawScale+(co(el(k,1),1)+co(el(k,2),1)+co(el(k,3),1))./3, ...
                opt.usph_co(:,2)*opt.specularDrawScale+(co(el(k,1),2)+co(el(k,2),2)+co(el(k,3),2))./3, ...
                opt.usph_co(:,3)*opt.specularDrawScale+(co(el(k,1),3)+co(el(k,2),3)+co(el(k,3),3))./3, ...
                (pw(el(k,1),1)+pw(el(k,2),1)+pw(el(k,3),1))./3+(pw(el(k,1),2:end)+pw(el(k,2),2:end)+pw(el(k,3),2:end))./3,...
                'FaceAlpha',1); axis equal; shading interp;
            colormap('hot');
        end
        caxis([0 max(max(pw(:,1)+pw(:,2:end)))]); hold off;
    end
    
    view(140,20); drawnow;
%     saveas(gcf,['_img/lightpos_' num2str(opt.lightDisplacement(1)) '.png']);
end


function [pw, dpwdx,dpwdy,dpwdz] = mytestDirect(el,co, opt)
    geometricDerivative = @(lp1,lp2,lp3,n1,n2,n3,qp1,qp2,qp3)[n1.*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(3.0./2.0)-(lp1.*2.0-qp1.*2.0).*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(5.0./2.0).*(lp1.*n1+lp2.*n2+lp3.*n3-n1.*qp1-n2.*qp2-n3.*qp3).*(3.0./2.0);n2.*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(3.0./2.0)-(lp2.*2.0-qp2.*2.0).*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(5.0./2.0).*(lp1.*n1+lp2.*n2+lp3.*n3-n1.*qp1-n2.*qp2-n3.*qp3).*(3.0./2.0);n3.*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(3.0./2.0)-(lp3.*2.0-qp3.*2.0).*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(5.0./2.0).*(lp1.*n1+lp2.*n2+lp3.*n3-n1.*qp1-n2.*qp2-n3.*qp3).*(3.0./2.0)];
    blendFcnDerivative  = @(edgeAngle,ld1,ld2,ld3,lp1,lp2,lp3,qp1,qp2,qp3)[(1.0./sqrt(-(ld1.*lp1+ld2.*lp2+ld3.*lp3-ld1.*qp1-ld2.*qp2-ld3.*qp3).^2./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2)+1.0).*(ld1.*1.0./sqrt((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2)-(lp1.*2.0-qp1.*2.0).*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(3.0./2.0).*(ld1.*lp1+ld2.*lp2+ld3.*lp3-ld1.*qp1-ld2.*qp2-ld3.*qp3).*(1.0./2.0)).*-1.8e2)./(edgeAngle.*pi);(1.0./sqrt(-(ld1.*lp1+ld2.*lp2+ld3.*lp3-ld1.*qp1-ld2.*qp2-ld3.*qp3).^2./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2)+1.0).*(ld2.*1.0./sqrt((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2)-(lp2.*2.0-qp2.*2.0).*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(3.0./2.0).*(ld1.*lp1+ld2.*lp2+ld3.*lp3-ld1.*qp1-ld2.*qp2-ld3.*qp3).*(1.0./2.0)).*-1.8e2)./(edgeAngle.*pi);(1.0./sqrt(-(ld1.*lp1+ld2.*lp2+ld3.*lp3-ld1.*qp1-ld2.*qp2-ld3.*qp3).^2./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2)+1.0).*(ld3.*1.0./sqrt((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2)-(lp3.*2.0-qp3.*2.0).*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(3.0./2.0).*(ld1.*lp1+ld2.*lp2+ld3.*lp3-ld1.*qp1-ld2.*qp2-ld3.*qp3).*(1.0./2.0)).*-1.8e2)./(edgeAngle.*pi)];

    M = consistentMass(el,co);

    dataPerNode = 1;
    if  isfield(opt, 'specular')
        tmp = projectSpecularReflection([],[],-1,[],[],[],[],opt);
        dataPerNode = length(tmp);
    end
    pw = zeros(size(co,1),dataPerNode);
    dpwdx = pw; dpwdy = pw; dpwdz = pw; % derivatives of radiative power wrt. light position

    if  opt.debugPlot
        figure; trimesh(el,co(:,1),co(:,2),co(:,3),'FaceAlpha',0,'EdgeAlpha',0.2,'EdgeColor','k'); axis equal; hold on;
    end

    lp = [0.1,3,-0.2];
    if  isfield(opt,'lightDisplacement')
        lp = lp + opt.lightDisplacement;
    end
    [ldx,ldy,ldz] = sph2cart(-pi/2,0,1); ld = [ldx,ldy,ldz]; clear ldx ldy ldz;

    if  opt.debugPlot
        quiver3(lp(:,1),lp(:,2),lp(:,3), ld(:,1),ld(:,2),ld(:,3));
    end

    h1=simplePerpendicularVector(ld);
    h1=h1./norm(h1);

    th_vals = linspace(0,opt.lth,opt.n_th+1); th_vals = th_vals(2:end)-(th_vals(2)-th_vals(1))*0.5;
    rh_vals = linspace(0,360,opt.n_rh+1); rh_vals = rh_vals(2:end);
    avg_th = sum(th_vals)/opt.n_th;

    for th = th_vals
        for rh = rh_vals
            R1 = axang2rotm([h1 th/180*pi]);
            R2 = axang2rotm([ld rh/180*pi]);
            rd = (R2*R1*ld')'; % ray direction
            
            if  opt.debugPlot
                quiver3(lp(:,1),lp(:,2),lp(:,3), rd(:,1),rd(:,2),rd(:,3), 'g');
            end

            for k = 1:size(el,1)
                [isHit, u, v, rl] = rayTriangleIntersection(lp, rd, co(el(k,1),:), co(el(k,2),:), co(el(k,3),:));
                if  isHit && rl>0
                    if  opt.debugPlot
                        hx = co(el(k,1),:) + u*(co(el(k,2),:)-co(el(k,1),:)) + v*(co(el(k,3),:)-co(el(k,1),:));
                        plot3(hx(1),hx(2),hx(3),'bo');
                    end

                    n = cross( co(el(k,2),:)-co(el(k,1),:) , co(el(k,3),:)-co(el(k,1),:) );
                    n = n./norm(n);
                    qpx = [1-u-v , u , v] * co(el(k,:),:);

                    % can't be outside of cone ... if  dot(rd,ld)>cos(lth/180*pi) % cos( light angle ) > spot cone
                    rth = th; %== acos( dot(rd,ld) )*180/pi;
                    if  rth>(opt.lth-opt.edge_th)
                        blend = (opt.lth-rth)/(opt.edge_th); 
                        dblenddp = blendFcnDerivative( opt.edge_th, ld(1),ld(2),ld(3),lp(1),lp(2),lp(3),qpx(1),qpx(2),qpx(3));
                    else
                        blend = 1; dblenddp = 0;
                    end
                    
                    % distribute 1/(n_th*n_rh) of the total radiative power to the three nodes
                    ph = 1/(opt.n_th*opt.n_rh) * (th / avg_th)*blend;
                    % assume that ph = rayWeight * blend*dot(n,-rd)/(rl*rl) as in reverseRays case, with some constant rayWeight
                    rayWeight = ph / (blend*dot(n,-rd))*(rl*rl); assert(abs(  ph - rayWeight * blend*dot(n,-rd)/(rl*rl) )<1e-14 );

                    dphdp = rayWeight *blend* geometricDerivative(lp(1),lp(2),lp(3),n(1),n(2),n(3),qpx(1),qpx(2),qpx(3)) ...
                          + rayWeight *dot(n,-rd)/(rl*rl)*dblenddp;
                    
                    if  isfield(opt, 'specular')
                        psf = projectSpecularReflection(el,co, k,u,v,rd,1.0, opt);
                        pw(el(k,:),:) = pw(el(k,:),:) + [1-u-v ; u ; v]*psf*ph;
%                         pw(el(k,1),:) = pw(el(k,1),:) + (1-u-v)*ps;
%                         pw(el(k,2),:) = pw(el(k,2),:) +    u   *ps;
%                         pw(el(k,3),:) = pw(el(k,3),:) +      v *ps;
                        % gradient evaluation wrt. light position

                        dpwdx(el(k,:),:) = dpwdx(el(k,:),:) + [1-u-v ; u ; v]*psf*dphdp(1);
                        dpwdy(el(k,:),:) = dpwdy(el(k,:),:) + [1-u-v ; u ; v]*psf*dphdp(2);
                        dpwdz(el(k,:),:) = dpwdz(el(k,:),:) + [1-u-v ; u ; v]*psf*dphdp(3);
                    else
                        pw(el(k,:)) = pw(el(k,:)) + [1-u-v ; u ; v]*ph;
                        % gradient evaluation wrt. light position

                        dpwdx(el(k,:)) = dpwdx(el(k,:)) + [1-u-v ; u ; v]*dphdp(1);
                        dpwdy(el(k,:)) = dpwdy(el(k,:)) + [1-u-v ; u ; v]*dphdp(2);
                        dpwdz(el(k,:)) = dpwdz(el(k,:)) + [1-u-v ; u ; v]*dphdp(3);

                    end
                    
                    % compute second bounce (simple version: perfect reflection)
                    % incoming ray (lp, rd) reflected on triangle k (at location u,v in bary.coords.)
                    % results in outgoing ray (x,R*rd), where x is world-space location of (u,v)
                    % and R reflects the direction rd around the triangle normal
                    
                    rlp = (1-u-v)*co(el(k,1),:) + u*co(el(k,2),:) + v*co(el(k,3),:);
                    n = cross(co(el(k,2),:)-co(el(k,1),:) , co(el(k,3),:)-co(el(k,1),:));
                    n = n'./norm(n); % for now, assume n constant (flat elements)
                    % reflect: d' = d - 2*(d-d.nn
                    % (lp,rd) -> (x,R*rd)
                    R = eye(3) - 2*(n*n');
                    rrd = R*rd'; % if rd and R are const, no additional deriv. terms here

                    if  opt.debugPlot
                        quiver3( rlp(1),rlp(2),rlp(3) , rrd(1),rrd(2),rrd(3) ,0,'g');
                    end
                    
                    % process outgoing ray (rlp, rrd) ... clean up code !!!
                    % -----------------------------------------------------
                    % Q: do we need to change dphdp here? Probably depends on params (i.e. if param moves the origin of the secondary ray, then probably yes)
                    %    also, we ignore that there would be a geometrc derivative d(rrd)/dp in this case, ad rd is no longer constant if the first hit point is const. but the light source moves
                    for kk = 1:size(el,1)
                        [isHit, u, v, d] = rayTriangleIntersection(rlp, rrd, co(el(kk,1),:), co(el(kk,2),:), co(el(kk,3),:));
                        if  isHit && d > 2*eps(single(1.0)) % reflection ray origin is on a triangle (+/- rounding error) so d must be significantly positive
                            if  opt.debugPlot
                                hx = co(el(kk,1),:) + u*(co(el(kk,2),:)-co(el(kk,1),:)) + v*(co(el(kk,3),:)-co(el(kk,1),:));
                                plot3(hx(1),hx(2),hx(3),'bo');
                            end

                            % Assumption: secondary rays produce diffuse-only lighting (kinda assumes that the "other" surface is only diffuse)

                            % distribute specular fraction of the total radiative power to the three nodes
                            if  isfield(opt, 'specular'), ph = opt.specular*ph; dphdp = opt.specular*dphdp;
                            %else, ph = ph; % ToDo: unrealistic - should use a random sampling diffuse transport.
                            end
                            pw(el(kk,:),1) = pw(el(kk,:),1) + [1-u-v ; u ; v]*ph;
                            
                            dpwdx(el(kk,:),1) = dpwdx(el(kk,:),1) + [1-u-v ; u ; v]*dphdp(1);
                            dpwdy(el(kk,:),1) = dpwdy(el(kk,:),1) + [1-u-v ; u ; v]*dphdp(2);
                            dpwdz(el(kk,:),1) = dpwdz(el(kk,:),1) + [1-u-v ; u ; v]*dphdp(3);
                        end
                    end
                    % -----------------------------------------------------
            
                    
                    % ToDo: stochastic 2nd bounce? (too slow in Matlab?)
                    
                    break; % end loop once we've found an intersection
                end
            end
        end
    end
    
    pw=M\pw;
    dpwdx=M\dpwdx;
    dpwdy=M\dpwdy;
    dpwdz=M\dpwdz;
    
    if ~opt.debugPlot,  figure; end
    trisurf(el,co(:,1),co(:,2),co(:,3),pw(:,1)); axis equal; shading interp;
    colormap('hot'); caxis([min(pw(:)) max(pw(:))]);
    %%
    if  isfield(opt, 'specular')
        hold on;
        for i = 1:size(co,1)
            trisurf(opt.usph_el, ...
                opt.usph_co(:,1)*opt.specularDrawScale+co(i,1), ...
                opt.usph_co(:,2)*opt.specularDrawScale+co(i,2), ...
                opt.usph_co(:,3)*opt.specularDrawScale+co(i,3), ...
                pw(i,1)+pw(i,2:end),'FaceAlpha',1); axis equal; shading interp;
            colormap('hot');
        end
        for k = 1:size(el,1)
            trisurf(opt.usph_el, ...
                opt.usph_co(:,1)*opt.specularDrawScale+(co(el(k,1),1)+co(el(k,2),1)+co(el(k,3),1))./3, ...
                opt.usph_co(:,2)*opt.specularDrawScale+(co(el(k,1),2)+co(el(k,2),2)+co(el(k,3),2))./3, ...
                opt.usph_co(:,3)*opt.specularDrawScale+(co(el(k,1),3)+co(el(k,2),3)+co(el(k,3),3))./3, ...
                (pw(el(k,1),1)+pw(el(k,2),1)+pw(el(k,3),1))./3+(pw(el(k,1),2:end)+pw(el(k,2),2:end)+pw(el(k,3),2:end))./3,...
                'FaceAlpha',1); axis equal; shading interp;
            colormap('hot');
        end
        caxis([0 max(max(pw(:,1)+pw(:,2:end)))]); hold off;
    end
    
    view(140,20); drawnow;
%     saveas(gcf,['_img/lightpos_' num2str(opt.lightDisplacement(1)) '.png']);
end

