
clc; clear variables;
obj = read_wobj('tilted_plane.obj');
co = obj.vertices;
el = obj.objects( strcmp({obj.objects(:).type}, 'f') ).data.vertices;

[co,el] = refineRGB(co,el,findBoundary(el),1:size(el,1)); % refine once to have same number of DOFs as P2 mesh
% trimesh(el,co(:,1),co(:,2),co(:,3),'FaceAlpha',0,'EdgeAlpha',0.2,'EdgeColor','k');

% specular not implemented here!
% opt.specular=0.6; % ratio of specular reflection (diffuse will be 1-s)
% opt.specularDrawScale=0.06; % size of specular balls in plots
% [opt.usph_el, opt.usph_co] = readIcoSphereFromMesh();

opt.debugPlot = 0;
opt.smoothing = 0.005; % add some Laplacian smoothing to the result
opt.n_th = 15;
opt.n_rh = 36;
opt.lth = 5; % spot light cone angle (deg)
opt.edge_th = 2; % soft edge angle (deg)

opt.lightDisplacement = [-0.5 0 0.5];
pw_target = mytestDirect(el,co, opt);
title('target'); drawnow;
% % 
% % integrate pw over mesh == should equal 1 (only if not using soft edge spot light; opt.edge_th == 0)
% int_pw = 0; pw = pw_target;
% for k=1:size(el,1)
%     % linear fcn within el --> avg. of corners * area
%     avg = ( pw(el(k,1),:) + pw(el(k,2),:) +pw(el(k,3),:) ) / 3;
%     ar = 0.5*( norm(cross( co(el(k,2),:)-co(el(k,1),:) , co(el(k,3),:)-co(el(k,1),:) )));
%     int_pw = int_pw + avg*ar;
% end
% sum(int_pw) % ToDo: also use L2-projection (or spherical harmonic projection) in specular case - and compare by integrating specular power over unit sphere

phi_iters = [];

%%
% close all;
% pw_target = 0*pw_target + 0.5;
% % problems solved ;-)

% %%
% [phi,dphidp] = optfunHelper([-0.5 0 0.5], pw_target, el,co,opt);
% disp(phi); disp(dphidp);
% 
%%
[phi,dphidp] = optfunHelper([0 0 0], pw_target, el,co,opt);
disp(phi); disp(dphidp);
hold on; quiver3(0.1,3,-0.2,  -dphidp(1),-dphidp(2),-dphidp(3), 'LineWidth',2,'Marker','o', 'MaxHeadSize', 0.4 ); view(180,0);
% %%
% [phi,dphidp] = optfunHelper([0 0 -0.5], pw_target, el,co,opt);
% disp(phi); disp(dphidp);
% hold on; plot3(0.1,3,-0.2-0.5,'ro'); quiver3(0.1,3,-0.2-0.5,  -dphidp(1),-dphidp(2),-dphidp(3), 'LineWidth',2,'Marker','o', 'MaxHeadSize', 0.4 ); view(180,0);

%%
p = [0 0 -0.5];
% %%
% for j=1:150
%     [phi,dphidp, pw] = optfunHelper(p, pw_target, el,co,opt);
%     
%     if  j==1
%         opt.lightDisplacement = p;
%         [pw_adj, phi_adj, dphidp_adj] = mytestAdjoint(el,co,opt, pw_target);
% 
%         % compare direct and adjoint calculations -- works
%         disp('(pw, phi, dphidp) direct-adjoint abs err:');
%         disp([max(abs(pw(:)-pw_adj(:)))  max(abs(phi(:)-phi_adj(:)))  max(abs(dphidp(:)-dphidp_adj(:)))]);
%     end
%     
%     % run FD check
%     fd_h=1e-7;
%     dphidp_fd = [0 0 0];
%     if  j==1 % must fail (but not by much) !!! because sampling actually changes although we compute the gradient as if it did not
%         disp('FD-check ...');
%         for l=1:length(dphidp_fd)
%             opt.lightDisplacement = p;
%             opt.lightDisplacement(l) = opt.lightDisplacement(l) + fd_h;
%             pw_fd  = mytestDirect(el,co, opt);
%             phi_fd = mytestObjective(el,co, pw_fd, pw_target);
%             dphidp_fd(l) = (phi_fd - phi) / fd_h;
%         end
%         disp('abs err (grad-fd):');
%         disp(abs(dphidp - dphidp_fd));
%         disp('grad, fd:');
%         disp(dphidp);
%         disp(dphidp_fd);
%         disp('... done');
%     end
%     
%     p = p - 0.2*dphidp; % basic gradient descent step
% end
% 
%% proper optimization ...
phi_iters=[];
optimopts = optimoptions(@fminunc,'Algorithm','quasi-newton','SpecifyObjectiveGradient',true,'Display','iter-detailed');
optfun = @(p) optfunHelper(p, pw_target, el,co,opt);
p = fminunc(optfun,[0 0 0],optimopts);
disp(max(abs(p- [-0.5 0 0.5])));


figure; plot(phi_iters);


%% functions ...

function [phi,dphidp, pw] = optfunHelper(p, pw_target, el,co,opt)
    opt.lightDisplacement = p;

%     [~, phi, dphidp] = mytestAdjoint(el,co, opt, pw_target);
    
    [pw, dpwdx,dpwdy,dpwdz] = mytestDirect(el,co, opt);
    [phi, dphidpw] = mytestObjective(el,co, pw, pw_target);
    dphidp = (dphidpw(:)') * [dpwdx(:), dpwdy(:), dpwdz(:)];
    
    phi_iters=evalin('base','phi_iters');
    phi_iters = [phi_iters; phi];
    assignin('base','phi_iters',phi_iters);
    
    title(['step ' num2str(length(phi_iters),'%3u') ', p = [' num2str(p,'%.3f ') '], \Phi = ' num2str(phi,'%.3e')]);  drawnow;
%     saveas(gcf,['_img/qnewton_' num2str(j,'%03u') '.png']);
end


function [phi, dphidpw] = mytestObjective(el,co, pw, pw_target)
%     phi = 0.5*sum((pw(:)-pw_target(:)).^2);
%     dphidpw = pw-pw_target;
%     [qp,qw] = gaussQuadratureTri();
% 
%     phi = 0;
%     dphidpw = 0*pw_target;
%     % integrate over elements (midpoint rule)
%     for k = 1:size(el,1) % loop over indexed elements only
%         % wrong: not linear! ... linear fcn within el --> avg. of corners * area
%         ar = 0.5*( norm(cross( co(el(k,2),:)-co(el(k,1),:) , co(el(k,3),:)-co(el(k,1),:) ))); % element area
%         for j = 1:length(qw) % loop over quadrature points .. ToDo: analytic integral
%             val = qp(j,:) * [ pw(el(k,1),:) ; pw(el(k,2),:) ; pw(el(k,3),:) ];
%             val_target = qp(j,:) * [ pw_target(el(k,1),:) ; pw_target(el(k,2),:) ; pw_target(el(k,3),:) ];
% 
%             phi = phi + 0.5*ar*qw(j)*sum((val-val_target).^2); %ToDo: also integrate specular components over unit sphere instead of summing
%             dphidpw(el(k,1),:) = dphidpw(el(k,1),:) + ar*qw(j)*qp(j,1) *(val-val_target);
%             dphidpw(el(k,2),:) = dphidpw(el(k,2),:) + ar*qw(j)*qp(j,2) *(val-val_target);
%             dphidpw(el(k,3),:) = dphidpw(el(k,3),:) + ar*qw(j)*qp(j,3) *(val-val_target);
%         end
%     end
%     phi_test = phi;
%     dphidpw_test = dphidpw;
%     
%     M = consistentMass(el,co);
%     phi = 0.5*(pw-pw_target)'*M*(pw-pw_target);
%     dphidpw = M*(pw-pw_target);

    % smoothing before L2-distance works too - maybe the key component of the W2-distance here?
    L = laplacianP1tri(el,co);
    M = consistentMass(el,co);
    S = (M + 0.1*L)\M; % smoothing kernel (implicit Laplacian smoothing step) ==? S = inv(speye(size(M)) + 0.1*L/M);
    phi = 0.5*(pw-pw_target)'*S'*M*S*(pw-pw_target);
    dphidpw = S'*M*S*(pw-pw_target);
%     
%     [phi, dphidpw] = convWstnDistance(el,co, pw,pw_target);
    
%     assert( abs(phi-phi_test)<1e-10 );
%     assert( max(abs(dphidpw-dphidpw_test))<1e-10 );
end


function [pw, phi, dphidp] = mytestAdjoint(el,co, opt, pw_target)
    M = consistentMass(el,co);
    L = laplacianP1tri(el,co);
    geometricDerivative = @(lp1,lp2,lp3,n1,n2,n3,qp1,qp2,qp3)[n1.*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(3.0./2.0)-(lp1.*2.0-qp1.*2.0).*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(5.0./2.0).*(lp1.*n1+lp2.*n2+lp3.*n3-n1.*qp1-n2.*qp2-n3.*qp3).*(3.0./2.0);n2.*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(3.0./2.0)-(lp2.*2.0-qp2.*2.0).*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(5.0./2.0).*(lp1.*n1+lp2.*n2+lp3.*n3-n1.*qp1-n2.*qp2-n3.*qp3).*(3.0./2.0);n3.*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(3.0./2.0)-(lp3.*2.0-qp3.*2.0).*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(5.0./2.0).*(lp1.*n1+lp2.*n2+lp3.*n3-n1.*qp1-n2.*qp2-n3.*qp3).*(3.0./2.0)];
    blendFcnDerivative  = @(edgeAngle,ld1,ld2,ld3,lp1,lp2,lp3,qp1,qp2,qp3)[(1.0./sqrt(-(ld1.*lp1+ld2.*lp2+ld3.*lp3-ld1.*qp1-ld2.*qp2-ld3.*qp3).^2./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2)+1.0).*(ld1.*1.0./sqrt((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2)-(lp1.*2.0-qp1.*2.0).*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(3.0./2.0).*(ld1.*lp1+ld2.*lp2+ld3.*lp3-ld1.*qp1-ld2.*qp2-ld3.*qp3).*(1.0./2.0)).*-1.8e2)./(edgeAngle.*pi);(1.0./sqrt(-(ld1.*lp1+ld2.*lp2+ld3.*lp3-ld1.*qp1-ld2.*qp2-ld3.*qp3).^2./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2)+1.0).*(ld2.*1.0./sqrt((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2)-(lp2.*2.0-qp2.*2.0).*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(3.0./2.0).*(ld1.*lp1+ld2.*lp2+ld3.*lp3-ld1.*qp1-ld2.*qp2-ld3.*qp3).*(1.0./2.0)).*-1.8e2)./(edgeAngle.*pi);(1.0./sqrt(-(ld1.*lp1+ld2.*lp2+ld3.*lp3-ld1.*qp1-ld2.*qp2-ld3.*qp3).^2./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2)+1.0).*(ld3.*1.0./sqrt((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2)-(lp3.*2.0-qp3.*2.0).*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(3.0./2.0).*(ld1.*lp1+ld2.*lp2+ld3.*lp3-ld1.*qp1-ld2.*qp2-ld3.*qp3).*(1.0./2.0)).*-1.8e2)./(edgeAngle.*pi)];

    dataPerNode = 1;
    if  isfield(opt, 'specular')
        tmp = projectSpecularReflection([],[],-1,[],[],[],[],opt);
        dataPerNode = length(tmp);
    end
    pw = zeros(size(co,1),dataPerNode);

    if  opt.debugPlot
        figure; trimesh(el,co(:,1),co(:,2),co(:,3),'FaceAlpha',0,'EdgeAlpha',0.2,'EdgeColor','k'); axis equal; hold on;
    end

    lp = [0.1,3,-0.2];
    if  isfield(opt,'lightDisplacement')
        lp = lp + opt.lightDisplacement;
    end
    [ldx,ldy,ldz] = sph2cart(-pi/2,0,1); ld = [ldx,ldy,ldz]; clear ldx ldy ldz;

    if  opt.debugPlot
        quiver3(lp(:,1),lp(:,2),lp(:,3), ld(:,1),ld(:,2),ld(:,3));
    end

    h1=simplePerpendicularVector(ld);
    h1=h1./norm(h1);

    th_vals = linspace(0,opt.lth,opt.n_th+1); th_vals = th_vals(2:end)-(th_vals(2)-th_vals(1))*0.5;
    rh_vals = linspace(0,360,opt.n_rh+1); rh_vals = rh_vals(2:end);
    avg_th = sum(th_vals)/opt.n_th; assert( abs(avg_th - opt.lth/2) < 1e-10 );

    for th = th_vals
        for rh = rh_vals
            R1 = axang2rotm([h1 th/180*pi]);
            R2 = axang2rotm([ld rh/180*pi]);
            rd = (R2*R1*ld')'; % ray direction
            
            if  opt.debugPlot
                quiver3(lp(:,1),lp(:,2),lp(:,3), rd(:,1),rd(:,2),rd(:,3), 'g');
            end

            for k = 1:size(el,1)
                [isHit, u, v, d] = rayTriangleIntersection(lp, rd, co(el(k,1),:), co(el(k,2),:), co(el(k,3),:));
                if  isHit && d>0
                    if  opt.debugPlot
                        hx = co(el(k,1),:) + u*(co(el(k,2),:)-co(el(k,1),:)) + v*(co(el(k,3),:)-co(el(k,1),:));
                        plot3(hx(1),hx(2),hx(3),'bo');
                    end

                    % distribute 1/(opt.n_th*opt.n_rh) of the total radiative power to the three nodes
                    if  th>(opt.lth-opt.edge_th)
                        blend = (opt.lth-th)/(opt.edge_th); 
                    else
                        blend = 1;
                    end
                    ph = 1/(opt.n_th*opt.n_rh) * (th / avg_th) * blend;
                    if  isfield(opt, 'specular')
                        ps = projectSpecularReflection(el,co, k,u,v,rd,ph, opt);
                        pw(el(k,1),:) = pw(el(k,1),:) + (1-u-v)*ps;
                        pw(el(k,2),:) = pw(el(k,2),:) +    u   *ps;
                        pw(el(k,3),:) = pw(el(k,3),:) +      v *ps;
                    else
                        pw(el(k,1)) = pw(el(k,1)) + (1-u-v)*ph;
                        pw(el(k,2)) = pw(el(k,2)) +    u   *ph;
                        pw(el(k,3)) = pw(el(k,3)) +      v *ph;
                    end
                    break; % end loop once we've found an intersection
                end
            end
        end
    end
    
    %pw = M\pw; % L2-projection
    pw = (M+opt.smoothing*L)\pw; % L2-projection with some smoothing

    
    % forward step done, now adjoint step ...
    if  isempty(pw_target)
        phi=-1;dphidp=0; % no target - stop after forward step
    else
        % evaluate objective
        [phi, dphidpw] = mytestObjective(el,co, pw,pw_target);
%         dphidpw=M\dphidpw;  % L2-projection of partials
        dphidpw = (M+opt.smoothing*L)\dphidpw; % L2-projection with some smoothing
        
        % adjoint derivative
        dphidp = [0 0 0]; % 3 parameters (light position x,y,z)
        for th = th_vals
            for rh = rh_vals
                R1 = axang2rotm([h1 th/180*pi]);
                R2 = axang2rotm([ld rh/180*pi]);
                rd = (R2*R1*ld')'; % ray direction

                for k = 1:size(el,1)
                    [isHit, u, v, rl] = rayTriangleIntersection(lp, rd, co(el(k,1),:), co(el(k,2),:), co(el(k,3),:));
                    if  isHit && rl>0

                        n = cross( co(el(k,2),:)-co(el(k,1),:) , co(el(k,3),:)-co(el(k,1),:) );
                        n = n./norm(n);
                        qpx = [1-u-v , u , v] * co(el(k,:),:);

                        if  th>(opt.lth-opt.edge_th)
                            blend = (opt.lth-th)/(opt.edge_th); 
                            dblenddp = blendFcnDerivative( opt.edge_th , ld(1),ld(2),ld(3),lp(1),lp(2),lp(3),qpx(1),qpx(2),qpx(3));
                        else
                            blend = 1; dblenddp = 0;
                        end
                        
%                         if th>=(lth-5), blend = (lth-th)/5; else, blend=1; end
                        ph = 1/(opt.n_th*opt.n_rh) * (th / avg_th) * blend;
                        rayWeight = ph / (blend*dot(n,-rd))*(rl*rl);
                        assert(abs(  ph - rayWeight * blend*dot(n,-rd)/(rl*rl) )<1e-14 );
                        dphdp = rayWeight *blend* geometricDerivative(lp(1),lp(2),lp(3),n(1),n(2),n(3),qpx(1),qpx(2),qpx(3)) ...
                              + rayWeight *dot(n,-rd)/(rl*rl)*dblenddp;
                        if  isfield(opt, 'specular')
%                             ps = projectSpecularReflection(el,co, k,u,v,rd,ph, opt);
                        else
                            dphidp = dphidp + (dphidpw(el(k,:))' * [1-u-v ; u ; v]*dphdp');
%                             dphidp = dphidp + dphidpw(el(k,1))*(1-u-v)*dphdp'; % same as above
%                             dphidp = dphidp + dphidpw(el(k,2))*(  u  )*dphdp';
%                             dphidp = dphidp + dphidpw(el(k,3))*(    v)*dphdp';
                        end
                    end
                end
            end
        end
    end
    
    if ~opt.debugPlot,  figure; end
    trisurf(el,co(:,1),co(:,2),co(:,3),pw(:,1)); axis equal; shading interp;
    colormap('hot'); caxis([min(pw(:)) max(pw(:))]);
    %%
    if  isfield(opt, 'specular')
        hold on;
        for i = 1:size(co,1)
            trisurf(opt.usph_el, ...
                opt.usph_co(:,1)*opt.specularDrawScale+co(i,1), ...
                opt.usph_co(:,2)*opt.specularDrawScale+co(i,2), ...
                opt.usph_co(:,3)*opt.specularDrawScale+co(i,3), ...
                pw(i,1)+pw(i,2:end),'FaceAlpha',1); axis equal; shading interp;
            colormap('hot');
        end
        for k = 1:size(el,1)
            trisurf(opt.usph_el, ...
                opt.usph_co(:,1)*opt.specularDrawScale+(co(el(k,1),1)+co(el(k,2),1)+co(el(k,3),1))./3, ...
                opt.usph_co(:,2)*opt.specularDrawScale+(co(el(k,1),2)+co(el(k,2),2)+co(el(k,3),2))./3, ...
                opt.usph_co(:,3)*opt.specularDrawScale+(co(el(k,1),3)+co(el(k,2),3)+co(el(k,3),3))./3, ...
                (pw(el(k,1),1)+pw(el(k,2),1)+pw(el(k,3),1))./3+(pw(el(k,1),2:end)+pw(el(k,2),2:end)+pw(el(k,3),2:end))./3,...
                'FaceAlpha',1); axis equal; shading interp;
            colormap('hot');
        end
        caxis([0 max(max(pw(:,1)+pw(:,2:end)))]); hold off;
    end
    
    view(140,20); drawnow;
%     saveas(gcf,['_img/lightpos_' num2str(opt.lightDisplacement(1)) '.png']);
end



function [pw, dpwdx,dpwdy,dpwdz] = mytestDirect(el,co, opt)
    M = consistentMass(el,co);
    L = laplacianP1tri(el,co);
    geometricDerivative = @(lp1,lp2,lp3,n1,n2,n3,qp1,qp2,qp3)[n1.*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(3.0./2.0)-(lp1.*2.0-qp1.*2.0).*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(5.0./2.0).*(lp1.*n1+lp2.*n2+lp3.*n3-n1.*qp1-n2.*qp2-n3.*qp3).*(3.0./2.0);n2.*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(3.0./2.0)-(lp2.*2.0-qp2.*2.0).*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(5.0./2.0).*(lp1.*n1+lp2.*n2+lp3.*n3-n1.*qp1-n2.*qp2-n3.*qp3).*(3.0./2.0);n3.*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(3.0./2.0)-(lp3.*2.0-qp3.*2.0).*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(5.0./2.0).*(lp1.*n1+lp2.*n2+lp3.*n3-n1.*qp1-n2.*qp2-n3.*qp3).*(3.0./2.0)];
    blendFcnDerivative  = @(edgeAngle,ld1,ld2,ld3,lp1,lp2,lp3,qp1,qp2,qp3)[(1.0./sqrt(-(ld1.*lp1+ld2.*lp2+ld3.*lp3-ld1.*qp1-ld2.*qp2-ld3.*qp3).^2./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2)+1.0).*(ld1.*1.0./sqrt((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2)-(lp1.*2.0-qp1.*2.0).*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(3.0./2.0).*(ld1.*lp1+ld2.*lp2+ld3.*lp3-ld1.*qp1-ld2.*qp2-ld3.*qp3).*(1.0./2.0)).*-1.8e2)./(edgeAngle.*pi);(1.0./sqrt(-(ld1.*lp1+ld2.*lp2+ld3.*lp3-ld1.*qp1-ld2.*qp2-ld3.*qp3).^2./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2)+1.0).*(ld2.*1.0./sqrt((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2)-(lp2.*2.0-qp2.*2.0).*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(3.0./2.0).*(ld1.*lp1+ld2.*lp2+ld3.*lp3-ld1.*qp1-ld2.*qp2-ld3.*qp3).*(1.0./2.0)).*-1.8e2)./(edgeAngle.*pi);(1.0./sqrt(-(ld1.*lp1+ld2.*lp2+ld3.*lp3-ld1.*qp1-ld2.*qp2-ld3.*qp3).^2./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2)+1.0).*(ld3.*1.0./sqrt((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2)-(lp3.*2.0-qp3.*2.0).*1.0./((lp1-qp1).^2+(lp2-qp2).^2+(lp3-qp3).^2).^(3.0./2.0).*(ld1.*lp1+ld2.*lp2+ld3.*lp3-ld1.*qp1-ld2.*qp2-ld3.*qp3).*(1.0./2.0)).*-1.8e2)./(edgeAngle.*pi)];


    dataPerNode = 1;
    if  isfield(opt, 'specular')
        tmp = projectSpecularReflection([],[],-1,[],[],[],[],opt);
        dataPerNode = length(tmp);
    end
    pw = zeros(size(co,1),dataPerNode);
    dpwdx = pw; dpwdy = pw; dpwdz = pw; % derivatives of radiative power wrt. light position

    if  opt.debugPlot
        figure; trimesh(el,co(:,1),co(:,2),co(:,3),'FaceAlpha',0,'EdgeAlpha',0.2,'EdgeColor','k'); axis equal; hold on;
    end

    lp = [0.1,3,-0.2];
    if  isfield(opt,'lightDisplacement')
        lp = lp + opt.lightDisplacement;
    end
    [ldx,ldy,ldz] = sph2cart(-pi/2,0 ,1); ld = [ldx,ldy,ldz]; clear ldx ldy ldz;

    if  opt.debugPlot
        quiver3(lp(:,1),lp(:,2),lp(:,3), ld(:,1),ld(:,2),ld(:,3));
    end

    h1=simplePerpendicularVector(ld);
    h1=h1./norm(h1);

    th_vals = linspace(0,opt.lth,opt.n_th+1); th_vals = th_vals(2:end)-(th_vals(2)-th_vals(1))*0.5;
    rh_vals = linspace(0,360,opt.n_rh+1); rh_vals = rh_vals(2:end);
    avg_th = sum(th_vals)/opt.n_th; assert( abs(avg_th - opt.lth/2) < 1e-10 );

    for th = th_vals
        for rh = rh_vals
            R1 = axang2rotm([h1 (th)/180*pi]);
            R2 = axang2rotm([ld (rh)/180*pi]);
            rd = (R2*R1*ld')'; % ray direction
            
            if  opt.debugPlot
                quiver3(lp(:,1),lp(:,2),lp(:,3), rd(:,1),rd(:,2),rd(:,3), 'g');
            end

            for k = 1:size(el,1)
                [isHit, u, v, d] = rayTriangleIntersection (lp, rd, co(el(k,1),:), co(el(k,2),:), co(el(k,3),:));
                if  isHit && d>0
                    if  opt.debugPlot
                        hx = co(el(k,1),:) + u*(co(el(k,2),:)-co(el(k,1),:)) + v*(co(el(k,3),:)-co(el(k,1),:));
                        plot3(hx(1),hx(2),hx(3),'bo');
                    end

                    n = cross( co(el(k,2),:)-co(el(k,1),:) , co(el(k,3),:)-co(el(k,1),:) );
                    % unused ... ar = 0.5*norm(n);
                    n = n./norm(n);
                    qpx = [1-u-v , u , v] * co(el(k,:),:);
                    % already done ... rd = qpx-lp;
                    % rl = norm(rd); % == d
                    % rd = rd./rl;
                    rl = d;

                    % can't be outside of cone ... if  dot(rd,ld)>cos(lth/180*pi) % cos( light angle ) > spot cone
                    if  th>(opt.lth-opt.edge_th)
                        blend = (opt.lth-th)/(opt.edge_th); 
                        dblenddp = blendFcnDerivative( opt.edge_th , ld(1),ld(2),ld(3),lp(1),lp(2),lp(3),qpx(1),qpx(2),qpx(3));
                    else
                        blend = 1; dblenddp = 0;
                    end

                    % distribute 1/(opt.n_th*opt.n_rh) of the total radiative power to the three nodes
%                     ph = 1/(opt.n_th*opt.n_rh);
                    % if th>=(lth-5), blend = (lth-th)/5; else, blend=1; end
                    ph = 1/(opt.n_th*opt.n_rh) * (th / avg_th)* blend;

                    % assume that ph = rayWeight * blend*dot(n,-rd)/(rl*rl) as in reverseRays case, with some constant rayWeight
                    % then we have ...
                    rayWeight = ph / (blend*dot(n,-rd))*(rl*rl);
                    assert(abs(  ph - rayWeight * blend*dot(n,-rd)/(rl*rl) )<1e-14 );

                    if  isfield(opt, 'specular')
%                         ps = projectSpecularReflection(el,co, k,u,v,rd,ph, opt);
                        % ... later
                    else
                        pw(el(k,:)) = pw(el(k,:)) + [1-u-v ; u ; v]*ph;
                        % gradient evaluation wrt. light position
                        % from live script ... d/dp(dot(n,-rd)/(rl*rl))
                        dphdp = rayWeight *blend* geometricDerivative(lp(1),lp(2),lp(3),n(1),n(2),n(3),qpx(1),qpx(2),qpx(3)) ...
                              + rayWeight *dot(n,-rd)/(rl*rl)*dblenddp;

                        dpwdx(el(k,:)) = dpwdx(el(k,:)) + [1-u-v ; u ; v]*dphdp(1);
                        dpwdy(el(k,:)) = dpwdy(el(k,:)) + [1-u-v ; u ; v]*dphdp(2);
                        dpwdz(el(k,:)) = dpwdz(el(k,:)) + [1-u-v ; u ; v]*dphdp(3);

                    end
                    
                    
                    break; % end loop once we've found an intersection
                end
            end
        end
    end
    
%     pw=M\pw;
%     dpwdx=M\dpwdx;
%     dpwdy=M\dpwdy;
%     dpwdz=M\dpwdz;

    pw = (M+opt.smoothing*L)\pw; % L2-projection with some smoothing
    dpwdx = (M+opt.smoothing*L)\dpwdx;
    dpwdy = (M+opt.smoothing*L)\dpwdy;
    dpwdz = (M+opt.smoothing*L)\dpwdz;
    
    if ~opt.debugPlot,  figure; end
    trisurf(el,co(:,1),co(:,2),co(:,3),pw(:,1)); axis equal; shading interp;
    colormap('hot'); caxis([min(pw(:)) max(pw(:))]);
    %%
    if  isfield(opt, 'specular')
        hold on;
        for i = 1:size(co,1)
            trisurf(opt.usph_el, ...
                opt.usph_co(:,1)*opt.specularDrawScale+co(i,1), ...
                opt.usph_co(:,2)*opt.specularDrawScale+co(i,2), ...
                opt.usph_co(:,3)*opt.specularDrawScale+co(i,3), ...
                pw(i,1)+pw(i,2:end),'FaceAlpha',1); axis equal; shading interp;
            colormap('hot');
        end
        for k = 1:size(el,1)
            trisurf(opt.usph_el, ...
                opt.usph_co(:,1)*opt.specularDrawScale+(co(el(k,1),1)+co(el(k,2),1)+co(el(k,3),1))./3, ...
                opt.usph_co(:,2)*opt.specularDrawScale+(co(el(k,1),2)+co(el(k,2),2)+co(el(k,3),2))./3, ...
                opt.usph_co(:,3)*opt.specularDrawScale+(co(el(k,1),3)+co(el(k,2),3)+co(el(k,3),3))./3, ...
                (pw(el(k,1),1)+pw(el(k,2),1)+pw(el(k,3),1))./3+(pw(el(k,1),2:end)+pw(el(k,2),2:end)+pw(el(k,3),2:end))./3,...
                'FaceAlpha',1); axis equal; shading interp;
            colormap('hot');
        end
        caxis([0 max(max(pw(:,1)+pw(:,2:end)))]); hold off;
    end
    
    view(140,20); drawnow;
%     saveas(gcf,['_img/lightpos_' num2str(opt.lightDisplacement(1)) '.png']);
end


