clc; clear variables;
obj = read_wobj('tilted_plane.obj');
co = obj.vertices;
el = obj.objects( [obj.objects(:).type]=='f' ).data.vertices;
[ed, edg_idx] = edgeMap(el);
edg_ctr = 0.5 * (co(edg_idx(:,1),:) + co(edg_idx(:,2),:));

% ToDo: update specular to work with P2 elems in space
% ToDo: also use P2 elems in angular representation
% opt.specular=0.6; % ratio of specular reflection (diffuse will be 1-s)
% opt.specularDrawScale=0.06; % size of specular balls in plots
% [opt.usph_el, opt.usph_co] = readIcoSphereFromMesh();

opt.debugPlot = 0;
opt.smoothing = 0;%0.005; %  add some Laplacian smoothing to the result
opt.edg_ctr = edg_ctr; % for quick (ugly) plots
opt.n_th = 15;
opt.n_rh = 36;

opt.lightDisplacement = [-0.5 0 0.5];
pw_target = mytestAdjoint(el,ed,co, opt, []);
title('target'); drawnow;

% -------------------------------------------------------------------------
% integrate pw over mesh == should equal 1
% -------------------------------------------------------------------------
[qp,qw] = gaussQuadratureTri();

int_pw = 0; pw = pw_target;
for k = 1:size(el,1)
    ar = 0.5*( norm(cross( co(el(k,2),:)-co(el(k,1),:) , co(el(k,3),:)-co(el(k,1),:) )));
    gdofs = [el(k,:) , size(co,1) + ed(k,:)]; % first node-DOFs then edge-DOFs
    for i = 1:size(qp,1)
        w = shapeFcnP2tri(co( el(k,:), :), qp(i,:)' );
        int_pw = int_pw + ar*qw(i)*(w'*pw(gdofs));
    end
end
sum(int_pw) % ToDo: also use L2-projection (or spherical harmonic projection) in specular case - and compare by integrating specular power over unit sphere
% -------------------------------------------------------------------------

if  0
    %%
    L = laplacianP2tri(el,co,ed);
    M = consistentMassP2tri(el,ed,co);
    pw=(M+0.01*L)\(M*pw); % some smoothing (just for plotting)
    %%
    % -------------------------------------------------------------------------
    % nicer plot ...
    % -------------------------------------------------------------------------
    [s,t] = meshgrid(0:0.02:1);
    t( (s+t)>1 ) = 1-s( (s+t)>1 );
    figure; maxC=0;
    for k = 1:size(el,1)
        gdofs = [el(k,:) , size(co,1) + ed(k,:)]; % first node-DOFs then edge-DOFs
        x = co(el(k,1),1)*(1-s-t) + co(el(k,2),1)*s + co(el(k,3),1)*t;
        y = co(el(k,1),2)*(1-s-t) + co(el(k,2),2)*s + co(el(k,3),2)*t;
        z = co(el(k,1),3)*(1-s-t) + co(el(k,2),3)*s + co(el(k,3),3)*t;
        c = 0*s;
        for i=1:size(s,1)
            for j=1:size(s,2)
                w = shapeFcnP2tri(co( el(k,:), :), [1-s(i,j)-t(i,j) ; s(i,j) ; t(i,j)] );
                c(i,j) = w'*pw(gdofs);
            end
        end
        maxC = max( maxC, max(max(c)) );
        surf(x,y,z,c); shading interp; hold on;
    end
    trimesh(el,co(:,1),co(:,2),co(:,3),'EdgeColor','k','EdgeAlpha',0.2,'FaceAlpha',0);
    colormap('hot'); caxis([min(pw(:)) max(pw(:))]); axis equal; view(140,20);
    % -------------------------------------------------------------------------
end

%%
close all;
pw_target = 0*pw_target + 0.5;
% --- 0.5 const target has issue with wrong gradients (disconst. brightness chg. as rays cross edges) around iter 150 (grad.desc. scale 1.0)
% --- small FD steps agree with gradient calcs - can't "see" these discont. jumps locally!
% *** this problem seems to be much less pronounced with P2 elements

%%
p = [0 0 0];
phi_iters = [];
%%
for j=1:150
    opt.lightDisplacement = p;
    
    [pw, dpwdx,dpwdy,dpwdz] = mytestDirect(el,ed,co, opt); %close(gcf);
    [phi, dphidpw] = mytestObjective(el,ed,co, pw, pw_target);
    dphidp = (dphidpw(:)') * [dpwdx(:), dpwdy(:), dpwdz(:)];
    
    if  j==1
        [pw_adj, phi_adj, dphidp_adj] = mytestAdjoint(el,ed,co,opt, pw_target);

        % compare direct and adjoint calculations -- works
        disp('(pw, phi, dphidp) direct-adjoint abs err:');
        disp([max(abs(pw(:)-pw_adj(:)))  max(abs(phi(:)-phi_adj(:)))  max(abs(dphidp(:)-dphidp_adj(:)))]);
    end
    
    % run FD check
    fd_h=1e-8;
    dphidp_fd = [0 0 0];
    if  j==1 % works
        disp('FD-check ...');
        for l=1:length(dphidp_fd)
            opt.lightDisplacement = p;
            opt.lightDisplacement(l) = opt.lightDisplacement(l) + fd_h;
            pw_fd  = mytestAdjoint(el,ed,co, opt, []);
            phi_fd = mytestObjective(el,ed,co, pw_fd, pw_target);
            dphidp_fd(l) = (phi_fd - phi) / fd_h;
        end
        disp('abs err (grad-fd):');
        disp(abs(dphidp - dphidp_fd));
        disp('grad, fd:');
        disp(dphidp);
        disp(dphidp_fd);
        disp('... done');
    end

    
    title(['step ' num2str(j,'%3u') ', p = [' num2str(p,'%.3f, ') ']']);  drawnow;
%     saveas(gcf,['_img/grad_desc_' num2str(j,'%03u') '.png']);
    phi_iters = [phi_iters; phi]; %#ok
    
    p = p - 0.2*dphidp; % basic gradient descent step
end

figure; plot(phi_iters);


%
%
%% functions ...

function [phi, dphidpw] = mytestObjective(el,ed,co, pw, pw_target)
%     phi = 0.5*sum((pw(:)-pw_target(:)).^2);
%     dphidpw = pw-pw_target;

    [qp,qw] = gaussQuadratureTri();
    phi = 0;
    dphidpw = 0*pw_target;

    for k = 1:size(el,1)
        ar = 0.5*( norm(cross( co(el(k,2),:)-co(el(k,1),:) , co(el(k,3),:)-co(el(k,1),:) )));
        gdofs = [el(k,:) , size(co,1) + ed(k,:)]; % first node-DOFs then edge-DOFs
        for i = 1:size(qp,1)
            w = shapeFcnP2tri(co( el(k,:), :), qp(i,:)' );
%             int_pw = int_pw + ar*qw(i)*(w'*pw(gdofs));
            
            phi = phi + 0.5*ar*qw(i)*((w'*pw(gdofs)-w'*pw_target(gdofs)).^2); %ToDo: also integrate specular components over unit sphere instead of summing
            dphidpw(gdofs,:) = dphidpw(gdofs,:) + ar*qw(i)*(w'*(pw(gdofs)-pw_target(gdofs)))*w;
        end
    end

%     % integrate over elements (midpoint rule -- is midpoint exact for second order???)
%     for k=1:size(el,1)
% %         % linear fcn within el --> avg. of corners * area
% %         avg = ( pw(el(k,1),:) + pw(el(k,2),:) +pw(el(k,3),:) ) / 3;
% %         avg_target = ( pw_target(el(k,1),:) + pw_target(el(k,2),:) +pw_target(el(k,3),:) ) / 3;
% %         ar = 0.5*( norm(cross( co(el(k,2),:)-co(el(k,1),:) , co(el(k,3),:)-co(el(k,1),:) ))); % element area
% %         
% %         phi = phi + 0.5*ar*sum((avg-avg_target).^2); %ToDo: also integrate specular components over unit sphere instead of summing
% %         dphidpw(el(k,1),:) = dphidpw(el(k,1),:) + ar*(avg-avg_target)/3;
% %         dphidpw(el(k,2),:) = dphidpw(el(k,2),:) + ar*(avg-avg_target)/3;
% %         dphidpw(el(k,3),:) = dphidpw(el(k,3),:) + ar*(avg-avg_target)/3;
%     end

end


function [pw, phi, dphidp] = mytestAdjoint(el,ed,co, opt, pw_target)
    M = consistentMassP2tri(el,ed,co);
    L = laplacianP2tri(el,co,ed);
    n_dofs = size(M,1);
    dataPerNode = 1;
    if  isfield(opt, 'specular')
        tmp = projectSpecularReflection([],[],-1,[],[],[],[],opt);
        dataPerNode = length(tmp);
    end
    pw = zeros(n_dofs,dataPerNode);

    if  opt.debugPlot
        figure; trimesh(el,co(:,1),co(:,2),co(:,3),'FaceAlpha',0,'EdgeAlpha',0.2,'EdgeColor','k'); axis equal; hold on;
    end

    lp = [0.1,3,-0.2];
    if  isfield(opt,'lightDisplacement')
        lp = lp + opt.lightDisplacement;
    end
    [ldx,ldy,ldz] = sph2cart(-pi/2,0,1); ld = [ldx,ldy,ldz]; clear ldx ldy ldz;
    lth= 15; % deg

    if  opt.debugPlot
        quiver3(lp(:,1),lp(:,2),lp(:,3), ld(:,1),ld(:,2),ld(:,3));
    end

    h1=simplePerpendicularVector(ld);
    h1=h1./norm(h1);

    th_vals = linspace(0,lth,opt.n_th+1); th_vals = th_vals(2:end);
    rh_vals = linspace(0,360,opt.n_rh+1); rh_vals = rh_vals(2:end);
    avg_th = sum(th_vals)/opt.n_th;

    for th = th_vals
        for rh = rh_vals
            R1 = axang2rotm([h1 th/180*pi]);
            R2 = axang2rotm([ld rh/180*pi]);
            rd = (R2*R1*ld')'; % ray direction
            
            if  opt.debugPlot
                quiver3(lp(:,1),lp(:,2),lp(:,3), rd(:,1),rd(:,2),rd(:,3), 'g');
            end

            for k = 1:size(el,1)
                [isHit, u, v, d] = rayTriangleIntersection(lp, rd, co(el(k,1),:), co(el(k,2),:), co(el(k,3),:));
                if  isHit && d>0
                    if  opt.debugPlot
                        hx = co(el(k,1),:) + u*(co(el(k,2),:)-co(el(k,1),:)) + v*(co(el(k,3),:)-co(el(k,1),:));
                        plot3(hx(1),hx(2),hx(3),'bo');
                    end

                    gdofs = [el(k,:) , size(co,1) + ed(k,:)];
                    w = shapeFcnP2tri(co( el(k,:), :), [1-u-v ; u ; v] );
                    if th>=(lth-5), blend = (lth-th)/5; else, blend=1; end
                    ph = 1/(opt.n_th*opt.n_rh) * (th / avg_th) * blend;
                    if  isfield(opt, 'specular')
%                         ps = projectSpecularReflection(el,co, k,u,v,rd,ph, opt);
%                         pw(el(k,1),:) = pw(el(k,1),:) + (1-u-v)*ps;
%                         pw(el(k,2),:) = pw(el(k,2),:) +    u   *ps;
%                         pw(el(k,3),:) = pw(el(k,3),:) +      v *ps;
                    else
                        pw(gdofs) = pw(gdofs) + w*ph;
                    end
                    break; % end loop once we've found an intersection
                end
            end
        end
    end
    
%     pw=M\pw; % L2-projection
    pw = (M+opt.smoothing*L)\pw; % L2-projection with some smoothing
    
    % forward step done, now adjoint step ...
    if  isempty(pw_target)
        phi=-1;dphidp=0; % no target - stop after forward step
    else
        % evaluate objective
        [phi, dphidpw] = mytestObjective(el,ed,co, pw,pw_target);
%         dphidpw=M\dphidpw;  % L2-projection of partials
        dphidpw = (M+opt.smoothing*L)\dphidpw; % L2-projection with some smoothing
        
        % adjoint derivative
        dphidp = [0 0 0]; % 3 parameters (light position x,y,z)
        for th = th_vals
            for rh = rh_vals
                R1 = axang2rotm([h1 th/180*pi]);
                R2 = axang2rotm([ld rh/180*pi]);
                rd = (R2*R1*ld')'; % ray direction

                for k = 1:size(el,1)
                    [isHit, u, v, d] = rayTriangleIntersection(lp, rd, co(el(k,1),:), co(el(k,2),:), co(el(k,3),:));
                    if  isHit && d>0
                        gdofs = [el(k,:) , size(co,1) + ed(k,:)];
                        [~,dw] = shapeFcnP2tri(co( el(k,:), :), [1-u-v ; u ; v] );
                        if th>=(lth-5), blend = (lth-th)/5; else, blend=1; end
                        ph = 1/(opt.n_th*opt.n_rh) * (th / avg_th) * blend;
                        if  isfield(opt, 'specular')
%                             ps = projectSpecularReflection(el,co, k,u,v,rd,ph, opt);
%                             %pw(el(k,1),:) = pw(el(k,1),:) + (1-u-v)*ps;
%                             dphidp(1) = dphidp(1) + dphidpw(el(k,1),:)*(-dudp(1)-dvdp(1))*ps';
%                             dphidp(2) = dphidp(2) + dphidpw(el(k,1),:)*(-dudp(2)-dvdp(2))*ps';
%                             dphidp(3) = dphidp(3) + dphidpw(el(k,1),:)*(-dudp(3)-dvdp(3))*ps';
%                             %pw(el(k,2),:) = pw(el(k,2),:) +    u   *ps;
%                             dphidp(1) = dphidp(1) + dphidpw(el(k,2),:)*( dudp(1)        )*ps';
%                             dphidp(2) = dphidp(2) + dphidpw(el(k,2),:)*( dudp(2)        )*ps';
%                             dphidp(3) = dphidp(3) + dphidpw(el(k,2),:)*( dudp(3)        )*ps';
%                             %pw(el(k,3),:) = pw(el(k,3),:) +      v *ps;
%                             dphidp(1) = dphidp(1) + dphidpw(el(k,3),:)*(         dvdp(1))*ps';
%                             dphidp(2) = dphidp(2) + dphidpw(el(k,3),:)*(         dvdp(2))*ps';
%                             dphidp(3) = dphidp(3) + dphidpw(el(k,3),:)*(         dvdp(3))*ps';
                        else
%                             dphidp = dphidp + dphidpw(el(k,1))*(-dudp-dvdp)*ph;
%                             dphidp = dphidp + dphidpw(el(k,2))*( dudp     )*ph;
%                             dphidp = dphidp + dphidpw(el(k,3))*(      dvdp)*ph;
                            e1 = co(el(k,2),:)-co(el(k,1),:);
                            e2 = co(el(k,3),:)-co(el(k,1),:);
                            n = cross(e1,e2); n = n./norm(n);
                            P = [n 0; eye(3) -rd'];
                            % x_= P\[dot(n,co(el(k,1),:)); lp']; % intersection ray and plane of tri (4th component is distance)
                            % x = P^-1 * (c;p) --> dxdp = P^-1 * (0; dpdp==eye(3))
                            dxdp = P\[zeros(1,3); eye(3)]; % derivative of intersection point in cartesian space (4th row is deriv. of distance) wrt. ray origin
                            dxdp = dxdp(1:3,1:3);
                            dwdp = dw'*dxdp;
                            dphidp = dphidp + dphidpw(gdofs)'*dwdp*ph;
                        end
                    end
                end
            end
        end
    end
    
    if ~opt.debugPlot,  figure; end
%     trisurf(el,co(:,1),co(:,2),co(:,3),pw(:,1)); axis equal; shading interp;
    h = trisurf([el; size(co,1)+ed], [co(:,1) ; opt.edg_ctr(:,1)], [co(:,2) ; opt.edg_ctr(:,2)], [co(:,3) ; opt.edg_ctr(:,3)], pw(:,1)); axis equal; shading interp; set(h, 'EdgeAlpha',0.1,'EdgeColor','k');

    colormap('hot'); caxis([min(pw(:)) max(pw(:))]);
    %%
    if  isfield(opt, 'specular')
        hold on;
        for i = 1:size(co,1)
            trisurf(opt.usph_el, ...
                opt.usph_co(:,1)*opt.specularDrawScale+co(i,1), ...
                opt.usph_co(:,2)*opt.specularDrawScale+co(i,2), ...
                opt.usph_co(:,3)*opt.specularDrawScale+co(i,3), ...
                pw(i,1)+pw(i,2:end),'FaceAlpha',1); axis equal; shading interp;
            colormap('hot');
        end
        for k = 1:size(el,1)
            trisurf(opt.usph_el, ...
                opt.usph_co(:,1)*opt.specularDrawScale+(co(el(k,1),1)+co(el(k,2),1)+co(el(k,3),1))./3, ...
                opt.usph_co(:,2)*opt.specularDrawScale+(co(el(k,1),2)+co(el(k,2),2)+co(el(k,3),2))./3, ...
                opt.usph_co(:,3)*opt.specularDrawScale+(co(el(k,1),3)+co(el(k,2),3)+co(el(k,3),3))./3, ...
                (pw(el(k,1),1)+pw(el(k,2),1)+pw(el(k,3),1))./3+(pw(el(k,1),2:end)+pw(el(k,2),2:end)+pw(el(k,3),2:end))./3,...
                'FaceAlpha',1); axis equal; shading interp;
            colormap('hot');
        end
        caxis([0 max(max(pw(:,1)+pw(:,2:end)))]); hold off;
    end
    
    view(140,20); drawnow;
%     saveas(gcf,['_img/lightpos_' num2str(opt.lightDisplacement(1)) '.png']);
end



function [pw, dpwdx,dpwdy,dpwdz] = mytestDirect(el,ed,co, opt)
    M = consistentMassP2tri(el,ed,co);
    L = laplacianP2tri(el,co,ed);
    n_dofs = size(M,1);
    dataPerNode = 1;
    if  isfield(opt, 'specular')
        tmp = projectSpecularReflection([],[],-1,[],[],[],[],opt);
        dataPerNode = length(tmp);
    end
    pw = zeros(n_dofs,dataPerNode);
    dpwdx = pw; dpwdy = pw; dpwdz = pw; % derivatives of radiative power wrt. light position

    if  opt.debugPlot
        figure; trimesh(el,co(:,1),co(:,2),co(:,3),'FaceAlpha',0,'EdgeAlpha',0.2,'EdgeColor','k'); axis equal; hold on;
    end

    lp = [0.1,3,-0.2];
    if  isfield(opt,'lightDisplacement')
        lp = lp + opt.lightDisplacement;
    end
    [ldx,ldy,ldz] = sph2cart(-pi/2,0,1); ld = [ldx,ldy,ldz]; clear ldx ldy ldz;
    lth= 15; % deg

    if  opt.debugPlot
        quiver3(lp(:,1),lp(:,2),lp(:,3), ld(:,1),ld(:,2),ld(:,3));
    end

    h1=simplePerpendicularVector(ld);
    h1=h1./norm(h1);

    th_vals = linspace(0,lth,opt.n_th+1); th_vals = th_vals(2:end);
    rh_vals = linspace(0,360,opt.n_rh+1); rh_vals = rh_vals(2:end);
    avg_th = sum(th_vals) / opt.n_th;

    for th = th_vals
        for rh = rh_vals
            R1 = axang2rotm([h1 th/180*pi]);
            R2 = axang2rotm([ld rh/180*pi]);
            rd = (R2*R1*ld')'; % ray direction
            
            if  opt.debugPlot
                quiver3(lp(:,1),lp(:,2),lp(:,3), rd(:,1),rd(:,2),rd(:,3), 'g');
            end

            for k = 1:size(el,1)
                [isHit, u, v, d] = rayTriangleIntersection(lp, rd, co(el(k,1),:), co(el(k,2),:), co(el(k,3),:));
                if  isHit && d>0
                    if  opt.debugPlot
                        hx = co(el(k,1),:) + u*(co(el(k,2),:)-co(el(k,1),:)) + v*(co(el(k,3),:)-co(el(k,1),:));
                        plot3(hx(1),hx(2),hx(3),'bo');
                    end
                    
                    gdofs  = [el(k,:) , size(co,1) + ed(k,:)];
                    [w,dw] = shapeFcnP2tri(co( el(k,:), :), [1-u-v ; u ; v] );
                    if th>=(lth-5), blend = (lth-th)/5; else, blend=1; end
                    ph = 1/(opt.n_th*opt.n_rh) * (th / avg_th) * blend;
                    if  isfield(opt, 'specular')
%                         ps = projectSpecularReflection(el,co, k,u,v,rd,ph, opt);
%                         pw(el(k,1),:) = pw(el(k,1),:) + (1-u-v)*ps;
%                         pw(el(k,2),:) = pw(el(k,2),:) +    u   *ps;
%                         pw(el(k,3),:) = pw(el(k,3),:) +      v *ps;
%                         % gradient evaluation wrt. light position
%                         dpwdx(el(k,1),:) = dpwdx(el(k,1),:) + (-dudp(1)-dvdp(1))*ps;
%                         dpwdx(el(k,2),:) = dpwdx(el(k,2),:) +   dudp(1)         *ps;
%                         dpwdx(el(k,3),:) = dpwdx(el(k,3),:) +           dvdp(1) *ps;
%                         dpwdy(el(k,1),:) = dpwdy(el(k,1),:) + (-dudp(2)-dvdp(2))*ps;
%                         dpwdy(el(k,2),:) = dpwdy(el(k,2),:) +   dudp(2)         *ps;
%                         dpwdy(el(k,3),:) = dpwdy(el(k,3),:) +           dvdp(2) *ps;
%                         dpwdz(el(k,1),:) = dpwdz(el(k,1),:) + (-dudp(3)-dvdp(3))*ps;
%                         dpwdz(el(k,2),:) = dpwdz(el(k,2),:) +   dudp(3)         *ps;
%                         dpwdz(el(k,3),:) = dpwdz(el(k,3),:) +           dvdp(3) *ps;
                    else
                        pw(gdofs) = pw(gdofs) + w*ph;
%                         % gradient evaluation wrt. light position
                        
                        e1 = co(el(k,2),:)-co(el(k,1),:);
                        e2 = co(el(k,3),:)-co(el(k,1),:);
                        n = cross(e1,e2); n = n./norm(n);
                        P = [n 0; eye(3) -rd'];
                        % x_= P\[dot(n,co(el(k,1),:)); lp']; % intersection ray and plane of tri (4th component is distance)
                        % x = P^-1 * (c;p) --> dxdp = P^-1 * (0; dpdp==eye(3))
                        dxdp = P\[zeros(1,3); eye(3)]; % derivative of intersection point in cartesian space (4th row is deriv. of distance) wrt. ray origin
                        dxdp = dxdp(1:3,1:3);
                        dwdp = dw'*dxdp;
                        dpwdx(gdofs) = dpwdx(gdofs) + dwdp(:,1)*ph;
                        dpwdy(gdofs) = dpwdy(gdofs) + dwdp(:,2)*ph;
                        dpwdz(gdofs) = dpwdz(gdofs) + dwdp(:,3)*ph;
                        
%                         % try adding "invisible" gradient along ray direction
%                         % this will break finite-difference checks
%                         % let's hope it improves optimisation performance
%                         % note: 'd' is distance along the ray (origin to intersection)
%                         dpwdd = -1*ph./d; % ToDo: explain why *1 works better than *2 ??? ... assume there is a constant c0 such that ph = c0/(r^2), then d(ph)/dr = -2*c0/(r^3) = -2/r*ph
%                         dddp = -rd;% already normalized ./norm(rd); % derivative of distance is direction
%                         dpwdx(gdofs) = dpwdx(gdofs) + w*dddp(1)*dpwdd;
%                         dpwdy(gdofs) = dpwdy(gdofs) + w*dddp(2)*dpwdd;
%                         dpwdz(gdofs) = dpwdz(gdofs) + w*dddp(3)*dpwdd;
                    end
                    
                    
                    break; % end loop once we've found an intersection
                end
            end
        end
    end
    
%     pw=M\pw;
%     dpwdx=M\dpwdx;
%     dpwdy=M\dpwdy;
%     dpwdz=M\dpwdz;
    pw = (M+opt.smoothing*L)\pw; % L2-projection with some smoothing
    dpwdx = (M+opt.smoothing*L)\dpwdx;
    dpwdy = (M+opt.smoothing*L)\dpwdy;
    dpwdz = (M+opt.smoothing*L)\dpwdz;
    
    if ~opt.debugPlot,  figure; end
    trisurf(el,co(:,1),co(:,2),co(:,3),pw(1:size(co,1),1)); axis equal; shading interp;
    colormap('hot'); caxis([min(pw(:)) max(pw(:))]);
    %%
    if  isfield(opt, 'specular')
        hold on;
        for i = 1:size(co,1)
            trisurf(opt.usph_el, ...
                opt.usph_co(:,1)*opt.specularDrawScale+co(i,1), ...
                opt.usph_co(:,2)*opt.specularDrawScale+co(i,2), ...
                opt.usph_co(:,3)*opt.specularDrawScale+co(i,3), ...
                pw(i,1)+pw(i,2:end),'FaceAlpha',1); axis equal; shading interp;
            colormap('hot');
        end
        for k = 1:size(el,1)
            trisurf(opt.usph_el, ...
                opt.usph_co(:,1)*opt.specularDrawScale+(co(el(k,1),1)+co(el(k,2),1)+co(el(k,3),1))./3, ...
                opt.usph_co(:,2)*opt.specularDrawScale+(co(el(k,1),2)+co(el(k,2),2)+co(el(k,3),2))./3, ...
                opt.usph_co(:,3)*opt.specularDrawScale+(co(el(k,1),3)+co(el(k,2),3)+co(el(k,3),3))./3, ...
                (pw(el(k,1),1)+pw(el(k,2),1)+pw(el(k,3),1))./3+(pw(el(k,1),2:end)+pw(el(k,2),2:end)+pw(el(k,3),2:end))./3,...
                'FaceAlpha',1); axis equal; shading interp;
            colormap('hot');
        end
        caxis([0 max(max(pw(:,1)+pw(:,2:end)))]); hold off;
    end
    
    view(140,20); drawnow;
%     saveas(gcf,['_img/lightpos_' num2str(opt.lightDisplacement(1)) '.png']);
end


