clc; clear variables;
obj = read_wobj('tilted_plane.obj');
co = obj.vertices;
el = obj.objects( [obj.objects(:).type]=='f' ).data.vertices;
% trimesh(el,co(:,1),co(:,2),co(:,3),'FaceAlpha',0,'EdgeAlpha',0.2,'EdgeColor','k');
% opt.specular=0.7; % ratio of specular reflection (diffuse will be 1-s)
% opt.specularDrawScale=0.07; % size of specular balls in plots
[opt.usph_el, opt.usph_co] = readIcoSphereFromMesh();

opt.debugPlot = 0;
%%
for l=-0.2:0.1:0.4
    opt.lightDisplacement = [l 0 0];
    %%
    [pw, dpwdx,dpwdy,dpwdz] = mytest(el,co, opt);
    sum(sum(pw))
    hold on; axis manual; quiver3(co(:,1),co(:,2),co(:,3), dpwdx,dpwdy,dpwdz, 0, 'LineWidth',2);
end

%%
opt.lightDisplacement = [-0.5 0 0.5];
pw_target = mytest(el,co, opt);
title('target');

for vw = 40:10:200
    view(vw,20); drawnow;
    saveas(gcf,['_img/target_view_' num2str(vw,'%03u') '.png']);
end

p = [0 0 0];
for j=1:50
    [phi, dphidp] = mytestObjective(p, pw_target, el,co,opt) %#ok
    title(['step ' num2str(j,'%3u') ', p = [' num2str(p,'%.3f, ') ']']);
    saveas(gcf,['_img/grad_desc_' num2str(j,'%03u') '.png']);
    p = p - dphidp; % basic gradient descent step
end

for vw = 40:10:200
    view(vw,20); drawnow;
    saveas(gcf,['_img/result_view_' num2str(vw,'%3u') '.png']);
end



%%
function [phi, dphidp] = mytestObjective(p, pw_target, el,co,opt)
    opt.lightDisplacement = p;
    [pw, dpwdx,dpwdy,dpwdz] = mytest(el,co, opt);
    phi = 0.5*sum((pw(:)-pw_target(:)).^2);
    dphidpw = pw-pw_target;
    dphidp = (dphidpw(:)') * [dpwdx(:), dpwdy(:), dpwdz(:)];
end


function [pw, dpwdx,dpwdy,dpwdz] = mytest(el,co, opt)
    dataPerNode = 1;
    if  isfield(opt, 'specular')
        tmp = projectSpecularReflection([],[],-1,[],[],[],[],opt);
        dataPerNode = length(tmp);
    end
    pw = zeros(size(co,1),dataPerNode);
    dpwdx = pw; dpwdy = pw; dpwdz = pw; % derivatives of radiative power wrt. light position

    if  opt.debugPlot
        figure; trimesh(el,co(:,1),co(:,2),co(:,3),'FaceAlpha',0,'EdgeAlpha',0.2,'EdgeColor','k'); axis equal; hold on;
    end

    lp = [0.1,3,-0.2];
    if  isfield(opt,'lightDisplacement')
        lp = lp + opt.lightDisplacement;
    end
    [ldx,ldy,ldz] = sph2cart(-pi/2,0,1); ld = [ldx,ldy,ldz]; clear ldx ldy ldz;
    lth= 15; % deg

    if  opt.debugPlot
        quiver3(lp(:,1),lp(:,2),lp(:,3), ld(:,1),ld(:,2),ld(:,3));
    end

    h1=simplePerpendicularVector(ld);
    h1=h1./norm(h1);

    n_th = 15; n_rh=36;
    th_vals = linspace(0,lth,n_th+1); th_vals = th_vals(2:end);
    rh_vals = linspace(0,360,n_rh+1); rh_vals = rh_vals(2:end);

    for th = th_vals
        for rh = rh_vals
            R1 = axang2rotm([h1 th/180*pi]);
            R2 = axang2rotm([ld rh/180*pi]);
            rd = (R2*R1*ld')'; % ray direction
            
            if  opt.debugPlot
                quiver3(lp(:,1),lp(:,2),lp(:,3), rd(:,1),rd(:,2),rd(:,3), 'g');
            end

            for k = 1:size(el,1)
                [isHit, u, v, d, dudp,dvdp] = rayTriangleIntersectionWithDerivative (lp, rd, co(el(k,1),:), co(el(k,2),:), co(el(k,3),:));
                if  isHit && d>0
                    if  opt.debugPlot
                        hx = co(el(k,1),:) + u*(co(el(k,2),:)-co(el(k,1),:)) + v*(co(el(k,3),:)-co(el(k,1),:));
                        plot3(hx(1),hx(2),hx(3),'bo');
                    end

                    % distribute 1/(n_th*n_rh) of the total radiative power to the three nodes
                    ph = 1/(n_th*n_rh);
                    if  isfield(opt, 'specular')
                        ps = projectSpecularReflection(el,co, k,u,v,rd,ph, opt);
                        pw(el(k,1),:) = pw(el(k,1),:) + (1-u-v)*ps;
                        pw(el(k,2),:) = pw(el(k,2),:) +    u   *ps;
                        pw(el(k,3),:) = pw(el(k,3),:) +      v *ps;
                        % gradient evaluation wrt. light position
                        dpwdx(el(k,1),:) = dpwdx(el(k,1),:) + (-dudp(1)-dvdp(1))*ps;
                        dpwdx(el(k,2),:) = dpwdx(el(k,2),:) +   dudp(1)         *ps;
                        dpwdx(el(k,3),:) = dpwdx(el(k,3),:) +           dvdp(1) *ps;
                        dpwdy(el(k,1),:) = dpwdy(el(k,1),:) + (-dudp(2)-dvdp(2))*ps;
                        dpwdy(el(k,2),:) = dpwdy(el(k,2),:) +   dudp(2)         *ps;
                        dpwdy(el(k,3),:) = dpwdy(el(k,3),:) +           dvdp(2) *ps;
                        dpwdz(el(k,1),:) = dpwdz(el(k,1),:) + (-dudp(3)-dvdp(3))*ps;
                        dpwdz(el(k,2),:) = dpwdz(el(k,2),:) +   dudp(3)         *ps;
                        dpwdz(el(k,3),:) = dpwdz(el(k,3),:) +           dvdp(3) *ps;
                    else
                        pw(el(k,1)) = pw(el(k,1)) + (1-u-v)*ph;
                        pw(el(k,2)) = pw(el(k,2)) +    u   *ph;
                        pw(el(k,3)) = pw(el(k,3)) +      v *ph;
                        % gradient evaluation wrt. light position
                        dpwdx(el(k,1)) = dpwdx(el(k,1)) + (-dudp(1)-dvdp(1))*ph;
                        dpwdx(el(k,2)) = dpwdx(el(k,2)) +   dudp(1)         *ph;
                        dpwdx(el(k,3)) = dpwdx(el(k,3)) +           dvdp(1) *ph;
                        dpwdy(el(k,1)) = dpwdy(el(k,1)) + (-dudp(2)-dvdp(2))*ph;
                        dpwdy(el(k,2)) = dpwdy(el(k,2)) +   dudp(2)         *ph;
                        dpwdy(el(k,3)) = dpwdy(el(k,3)) +           dvdp(2) *ph;
                        dpwdz(el(k,1)) = dpwdz(el(k,1)) + (-dudp(3)-dvdp(3))*ph;
                        dpwdz(el(k,2)) = dpwdz(el(k,2)) +   dudp(3)         *ph;
                        dpwdz(el(k,3)) = dpwdz(el(k,3)) +           dvdp(3) *ph;
                    end
                    
                    
                    break; % end loop once we've found an intersection
                end
            end
        end
    end
    
    if ~opt.debugPlot,  figure; end
    trisurf(el,co(:,1),co(:,2),co(:,3),pw(:,1)); axis equal; shading interp;
    colormap('hot'); caxis([min(pw(:)) max(pw(:))]);
    %%
    if  isfield(opt, 'specular')
        hold on;
        for i = 1:size(co,1)
            trisurf(opt.usph_el, ...
                opt.usph_co(:,1)*opt.specularDrawScale+co(i,1), ...
                opt.usph_co(:,2)*opt.specularDrawScale+co(i,2), ...
                opt.usph_co(:,3)*opt.specularDrawScale+co(i,3), ...
                pw(i,1)+pw(i,2:end),'FaceAlpha',1); axis equal; shading interp;
            colormap('hot');
        end
        for k = 1:size(el,1)
            trisurf(opt.usph_el, ...
                opt.usph_co(:,1)*opt.specularDrawScale+(co(el(k,1),1)+co(el(k,2),1)+co(el(k,3),1))./3, ...
                opt.usph_co(:,2)*opt.specularDrawScale+(co(el(k,1),2)+co(el(k,2),2)+co(el(k,3),2))./3, ...
                opt.usph_co(:,3)*opt.specularDrawScale+(co(el(k,1),3)+co(el(k,2),3)+co(el(k,3),3))./3, ...
                (pw(el(k,1),1)+pw(el(k,2),1)+pw(el(k,3),1))./3+(pw(el(k,1),2:end)+pw(el(k,2),2:end)+pw(el(k,3),2:end))./3,...
                'FaceAlpha',1); axis equal; shading interp;
            colormap('hot');
        end
        caxis([0 max(max(pw(:,1)+pw(:,2:end)))]); hold off;
    end
    
    view(140,20); drawnow;
%     saveas(gcf,['_img/lightpos_' num2str(opt.lightDisplacement(1)) '.png']);
end


