%clear all; clc; %#ok

obj = read_wobj('lowresbend.obj');
co = obj.vertices;
el = obj.objects( strcmp({obj.objects(:).type}, 'f') ).data.vertices;


% figure; trisurf(el,co(:,1),co(:,2),co(:,3)); axis equal; hold all;

[n_c, n_e, ce, ar] = simpleVertexNormals(el,co);

% quiver3(co(:,1),co(:,2),co(:,3) , n_c(:,1),n_c(:,2),n_c(:,3) ,'r');
% quiver3(ce(:,1),ce(:,2),ce(:,3) , n_e(:,1),n_e(:,2),n_e(:,3) ,'b');

%%


%ToDo: find out if we want to
% (a) evaluate HSH coeffs in element local coords and interpolate coeffs
% (b) evaluate HSH coeffs in nodal local coords and interpolate evals
% (c) evaluate HSH coeffs in element local coords and interpolate evals
% (d) evaluate HSH coeffs in nodal local coords and interpolate coeffs

hsh_bands=8;
data = zeros( size(co,1) , hsh_bands.^2 );

for x=linspace( min(co(:,1))+1e-2, max(co(:,1))-1e-2,18) %#ok
for y=linspace( min(co(:,2))+1e-2, max(co(:,2))-1e-2, 8)
   
    r_o = [x;y;1]; r_d = [0;0;-1];
%     quiver3(r_o(1),r_o(2),r_o(3), r_d(1),r_d(2),r_d(3), 0);
    
    %[x,y]
    for k = 1:size(el,1)
        [isHit, u, v, d] = rayTriangleIntersection(r_o, r_d, co(el(k,1),:)', co(el(k,2),:)', co(el(k,3),:)');
        if isHit
            %[k,u,v]
            data = processRayHit(data, el,co,n_c,n_e,ar, k,u,v, r_d, hsh_bands);
            break;
        end
    end

end, end % for (x,y)

for l = 0:(hsh_bands-1)
    for m = -l:l
        idx = l*(l+1) + m +1;
        data(:,idx) = data(:,idx) ./ (1 + 1e-3 *((l * (l + 1)) * (l * (l + 1)))); 
    end
end
%%
figure;
h = trisurf(el,co(:,1),co(:,2),co(:,3), data(:,1)); axis equal; shading interp; hold all;

for i = 1:size(co,1)
    hsphm_plot(data(i,:), hsh_bands, 0.1, co(i,:)',48,48,n_c(i,:)', 0);
end

for k = 1:size(el,1)
    d = ( data(el(k,1),:) + data(el(k,2),:) + data(el(k,3),:) )/3;
    c = ( co(el(k,1),:) + co(el(k,2),:) + co(el(k,3),:))' /3;
    n = ( n_c(el(k,1),:) + n_c(el(k,2),:) + n_c(el(k,3),:))' /3;
%     n = n_e(k,:)';
%     hsphm_plot(d, hsh_bands, 0.1, c,48,48,n, 0);
    hsphm_plot_interp(data(el(k,1),:),data(el(k,2),:),data(el(k,3),:),[1,1,1]/3, hsh_bands, 0.1, c,48,48,n,n_c(el(k,1),:)',n_c(el(k,2),:)',n_c(el(k,3),:)', 0);
end


quiver3(co(:,1),co(:,2),co(:,3) , n_c(:,1),n_c(:,2),n_c(:,3) ,'r');
set(h, 'EdgeColor','k', 'EdgeAlpha', 0.2);
view(-10,40);
set(gcf,'Color','w');
set(gca,'FontSize',16);
%%
% ==================

function data = processRayHit(data, el,co,n_c,n_e,ar, k,u,v, r_d, hsh_bands)
    
    r_d = -r_d; % for testing, assume the material reflects in this strange way, simply reversing all rays
    
    n_ek = (n_c(el(k,1),:)*(1-u-v) + n_c(el(k,2),:)*u + n_c(el(k,3),:)*v)';
%     n_ek = n_e(k,:)';
    t_ek = cross( n_ek,[-n_ek(2); n_ek(3); n_ek(1)] ); t_ek = t_ek ./ norm(t_ek);
    b_ek = cross( n_ek, t_ek );
    
    theta_e = acos(dot(n_ek, r_d)); % theta is zenith angle from the normal
    phi_e = atan2( dot(b_ek, r_d), dot(t_ek, r_d) ); % atan2(y,x) .. y first!

    for ii=1:3
        i = el(k,ii);
        b = (1-u-v);
        if ii==2, b=u; elseif ii==3, b=v; end
        
        n_ck = n_c(i,:)';
        t_ck = cross( n_ck,[-n_ck(2); n_ck(3); n_ck(1)] ); t_ck = t_ck ./ norm(t_ck);
        b_ck = cross( n_ck, t_ck );

        theta_c = acos(dot(n_ck, r_d)); % theta is zenith angle from the normal
        phi_c = atan2( dot(b_ck, r_d), dot(t_ck, r_d) ); % atan2(y,x) .. y first!

        for l = 0:(hsh_bands-1)
            for m = -l:l
%                 val = hsphm_Y(l, m, theta_e, phi_e);
                val = hsphm_Y(l, m, theta_c, phi_c);

                idx = l*(l+1) + m +1;
                data(i, idx) = data(i, idx) + val * b / ar(i);
            end
        end
    end
end
