% area light incident ray derivatives test
clear variables; clc;

% light position, orientation, size
lp = [ 0;0;1]; % position
n0 = [ 0;0;1]; % reference normal (assume lamp is in x-y-plane)
t0 = [-1;0;0]; % reference tangent
lR = axang2rotm([0 1 0 , 1.2*pi/2]);
ls = [0.5 4]; % extent of rectangular shape (lp is centre)
% query (hit) point
hx = [1;1;0];
hn = [0;0;1];

ln = lR*n0; lt = lR*t0; lb = cross(ln,lt); lb = lb./norm(lb);

% draw the lamp
%cc = lp+lR*[ -ls(1) -ls(2) 0; -ls(1) ls(2) 0; ls(1) ls(2) 0; ls(1) -ls(2) 0; -ls(1) -ls(2) 0]'/2;
cc = [
    lp + ls(1)/2*lt + ls(2)/2*lb ...
    lp + ls(1)/2*lt - ls(2)/2*lb ...
    lp - ls(1)/2*lt - ls(2)/2*lb ...
    lp - ls(1)/2*lt + ls(2)/2*lb ...
    lp + ls(1)/2*lt + ls(2)/2*lb ];
hold off; plot3(cc(1,:), cc(2,:), cc(3,:),'k-', lp(1), lp(2), lp(3), 'ko'); axis equal;
hold on;
quiver3(lp(1), lp(2), lp(3),  ln(1), ln(2), ln(3), 0,'g');
quiver3(lp(1), lp(2), lp(3),  lt(1), lt(2), lt(3), 0,'r');
quiver3(lp(1), lp(2), lp(3),  lb(1), lb(2), lb(3), 0,'b');

% draw the query point
quiver3(hx(1), hx(2), hx(3),  hn(1), hn(2), hn(3), 0,'kx');

for ii = 1%:size(cc,2)-1 % test each corner of the lamp
    ro = cc(:,ii);
    dx = dot( ro - lp , lt );
    dy = dot( ro - lp , lb );
    
    [cos_out, cos_in_over_r2, ro_] = rayEval(lp, ln, lt, dx,dy, hx,hn);
    assert( norm(ro-ro_)<1e-12 );
    
    % compute and test these derivatives:
    % d(cos_out)/., d(cos_in_over_r2)/d., ./d(lp), ./d(ln), ./d(lt), ./d(lR)?
    [dcodp, dcodn, dcodt, dcir2dp, dcir2dn, dcir2dt] = symDerivs(lp, ln, lt, dx,dy, hx,hn);
    
    fd_h = 1e-7;
    % FD wrt. lp
    fdcodp = 0*dcodp;
    fdcir2dp = 0*dcir2dp;
    lp_  = lp + [fd_h;0;0];
    [fd_cos_out, fd_cos_in_over_r2] = rayEval(lp_, ln, lt, dx,dy, hx,hn);
    fdcodp(1) = (fd_cos_out - cos_out) / fd_h;
    fdcir2dp(1) = (fd_cos_in_over_r2 - cos_in_over_r2) / fd_h;
    lp_  = lp + [0;fd_h;0];
    [fd_cos_out, fd_cos_in_over_r2] = rayEval(lp_, ln, lt, dx,dy, hx,hn);
    fdcodp(2) = (fd_cos_out - cos_out) / fd_h;
    fdcir2dp(2) = (fd_cos_in_over_r2 - cos_in_over_r2) / fd_h;
    lp_  = lp + [0;0;fd_h];
    [fd_cos_out, fd_cos_in_over_r2] = rayEval(lp_, ln, lt, dx,dy, hx,hn);
    fdcodp(3) = (fd_cos_out - cos_out) / fd_h;
    fdcir2dp(3) = (fd_cos_in_over_r2 - cos_in_over_r2) / fd_h;
    disp('FD err. lp');
    disp( norm( fdcodp - dcodp ));
    disp( norm( fdcir2dp - dcir2dp ));
    clear lp_;

    % FD wrt. ln
    fdcodn = 0*dcodn;
    fdcir2dn = 0*dcir2dn;
    ln_  = ln + [fd_h;0;0]; ln_ = ln_ ./norm(ln_);
    [fd_cos_out, fd_cos_in_over_r2] = rayEval(lp, ln_, lt, dx,dy, hx,hn);
    fdcodn(1) = (fd_cos_out - cos_out) / fd_h;
    fdcir2dn(1) = (fd_cos_in_over_r2 - cos_in_over_r2) / fd_h;
    ln_  = ln + [0;fd_h;0]; ln_ = ln_ ./norm(ln_);
    [fd_cos_out, fd_cos_in_over_r2] = rayEval(lp, ln_, lt, dx,dy, hx,hn);
    fdcodn(2) = (fd_cos_out - cos_out) / fd_h;
    fdcir2dn(2) = (fd_cos_in_over_r2 - cos_in_over_r2) / fd_h;
    ln_  = ln + [0;0;fd_h]; ln_ = ln_ ./norm(ln_);
    [fd_cos_out, fd_cos_in_over_r2] = rayEval(lp, ln_, lt, dx,dy, hx,hn);
    fdcodn(3) = (fd_cos_out - cos_out) / fd_h;
    fdcir2dn(3) = (fd_cos_in_over_r2 - cos_in_over_r2) / fd_h;
    disp('FD err. ln');
    disp( norm( fdcodn - dcodn ));
    disp( norm( fdcir2dn - dcir2dn ));
    clear ln_;

    % FD wrt. lt
    fdcodt = 0*dcodt;
    fdcir2dt = 0*dcir2dt;
    lt_  = lt + [fd_h;0;0]; lt_ = lt_ ./norm(lt_);
    [fd_cos_out, fd_cos_in_over_r2] = rayEval(lp, ln, lt_, dx,dy, hx,hn);
    fdcodt(1) = (fd_cos_out - cos_out) / fd_h;
    fdcir2dt(1) = (fd_cos_in_over_r2 - cos_in_over_r2) / fd_h;
    lt_  = lt + [0;fd_h;0]; lt_ = lt_ ./norm(lt_);
    [fd_cos_out, fd_cos_in_over_r2] = rayEval(lp, ln, lt_, dx,dy, hx,hn);
    fdcodt(2) = (fd_cos_out - cos_out) / fd_h;
    fdcir2dt(2) = (fd_cos_in_over_r2 - cos_in_over_r2) / fd_h;
    lt_  = lt + [0;0;fd_h]; lt_ = lt_ ./norm(lt_);
    [fd_cos_out, fd_cos_in_over_r2] = rayEval(lp, ln, lt_, dx,dy, hx,hn);
    fdcodt(3) = (fd_cos_out - cos_out) / fd_h;
    fdcir2dt(3) = (fd_cos_in_over_r2 - cos_in_over_r2) / fd_h;
    disp('FD err. lt');
    disp( norm( fdcodt - dcodt ));
    disp( norm( fdcir2dt - dcir2dt ));
    clear lt_;
end

function [cos_out, cos_in_over_r2, ro] = rayEval(lp, ln, lt, dx,dy, hx,hn)
    lb = cross(ln,lt); lb = lb./norm(lb);
    ro = lp + dx*lt + dy*lb; % ray origin
    rd = (hx - ro) ./ norm(hx - ro); % ray direction

    cos_out = dot( rd, ln); % cos of angle leaving light source
    cos_in  = dot(-rd, hn); % cos of angle arriving at query point
    r2inv   = 1/dot(hx - ro, hx - ro); % inverse squared distance

    cos_in_over_r2 = cos_in * r2inv;
end


function [dcodp, dcodn, dcodt, dcir2dp, dcir2dn, dcir2dt] = symDerivs(lp, ln, lt, dx,dy, hx,hn)

    out = codegen_rectLightDerivs(dx,dy,hn(1),hn(2),hn(3),hx(1),hx(2),hx(3),ln(1),ln(2),ln(3),lp(1),lp(2),lp(3),lt(1),lt(2),lt(3) ,0.0);
                                  %(dx,dy,hn1,hn2,hn3,      hx1,hx2,hx3,      ln1,ln2,ln3,      lp1,lp2,lp3,    lt1,lt2,lt3,     tinyEps)
    dcodp = out(1,:)';
    dcodn = out(2,:)';
    dcodt = out(3,:)';
    dcir2dp = out(4,:)';
    dcir2dn = out(5,:)';
    dcir2dt = out(6,:)';
    
end