clc; clear variables;
obj = read_wobj('tilted_plane.obj');
co = obj.vertices;
el = obj.objects( strcmp({obj.objects(:).type}, 'f') ).data.vertices;

% co = [ 0 0 0.2
%        1 0 0.1
%        0 1 0
%        1 1 0.3 ];
% el = [ 1 2 3
%        2 3 4 ];
% % [co,el] = refineRGB(co,el,findBoundary(el),1:size(el,1));
% % % [co,el] = refineRGB(co,el,findBoundary(el),1:size(el,1));

n_nodes = size(co,1);
n_elems = size(el,1);

% enumerate edges for DOF mapping
[ed, edg_idx] = edgeMap(el);

edg_ctr = 0.5 * (co(edg_idx(:,1),:) + co(edg_idx(:,2),:));

% % this shows roughly where the DOFs are - but won't interpolate according to the basis functions obviously
% % trisurf(el,co(:,1),co(:,2),co(:,3),0*co(:,1),'FaceAlpha',0.2); axis equal; hold on;
% % trisurf(ed, edg_ctr(:,1), edg_ctr(:,2), edg_ctr(:,3), 0*edg_ctr(:,3),'FaceAlpha',0.2);
% h = trisurf([el; n_nodes+ed], [co(:,1) ; edg_ctr(:,1)], [co(:,2) ; edg_ctr(:,2)], [co(:,3) ; edg_ctr(:,3)], 0.1*[co(:,1) ; edg_ctr(:,1)].^2); axis equal; shading interp;
% set(h, 'EdgeAlpha',0.1,'EdgeColor','k');

%%
n_dofs  = n_nodes + size(edg_idx,1);

% now el is a (n x 3) array listing node indices for each element
% and ed is a (n x 3) array listing edge indices for each element
% while edg_idx is a (n x 2) array listing node indices for each edge

% for a standard quadratic triangle we'll have one DOF on each node
% and another DOF on each edge (6 DOFs per element, shared on nodes or edges)

[qp,qw] = gaussQuadratureTri();

M = zeros(n_dofs); Mn = M;
f = zeros(n_dofs,1);
fs = zeros(n_dofs,1);
for k = 1:n_elems
    ar = 0.5*( norm(cross( co(el(k,2),:)-co(el(k,1),:) , co(el(k,3),:)-co(el(k,1),:) )));
    gdofs = [el(k,:) , n_nodes + ed(k,:)]; % first node-DOFs then edge-DOFs
    M_e = zeros(6,6);
    for i = 1:size(qp,1)
        w = shapeFcnP2tri(co( el(k,:), :), qp(i,:)' );
        qpi = qp(i,1)*co(el(k,1),:) + qp(i,2)*co(el(k,2),:) + qp(i,3)*co(el(k,3),:); % location of quadrature point
        M_e = M_e + qw(i)*(w*w');
        f(gdofs) = f(gdofs) + ar*qw(i)*w*(1); % integrate const. 1 times shape fcn over elem.
        fs(gdofs)= fs(gdofs)+ ar*qw(i)*w*(sin(2*pi*qpi(1))*cos(pi*qpi(2)));%(qpi(1));%
    end
    Mn(gdofs,gdofs) = Mn(gdofs,gdofs) + ar*M_e; % quadrature gives same result as MuPad in consistentMassP2tri
end
M = consistentMassP2tri(el,ed,co);

allones = M\f; % should be all 1
disp('ones test, abs err:'); disp(max(abs(allones-1)));

linrampx = 0.3 + [co(:,1); edg_ctr(:,1)]*0.2;
quadfcny = 0.1 + ([co(:,2); edg_ctr(:,2)]-0.5).^2*0.05;
fcnL2 = M\fs;
dco = [ co ; edg_ctr ];
fcnInterp = sin(2*pi*dco(:,1)).*cos(pi*dco(:,2));

if  0
%%
    % draw some shape function ...
    [s,t] = meshgrid(0:0.02:1);
    t( (s+t)>1 ) = 1-s( (s+t)>1 );
    for k = 1:n_elems
        gdofs = [el(k,:) , n_nodes + ed(k,:)]; % first node-DOFs then edge-DOFs
        wid = find(gdofs == 7);
        x = co(el(k,1),1)*(1-s-t) + co(el(k,2),1)*s + co(el(k,3),1)*t;
        y = co(el(k,1),2)*(1-s-t) + co(el(k,2),2)*s + co(el(k,3),2)*t;
        z = co(el(k,1),3)*(1-s-t) + co(el(k,2),3)*s + co(el(k,3),3)*t;
        c = 0*s;
        dwx=c; dwy=c; dwz=c;
        for i=1:size(s,1)
            for j=1:size(s,2)
                [w,dw] = shapeFcnP2tri(co( el(k,:), :), [1-s(i,j)-t(i,j) ; s(i,j) ; t(i,j)] );
                if ~isempty(wid)
                    c(i,j)=w(wid);
                    dwx(i,j)=dw(1,wid); dwy(i,j)=dw(2,wid); dwz(i,j)=dw(3,wid);
                end
            end
        end
        surf(x,y,z,c); shading interp; hold on; axis equal;
        quiver3(x,y,z, dwx,dwy,dwz);
    end
%     trimesh(el,co(:,1),co(:,2),co(:,3),'EdgeColor','k','EdgeAlpha',0.2,'FaceAlpha',0);
end


if  1 % plot interpolated result
    %%
    u = fcnL2; %fcnInterp; %linrampx; %allones; % field to draw
    [s,t] = meshgrid(0:0.02:1);
    t( (s+t)>1 ) = 1-s( (s+t)>1 );
    figure;
    for k = 1:size(el,1)
        gdofs = [el(k,:) , size(co,1) + ed(k,:)]; % first node-DOFs then edge-DOFs
        x = co(el(k,1),1)*(1-s-t) + co(el(k,2),1)*s + co(el(k,3),1)*t;
        y = co(el(k,1),2)*(1-s-t) + co(el(k,2),2)*s + co(el(k,3),2)*t;
        z = co(el(k,1),3)*(1-s-t) + co(el(k,2),3)*s + co(el(k,3),3)*t;
        c = 0*s;
        for i=1:size(s,1)
            for j=1:size(s,2)
                w = shapeFcnP2tri(co( el(k,:), :), [1-s(i,j)-t(i,j) ; s(i,j) ; t(i,j)] );
                c(i,j) = w'*u(gdofs);
            end
        end
        surf(x,y,z,c); shading interp; hold on;
    end
    axis equal; caxis([min(u(:)) max(u(:))]);
%     trimesh(el,co(:,1),co(:,2),co(:,3),'EdgeColor','k','EdgeAlpha',0.2,'FaceAlpha',0);
    view(150,50);
    title('L2P2');
end



%% compare to linear elements
co_ori = co; el_ori = el;
[co,el] = refineRGB(co,el,findBoundary(el),1:size(el,1)); % refine once to have same number of DOFs as P2 mesh
M1 = consistentMass(el,co);
f1 = zeros(size(co,1),1);
for k = 1:size(el,1)
    ar = 0.5*( norm(cross( co(el(k,2),:)-co(el(k,1),:) , co(el(k,3),:)-co(el(k,1),:) )));
    gdofs = el(k,:);
    for i = 1:size(qp,1)
        w = shapeFcnP1tri(co( el(k,:), :), qp(i,:)' );
        qpi = qp(i,1)*co(el(k,1),:) + qp(i,2)*co(el(k,2),:) + qp(i,3)*co(el(k,3),:); % location of quadrature point
        f1(gdofs)= f1(gdofs)+ ar*qw(i)*w*(sin(2*pi*qpi(1))*cos(pi*qpi(2)));
    end
end
fcnL2P1 = M1\f1;
figure; h = trisurf(el,co(:,1),co(:,2),co(:,3),fcnL2P1); shading interp; axis equal;
view(150,50); % set(h,'EdgeAlpha',0.1,'EdgeColor','k');
title('L2P1');
% 
% figure; h = trisurf(el,co(:,1),co(:,2),co(:,3),sin(2*pi*co(:,1)).*cos(pi*co(:,2))); shading interp; axis equal;
% view(150,50); % set(h,'EdgeAlpha',0.1,'EdgeColor','k');
% title('interp. P1');

%%
co = co_ori; el = el_ori;