clc; clear variables;
obj = read_wobj('tilted_plane.obj');
co = obj.vertices;
el = obj.objects( [obj.objects(:).type]=='f' ).data.vertices;

opt.specular=0.7; % ratio of specular reflection (diffuse will be 1-s)
opt.specularDrawScale=0.07; % size of specular "balls" in plots
[opt.usph_el, opt.usph_co] = readIcoSphereFromMesh();

opt.debugPlot = 0;
%%
for l=-0.2:0.1:0.4
    opt.lightDisplacement = [l 0 0];
    %%
    pw = mytest(el,co, opt);
%     sum(sum(pw))
    % integrate pw over mesh == should equal 1
    int_pw = 0;
    for k=1:size(el,1)
        % linear fcn within el --> avg. of corners * area
        avg = ( pw(el(k,1),:) + pw(el(k,2),:) +pw(el(k,3),:) ) / 3;
        ar = 0.5*( norm(cross( co(el(k,2),:)-co(el(k,1),:) , co(el(k,3),:)-co(el(k,1),:) )));
        int_pw = int_pw + avg*ar;
    end
    sum(int_pw) % ToDo: also use L2-projection (or spherical harmonic projection) in specular case - and compare by integrating specular power over unit sphere
    
end

% %%
% for vw = 40:10:200
%     view(vw,20); drawnow;
%     saveas(gcf,['_img/viewang_' num2str(vw) '.png']);
% end
%%
    
function pw = mytest(el,co, opt)
    dataPerNode = 1;
    if  isfield(opt, 'specular')
        tmp = projectSpecularReflection([],[],-1,[],[],[],[],opt);
        dataPerNode = length(tmp);
    end
    pw = zeros(size(co,1),dataPerNode);

    if  opt.debugPlot
        figure; trimesh(el,co(:,1),co(:,2),co(:,3),'FaceAlpha',0,'EdgeAlpha',0.2,'EdgeColor','k'); axis equal; hold on;
    end

    lp = [0.1,3,-0.2];
    if  isfield(opt,'lightDisplacement')
        lp = lp + opt.lightDisplacement;
    end
    [ldx,ldy,ldz] = sph2cart(-pi/2,0,1); ld = [ldx,ldy,ldz]; clear ldx ldy ldz;
    lth= 15; % deg

    if  opt.debugPlot
        quiver3(lp(:,1),lp(:,2),lp(:,3), ld(:,1),ld(:,2),ld(:,3));
    end

    h1=simplePerpendicularVector(ld);
    h1=h1./norm(h1);

    n_th = 6;
    th_vals = linspace(0,lth,n_th);
    rh_vals = 12:12:360;
    n_rh = numel(rh_vals);

    for th = th_vals
        for rh = rh_vals
            R1 = axang2rotm([h1 th/180*pi]);
            R2 = axang2rotm([ld rh/180*pi]);
            rd = (R2*R1*ld')'; % ray direction
            
            if  opt.debugPlot
                quiver3(lp(:,1),lp(:,2),lp(:,3), rd(:,1),rd(:,2),rd(:,3), 'g');
            end

            for k = 1:size(el,1)
                [isHit, u, v, d] = rayTriangleIntersection (lp, rd, co(el(k,1),:), co(el(k,2),:), co(el(k,3),:));
                if  isHit && d>0
                    if  opt.debugPlot
                        hx = co(el(k,1),:) + u*(co(el(k,2),:)-co(el(k,1),:)) + v*(co(el(k,3),:)-co(el(k,1),:));
                        plot3(hx(1),hx(2),hx(3),'bo');
                    end

                    % distribute 1/(n_th*n_rh) of the total radiative power to the three nodes
                    ph = 1/(n_th*n_rh);
                    if  isfield(opt, 'specular')
                        ps = projectSpecularReflection(el,co, k,u,v,rd,ph, opt);
                        pw(el(k,1),:) = pw(el(k,1),:) + (1-u-v)*ps;
                        pw(el(k,2),:) = pw(el(k,2),:) +    u   *ps;
                        pw(el(k,3),:) = pw(el(k,3),:) +      v *ps;
                    else
                        pw(el(k,1)) = pw(el(k,1)) + (1-u-v)*ph;
                        pw(el(k,2)) = pw(el(k,2)) +    u   *ph;
                        pw(el(k,3)) = pw(el(k,3)) +      v *ph;
                    end
                    
                    %ToDo: try gradient evaluation and optimisation of light source
                    break; % end loop once we've found an intersection
                end
            end
        end
    end
    
    M=consistentMass(el,co);
    pw=M\pw; % L2-projection
    
    if ~opt.debugPlot,  figure; end
    trisurf(el,co(:,1),co(:,2),co(:,3),pw(:,1)); axis equal; shading interp;
    colormap('hot'); caxis([min(pw(:)) max(pw(:))]);
    %%
    if  isfield(opt, 'specular')
        hold on;
        for i = 1:size(co,1)
            trisurf(opt.usph_el, ...
                opt.usph_co(:,1)*opt.specularDrawScale+co(i,1), ...
                opt.usph_co(:,2)*opt.specularDrawScale+co(i,2), ...
                opt.usph_co(:,3)*opt.specularDrawScale+co(i,3), ...
                pw(i,1)+pw(i,2:end),'FaceAlpha',1); axis equal; shading interp;
            colormap('hot');
        end
        for k = 1:size(el,1)
            trisurf(opt.usph_el, ...
                opt.usph_co(:,1)*opt.specularDrawScale+(co(el(k,1),1)+co(el(k,2),1)+co(el(k,3),1))./3, ...
                opt.usph_co(:,2)*opt.specularDrawScale+(co(el(k,1),2)+co(el(k,2),2)+co(el(k,3),2))./3, ...
                opt.usph_co(:,3)*opt.specularDrawScale+(co(el(k,1),3)+co(el(k,2),3)+co(el(k,3),3))./3, ...
                (pw(el(k,1),1)+pw(el(k,2),1)+pw(el(k,3),1))./3+(pw(el(k,1),2:end)+pw(el(k,2),2:end)+pw(el(k,3),2:end))./3,...
                'FaceAlpha',1); axis equal; shading interp;
            colormap('hot');
        end
        caxis([0 max(max(pw(:,1)+pw(:,2:end)))]); hold off;
    end
    
    view(140,20); drawnow;
%     saveas(gcf,['_img/lightpos_' num2str(opt.lightDisplacement(1)) '.png']);
end


