function [h,v,theta,phi]=sphm_plot(f, sphm_bands,r,c,n_theta,n_phi, lobe)
    theta = linspace(0, pi, n_theta); % theta is out of xy plane
    phi = linspace(0, 2*pi, n_phi);
    [theta, phi] = meshgrid(theta, phi);

    v = zeros(size(theta));
    for i=1:size(v,1)
        for j=1:size(v,2)
            for l = 0:(sphm_bands-1)
                for m = -l:l
                    v(i,j) = v(i,j) + f(l*(l+1) + m +1) * sphm_Y(l, m, theta(i,j), phi(i,j));
                end
            end
        end
    end

    if  lobe
        [x,y,z] = sph2cart(phi,pi/2-theta, r*abs(v)./max(abs(v(:))) );
    else
        [x,y,z] = sph2cart(phi,pi/2-theta, r*ones(size(theta)));
    end
    x=x+c(1); y=y+c(2); z=z+c(3);
    h=surf(x,y,z,v); shading interp;
end
