function [result] = sphm_Y(l, m, theta, phi)

    % return a point sample of a Spherical Harmonic basis function
    % l is the band, range [0..N]
    % m in the range [-l..l]
    % theta in the range [0..Pi]
    % phi in the range [0..2*Pi]

    if( m == 0)
        result = sphm_K(l, 0) * sphm_P(l, 0, cos(theta));
    elseif(m > 0)
        result = sphm_K(l, m) * sphm_P(l, m, cos(theta)) * cos(m * phi) * sqrt(2.0);
    else % m < 0
        result = sphm_K(l, -m) * sphm_P(l, -m, cos(theta)) * sin(-m * phi) * sqrt(2.0);
    end

end

