function [result] = sphm_P(l, m, x)
% This function evaluates an associated Legendre Polynomial
% 
%     P = legendre(l,x); % x==cos(theta)
%     result = P(m+1);
%     return;
   
    pmm = 1.0;
    if(m > 0)
        somx2 = sqrt((1.0-x)*(1.0+x));
        fact = 1.0;
        for i=1:m
            pmm = pmm * (-fact) * somx2;
            fact = fact + 2.0;
        end
    end

    if l == m
        result = pmm;
        return;
    end

    pmmp1 = x * (2.0*m+1.0) * pmm;
    if l==(m+1) 
        result = pmmp1;
        return; 
    end

    result = 0;
    for ll=m+2:l
        result = ( (2.0*ll-1.0)*x*pmmp1-(ll+m-1.0)*pmm ) / (ll-m);
        pmm = pmmp1;
        pmmp1 = result;
    end

end

