%% run some tests for specular projection ...

clc; clear variables; close all;
obj = read_wobj('tilted_plane.obj');
co = obj.vertices;
el = obj.objects( strcmp({obj.objects(:).type}, 'f') ).data.vertices;

k=1;
u=0.3; v=0.3;
rd=[0 -1 0];
rd2=[0 -0.5 0.5]; rd2=rd2./norm(rd2);
opt.specular=0.7;

%%

[opt.usph_el, opt.usph_co] = readIcoSphereFromMesh();

[opt.usph_co, opt.usph_el] = refineRGB(opt.usph_co,opt.usph_el,findBoundary(opt.usph_el),1:size(opt.usph_el,1)); % refine once
[opt.usph_co, opt.usph_el] = refineRGB(opt.usph_co,opt.usph_el,findBoundary(opt.usph_el),1:size(opt.usph_el,1)); % refine once
for i=1:size(opt.usph_co,1)
    opt.usph_co(i,:) = opt.usph_co(i,:) ./ norm( opt.usph_co(i,:) );  % reproject to unit sphere after refinement
end

psf = projectSpecularReflection(el,co, k,u,v,rd,1, opt)';
psf = psf + projectSpecularReflection(el,co, k,u,v,rd2,0.8, opt)';

M = consistentMass(opt.usph_el, opt.usph_co);
M = [ sum(sum(M)) zeros(1,size(M,2)) ; zeros(size(M,1),1) M];
sum(M*psf)

int_psf = 0; int_ar = 0;
for k=1:size(opt.usph_el,1)
    % linear fcn within el --> avg. of corners * area
    avg = ( psf(opt.usph_el(k,1)+1,:) + psf(opt.usph_el(k,2)+1,:) + psf(opt.usph_el(k,3)+1,:) ) / 3;
    ar = 0.5*( norm(cross( opt.usph_co(opt.usph_el(k,2),:)-opt.usph_co(opt.usph_el(k,1),:) , opt.usph_co(opt.usph_el(k,3),:)-opt.usph_co(opt.usph_el(k,1),:) )));
    int_psf = int_psf + avg*ar;
    int_ar = int_ar + ar;
end
int_psf = int_psf + int_ar*psf(1); % diffuse component
assert( abs( sum(sum(M))-2*int_ar )<1e-12); % "extended" M has full area once for diffuse, and once distributed for specular weighting
sum(int_psf)

figure; h=trisurf(opt.usph_el, opt.usph_co(:,1), opt.usph_co(:,2), opt.usph_co(:,3), psf(1)+psf(2:end)); shading interp; axis equal;
% set(h,'EdgeAlpha',0.2,'EdgeColor','k');
xlabel('x'); ylabel('y'); zlabel('z'); view(0,70);
title(['n = ' num2str(length(psf))]);

%% let's try P2 triangles ...
[opt.usph_el, opt.usph_co] = readIcoSphereFromMesh();
[opt.usph_co, opt.usph_el] = refineRGB(opt.usph_co,opt.usph_el,findBoundary(opt.usph_el),1:size(opt.usph_el,1)); % refine once
for i=1:size(opt.usph_co,1)
    opt.usph_co(i,:) = opt.usph_co(i,:) ./ norm( opt.usph_co(i,:) );  % reproject to unit sphere after refinement
end
[opt.usph_ed, edg_idx] = edgeMap(opt.usph_el);


k=1;
psf = projectSpecularReflectionP2(el,co, k,u,v,rd,1, opt)';
psf = psf + projectSpecularReflectionP2(el,co, k,u,v,rd2,0.8, opt)';

M = consistentMassP2tri(opt.usph_el, opt.usph_ed, opt.usph_co);
M = [ sum(sum(M)) zeros(1,size(M,2)) ; zeros(size(M,1),1) M]; % first entry: 1 or sum(sum(M))==area~~4*pi ???
sum(M*psf)

% the annoying part - nicely drawing P2 triangles ....
[s,t] = meshgrid(0:0.02:1);
t( (s+t)>1 ) = 1-s( (s+t)>1 );
figure; maxC=0;
for k = 1:size(opt.usph_el,1)
    gdofs = 1+[opt.usph_el(k,:) , size(opt.usph_co,1) + opt.usph_ed(k,:)]; % first node-DOFs then edge-DOFs
    x = opt.usph_co(opt.usph_el(k,1),1)*(1-s-t) + opt.usph_co(opt.usph_el(k,2),1)*s + opt.usph_co(opt.usph_el(k,3),1)*t;
    y = opt.usph_co(opt.usph_el(k,1),2)*(1-s-t) + opt.usph_co(opt.usph_el(k,2),2)*s + opt.usph_co(opt.usph_el(k,3),2)*t;
    z = opt.usph_co(opt.usph_el(k,1),3)*(1-s-t) + opt.usph_co(opt.usph_el(k,2),3)*s + opt.usph_co(opt.usph_el(k,3),3)*t;
    c = 0*s;
    for i=1:size(s,1)
        for j=1:size(s,2)
            w = shapeFcnP2tri(opt.usph_co( opt.usph_el(k,:), :), [1-s(i,j)-t(i,j) ; s(i,j) ; t(i,j)] );
            c(i,j) = w'*psf(gdofs)+psf(1);
        end
    end
    surf(x,y,z,c); shading interp; hold on;
end
trimesh(opt.usph_el,opt.usph_co(:,1),opt.usph_co(:,2),opt.usph_co(:,3),'EdgeColor','k','EdgeAlpha',0.2,'FaceAlpha',0);
axis equal; xlabel('x'); ylabel('y'); zlabel('z'); view(0,70);
title(['n = ' num2str(length(psf))]);

%% and now spherical harmonics

opt.sphm_bands=6;
k=1;
psf = projectSpecularReflection_SPHM(el,co, k,u,v,rd,1, opt)';
psf = psf + projectSpecularReflection_SPHM(el,co, k,u,v,rd2,0.8, opt)';
psf = psf + projectSpecularReflection_SPHM(el,co, k,u,v,[1;0;0],0.5, opt)';
% note psf will have a separate entry for the diffuse component too

% try smoothing in SPHM land ... following Appx.7 in https://www.ppsloan.org/publications/StupidSH36.pdf
for l=(1:opt.sphm_bands)-1
    for m=-l:l
        h = (l*(l+1)).^2; % see also page 19 in StupidSH36.pdf
        psf(l*(l+1) + m +2) = psf(l*(l+1) + m +2) / (1 + 5e-4*h);
    end
end

% psf = psf * 0.5;

figure; [~,v]=sphm_plot(psf(2:end),opt.sphm_bands, 1,[0;0;0],3*18,3*36,0); axis equal;
int_v = psf(1)*(4*pi)+psf(2)*sqrt(4*pi) % integrals of all sphm_Y over the entire sphere are 0 except Y_0 (the constant part) - orthogonality! - the integral of Y_0 is sqrt(4*pi)
% here integral( f ) over the sphere S^2 = integral( sum_i( psf_i*Y_i ) = sum_i( psf_i * integral(Y_i) ) with integral(Y_i)==0 except integral(Y_0)=sqrt(4*pi) so we have integral( f ) = psf_0 * sqrt(4*pi) (MatLab has psf_0 as psf(1) of course)
xlabel('x'); ylabel('y'); zlabel('z'); view(0,70);
title(['n = ' num2str(length(psf))]);



%% test rotations in spherical harmonic representation
% clc;
% opt.sphm_bands=10;
% psf = projectSpecularReflection_SPHM(el,co, 1,0,0,rd,1, opt)';
% psf = psf + projectSpecularReflection_SPHM(el,co, 1,0,0,rd2,0.8, opt)';
% % note psf will have a separate entry for the diffuse component too
% psf = psf(2:end); % skip diffuse part

opt.sphm_bands=4;
psf = [0 1 0 0 0 0 0 0 1 0 0 0.5 0 0.5 0 0.5]';

ax = [-0.5;0;1]; ax = ax./norm(ax);
ang = 30 /180*pi;
R = axang2rotm([ax' ang]);

z = [0;0.3;1]; Rz = R*z;
figure;
quiver3(0,0,0, z(1),z(2),z(3), 'k','LineWidth',2); hold on;
sphm_plot(psf,opt.sphm_bands, 0.8,[0;0;0],3*18,3*36, 1); axis equal;
view(35,70);

sphm_R = sphm_getSHrotMtx(R,opt.sphm_bands-1); % WHY switch Rxyz(3,2) <-> Rxyz(2,3) and Rxyz(3,1) <-> Rxyz(1,3) needed to make this work???
psf = sphm_R*psf;

figure;
quiver3(0,0,0, Rz(1),Rz(2),Rz(3), 'k','LineWidth',2); hold on;
sphm_plot(psf,opt.sphm_bands, 0.8,[0;0;0],3*18,3*36, 1); axis equal;
view(35,70);

%% draw individual spherical harmonic functions ...
% clc;
l = 7; % >= 0
m = 3;% in [ -l l ] (lower-case-L not 1)
theta = linspace(0, pi, 20*18); % theta is out of xy plane
phi = linspace(0, 2*pi, 20*36);
[theta, phi] = meshgrid(theta, phi);

v = zeros(size(theta));
for i=1:size(v,1)
    for j=1:size(v,2)
        v(i,j) = sphm_Y(l, m, theta(i,j), phi(i,j));
    end
end
figure;
disp( sum(sum(v.*v.*sin(theta)))*(theta(2,2)-theta(1,1))*(phi(2,2)-phi(1,1)) ); % Integrate square over (discretized) unit sphere ~> should be close to 1
% [x,y,z] = sph2cart(phi,pi/2-theta, ones(size(theta)));
% surf(x,y,z,v); axis equal; shading interp;
[x,y,z] = sph2cart(phi,pi/2-theta,abs(v)+0.01);
surf(x,y,z,v); axis equal; shading interp;

%% basic SH evaluation test (for comparisons with C++/GLSL code)
bands = 7;
coeff = zeros(bands*bands,1);
coeff(1) = 0.2; coeff(2) = 0.8; coeff(9)=0.4; coeff(47)=0.3;
dir = [0.6; 1; 0.2]; dir = dir./norm(dir);
theta = acos(dir(3));
phi = atan2(dir(2), dir(1));
% [ph,th] = cart2sph(dir(1),dir(2),dir(3)); th = pi/2-th;
v = 0;
for l = 0:(bands-1)
    for m = -l:l
        v = v + coeff(l*(l+1) + m +1) * sphm_Y(l, m, theta, phi);
    end
end
fprintf('v = %8g\n',v);
figure; sphm_plot(coeff,bands,1,[0;0;0],3*36,3*18,0); axis equal;
xlabel('x'); ylabel('y'); zlabel('z');

%% try hemispherical harmonics

l = 2; % >= 0
m = -1;% in [ -l l ] (lower-case-L not 1)
theta = linspace(0, pi, 20*18); % theta is out of xy plane
phi = linspace(0, 2*pi, 20*36);
[theta, phi] = meshgrid(theta, phi);

v = zeros(size(theta));
for i=1:size(v,1)
    for j=1:size(v,2)
        v(i,j) = hsphm_Y(l, m, theta(i,j), phi(i,j));
    end
end
figure;
% [x,y,z] = sph2cart(phi,pi/2-theta, ones(size(theta)));
% surf(x,y,z,v); axis equal; shading interp;
[x,y,z] = sph2cart(phi,pi/2-theta,abs(v));
h=surf(x,y,z,v); axis equal; shading interp;
%set(h,'EdgeAlpha',0.2,'EdgeColor','k');

%% HSH eval
opt.sphm_bands=5; clc;

n = cross( (co(el(k,2),:)-co(el(k,1),:)) , (co(el(k,3),:)-co(el(k,1),:)) );
n = n./norm(n);
rd= -n+[0 0 0.5]; rd=rd./norm(rd);

psf = projectSpecularReflection_SPHM(el,co, k,u,v,rd,1, opt)';
% psf = psf + projectSpecularReflection_SPHM(el,co, k,u,v,rd2,0.8, opt)';
sphm_plot(psf(2:end),opt.sphm_bands,1,[0;0;0],3*36,3*18,0); axis equal;

hpsf = projectSpecularReflection_HSPHM(el,co, k,u,v,rd,1, opt)';


figure;
hsphm_plot(hpsf(2:end),opt.sphm_bands,1,[0;0;0],3*36,3*18,n',0); axis equal;
% hold on; plot3([0 rd(1)],[0 rd(2)],[0 rd(3)]);
xlabel('x'); ylabel('y'); zlabel('z');

