%% HSH eval
clear variables; clc;

obj = read_wobj('tilted_plane.obj');
co = obj.vertices;
el = obj.objects( strcmp({obj.objects(:).type}, 'f') ).data.vertices;

opt.sphm_bands=8;
opt.specular=1;

k = 1; u = 0; v = 0;
n = cross( (co(el(k,2),:)-co(el(k,1),:)) , (co(el(k,3),:)-co(el(k,1),:)) );
n = n./norm(n);
rd= -n+[0.1 0.2 -0.3]; rd=rd./norm(rd);

hpsf = projectSpecularReflection_HSPHM(el,co, k,u,v,rd,0.1, opt)';

figure; hsphm_plot(hpsf(2:end),opt.sphm_bands,1,[0;0;0],3*36,3*18,n',0); axis equal;
hold on; plot3([0 rd(1)],[0 rd(2)],[0 rd(3)]); view(-240,10);
xlabel('x'); ylabel('y'); zlabel('z');

hpsf(2:end)
