function [n_c, n_e, c_e, a_c] = simpleVertexNormals(el,co)
    n_c = 0*co;
    n_e = 0*el;
    c_e = 0*el;
    a_c = 0*co(:,1);
    
    for k=1:size(el,1)
        % corners of triangle k
        a = co(el(k,1),:);
        b = co(el(k,2),:);
        c = co(el(k,3),:);
        
        c_e(k,:) = (a+b+c)/3;
        
        n_e(k,:) = cross(b-a,c-a); % contains an area weight
        a_c(el(k,:)) = a_c(el(k,:)) + norm( n_e(k,:) )/3;
        
        n_c(el(k,:),:) = n_c(el(k,:),:) + n_e(k,:);
    end
    % normalize
    n_e = n_e ./ (sum(n_e.^2,2).^.5);
    n_c = n_c ./ (sum(n_c.^2,2).^.5);
end