function [w,dw] = shapeFcnP2tri(elco, p)
    % p (3x1) contains barycentric coords of evaluation point
    % elco contains node coordinates by row (first row = first node)
    V1 = elco(1,:)';
    V2 = elco(2,:)';
    V3 = elco(3,:)';
    
    w = [ % note that barycentric coords are p = [ 1-s-t ; s ; t ]
        2*p.^2-p
        4*p(1)*p(2)
        4*p(1)*p(3)
        4*p(2)*p(3)
    ];    

    % Jacobian of the mapping from reference to actual element
    dPhi = [ V2-V1 V3-V1 cross(V2-V1,V3-V1)]; % 3rd column: any vector normal to the triangle
    dw_ref = [ % for coords on ref.tri. (0,0),(1,0),(0,1) in (s,t) in 2D
        1-4*p(1)        1-4*p(1)        0 % phi_1 = 2*(1-s-t)^2-(1-s-t)
        4*p(2)-1        0               0 % phi_2 = 2*s^2-s
        0               4*p(3)-1        0 % phi_3 = 2*t^2-t
        4*p(1)-4*p(2)   -4*p(2)         0 % phi_4 = 4*(1-s-t)*s  
        -4*p(3)         4*p(1)-4*p(3)   0 % phi_5 = 4*(1-s-t)*t  
        4*p(3)          4*p(2)          0 % phi_6 = 4*s*t
        ]'; % padded with zeros (shape functions do not have an out-of-plane derivative!)
    dw = dPhi' \ dw_ref; % this way, we get a 3x3 system again, and shape function gradients are strictly in-plane
end