% linear shape function value and gradients for a linear triangle element
% input: 
% elco: (3x3) (x,y,z)-coordinates of the three nodes of the element 
%    p: (1x3) barycentric coordinates of the evaluation point (1-s-t, s, t)
% output:
%    w: (1x3) shape function values at p
%   dw: (3x3) shape function gradients at p
function [w,dw] = shapeFcnP1tri(elco, p)
    V1 = elco(1,:)';
    V2 = elco(2,:)';
    V3 = elco(3,:)';
    
    % Jacobian of the mapping from reference to actual element
    dPhi = [ V2-V1 V3-V1 cross(V2-V1,V3-V1)]; % 3rd column: any vector normal to the triangle
    dw_ref = [
        -1 1 0  
        -1 0 1
         0 0 0]; % last line is out-of-plane gradient
    dw = dPhi' \ dw_ref;
     w = p; % for linear shape functions their values are the barycentric coords of p
end