%% run some tests for specular projection ...

clc; clear variables; close all;
obj = read_wobj('tilted_plane.obj');
co = obj.vertices;
el = obj.objects( strcmp({obj.objects(:).type}, 'f') ).data.vertices;

opt.specular=1;

k=1;
u=0.3; v=0.3;
rd=[0 -1 0];
rd2=[0 -0.5 0.5]; rd2=rd2./norm(rd2);

opt.sphm_bands=6;

% set zero
psf = simpleSH([0 0 0],0, opt)';

% psf = psf + simpleSH([0 0 -1], 1 , opt)';

% "sample" the hemisphere ...
h = 5;
theta = linspace(0,pi,h);
n=0;
for i=1:h
    phi = linspace(0,2*pi,  1+ceil(sin(theta(i))*2*h+1e-6) );
    phi = phi(1:end-1);
    [x,y,z] = sph2cart(phi,pi/2-theta(i),0*phi+1);
    plot3(x,y,z,'x'); axis equal; hold on;
    
    for j=1:length(x)
        disp([i j length(x) h]);
        f = sin(x(j)).^2; %1;
        sph = simpleSH([x(j) y(j) z(j)], f , opt)';
        psf = psf + sph;
        n = n+1;

%         sphm_plot(sph,opt.sphm_bands, 1,[0;0;0],3*18,3*36,0); axis equal;
%         xlabel('x'); ylabel('y'); zlabel('z'); colorbar;
%         drawnow; pause;

    end
end
psf = psf*4*pi/n; % solid angle covered by each sample is 4*pi/n

[~,v]=sphm_plot(psf,opt.sphm_bands, 1,[0;0;0],3*18,3*36,0); axis equal;
xlabel('x'); ylabel('y'); zlabel('z');
caxis([0 max(v(:))*1.1]);

function sph = simpleSH(ro,p,opt)
    n_coeffs = opt.sphm_bands * opt.sphm_bands;    
    sph = zeros(1,n_coeffs);
    % project ro to spherical harmonics coefficients
    [phi, theta] = cart2sph(ro(1),ro(2),ro(3));
    theta = pi/2 - theta; % [-pi/2 pi/2] --> [0 pi] (0 --> +z direction)
    for l = 0:(opt.sphm_bands-1)
        for m = -l:l
            sph(l*(l+1) + m +1) = p * sphm_Y(l, m, theta, phi);
        end
    end
end