% currently assumes [x,z] to be meshgrid arrays, and y to be scalar
function [phi, dphidx, dphidy, dphidz] = sampleObjFuncOnGrid(x,y,z, evalFun)

    % [x,z] = meshgrid( 0:-0.05:-6 , 0:-0.05:-5 );
    % [x,z] = meshgrid( 0:-1.0:-6 , 0:-1.0:-5 );
    % numel(x)/60/60
    scIdx = find(all([size(x) ; size(y) ; size(z)] == [1 1],2)); % find index of scalar variable in [x,y,z]
    assert( all(size(scIdx)==[1 1]) , 'exactly one input variable of (x,y,z) must be scalar');
    if     scIdx==1, xyzorder=[2 1 3];
    elseif scIdx==2, xyzorder=[1 2 3];
    elseif scIdx==3, xyzorder=[1 3 2];
    end
    [x,y,z] = reorderXYZ(x,y,z,xyzorder);

    phi = 0*x;
    dphidx = 0*x;
    dphidy = 0*x;
    dphidz = 0*x;
    %%
    for i = 1:size(x,1)
        for j = 1:size(x,2)
            %%
            disp(['*** run ' num2str( (i-1)*size(x,2)+j ) ' of ' num2str(numel(x)) ' ...']);            
            [xi,yi,zi] = reorderXYZ(x(i,j) ,  y , z(i,j),xyzorder);
            [p_ij, dphi] = evalFun([xi,yi,zi]);
            close(gcf);
            phi(i,j) = p_ij;
            dphidx(i,j) = dphi(1);
            dphidy(i,j) = dphi(2);
            dphidz(i,j) = dphi(3);
        end
    end
    %%
    scale=2.1;
    figure;  surf(x,z,scale*phi, 'EdgeAlpha',0); shading interp; axis equal;
    % hold on; quiver3(x,z,0*phi , -dphidx,-dphidz,-dphidy,'r','LineWidth',2);
    xlabel('x');ylabel('z');
    %%
    phi(phi==0)=min(phi(phi>0));
    figure;  imagesc(x(1,:)',z(:,1),phi);
    hold on; quiver(x,z , -dphidx,-dphidz,'r','LineWidth',0.5);
    %%
    [x,y,z] = reorderXYZ(x,y,z,xyzorder); %#ok
    [dphidx,dphidy,dphidz] = reorderXYZ(dphidx,dphidy,dphidz,xyzorder);
    %%
    save('_results.mat', 'x','y','z','phi', 'dphidx', 'dphidy', 'dphidz');
    
    function [x,y,z]=reorderXYZ(x_in, y_in, z_in, order)
        % order = [ 2 1 3 ]
        if  order(1)==2
            x = y_in;
        elseif order(1)==3
            x  = z_in;
        else
            x = x_in;
        end
        if  order(2)==1
            y = x_in;
        elseif order(2)==3
            y  = z_in;
        else
            y = y_in;
        end
        if  order(3)==1
            z = y_in;
        elseif order(3)==2
            z  = y_in;
        else
            z = z_in;
        end
    end
end