% let's try spherical harmonics ...
% requires opt.sphm_bands (will use 2*(.)+1 coefficients)
function sph = projectSpecularReflection_SPHM(el,co, k,u,v,rd,p, opt)
    n_coeffs = opt.sphm_bands * opt.sphm_bands;    
    sph = zeros(1,1+n_coeffs);
    if k<=0, return; end
    
    % diffuse component
    sph(1) = (1-opt.specular)*p/(4*pi);
    
    % normal on triangle k
    n = cross( (co(el(k,2),:)-co(el(k,1),:)) , (co(el(k,3),:)-co(el(k,1),:)) );
    n = n./norm(n);
    
    rn = n*dot(rd,n); % projection of rd onto n
    rp = rd-rn; % in-plane component of rd
    ro = 2*rp-rd; % reflected outgoing direction
    
    % project ro to spherical harmonics coefficients
    [phi, theta] = cart2sph(ro(1),ro(2),ro(3));
    theta = pi/2 - theta; % [-pi/2 pi/2] --> [0 pi] (0 --> +z direction)
    for l = 0:(opt.sphm_bands-1)
        for m = -l:l
            sph(l*(l+1) + m +2) = opt.specular*p * sphm_Y(l, m, theta, phi);
        end
    end



end