% currently a mesh-based implementation
% requires opt.usph_el and opt.usph_co with element list and node coordinates of a triangulated unit sphere
function pw = projectSpecularReflectionP2(el,co, k,u,v,rd,p, opt)
    pw = zeros(1,1+size(opt.usph_co,1)+max(opt.usph_ed(:))); % +1 for the diffuse component
    if k<=0, return; end
    % new: L2-project to account for area distribution on the unit sphere ...
    M = consistentMassP2tri(opt.usph_el, opt.usph_ed, opt.usph_co);
    M = [ sum(sum(M)) zeros(1,size(M,2)) ; zeros(size(M,1),1) M]; % first entry: 1 or sum(sum(M))==area~~4*pi ???

    % we have a ray intersecting element k incoming from direction rd with
    % power p that should be distributed to specular and diffuse components
    
    % diffuse component
    pw(1) = (1-opt.specular) * p;
   
    % a very basic approach: simply compute the reflected angle and
    % distribute the specular component to that part of the unit sphere
    % (assumes perfect specular reflection without additional blurring)
    % the resolution of the unit sphere will determine the amount of
    % blurring in the specular representation
    
    % normal on triangle k
    n = cross( (co(el(k,2),:)-co(el(k,1),:)) , (co(el(k,3),:)-co(el(k,1),:)) );
    n = n./norm(n);
    
    rn = n*dot(rd,n); % projection of rd onto n
    rp = rd-rn; % in-plane component of rd
    ro = 2*rp-rd; % reflected outgoing direction
    
    % project ro to unit sphere
    for l = 1:size(opt.usph_el,1)
        [isHit, u, v, d] = rayTriangleIntersection ([0,0,0], ro, ...
            opt.usph_co(opt.usph_el(l,1),:), ...
            opt.usph_co(opt.usph_el(l,2),:), ...
            opt.usph_co(opt.usph_el(l,3),:)  ...
        );
        if  isHit && d>0
            w = shapeFcnP2tri(opt.usph_co( opt.usph_el(l,:), :), [1-u-v ; u ; v] );
            gdofs = [opt.usph_el(l,:) , size(opt.usph_co,1) + opt.usph_ed(l,:)]; % first node-DOFs then edge-DOFs
            pw(1+gdofs) = pw(1+gdofs) + w'*(opt.specular * p); % +1 for diffuse component in (1)
            %break; % end loop once we've found an intersection
        end
    end
    pw = (M\pw')';
    
%     L = laplacianP2tri(opt.usph_el,opt.usph_co,opt.usph_ed);
%     L = [ zeros(1,size(M,2)) ; zeros(size(M,1)-1,1) L]; 
%     pw=((M+1e-4*L)\(M*pw'))'; % some smoothing
end