% currently a mesh-based implementation
% requires opt.usph_el and opt.usph_co with element list and node coordinates of a triangulated unit sphere
function pw = projectSpecularReflection(el,co, k,u,v,rd,p, opt)
    if  isfield(opt,'sphm_bands') % use spherical harmonics if opt contains the number of bands to be used
        if  isfield(opt,'sphm_useHemisphere')
            pw = projectSpecularReflection_HSPHM(el,co, k,u,v,rd,p, opt);
        else
            pw = projectSpecularReflection_SPHM(el,co, k,u,v,rd,p, opt);
        end
        return;
    end
    if  isfield(opt,'usph_ed') % use P2 elements if we also have edge indices in the mesh
        pw = projectSpecularReflectionP2(el,co, k,u,v,rd,p, opt);
        return;
    end

    pw = zeros(1,1+size(opt.usph_co,1)); % +1 for the diffuse component
    if k<=0, return; end
    
    % new: L2-project to account for area distribution on the unit sphere ...
    M = consistentMass(opt.usph_el, opt.usph_co);
    M = [ sum(sum(M)) zeros(1,size(M,2)) ; zeros(size(M,1),1) M]; % first entry: 1 or sum(sum(M))==area~~4*pi ???

    % we have a ray intersecting element k incoming from direction rd with
    % power p that should be distributed to specular and diffuse components
    
    % diffuse component
    pw(1) = (1-opt.specular) * p;
   
    % a very basic approach: simply compute the reflected angle and
    % distribute the specular component to that part of the unit sphere
    % (assumes perfect specular reflection without additional blurring)
    % the resolution of the unit sphere will determine the amount of
    % blurring in the specular representation
    
    % normal on triangle k
    n = cross( (co(el(k,2),:)-co(el(k,1),:)) , (co(el(k,3),:)-co(el(k,1),:)) );
    n = n./norm(n);
    
    rn = n*dot(rd,n); % projection of rd onto n
    rp = rd-rn; % in-plane component of rd
    ro = 2*rp-rd; % reflected outgoing direction
    
    % project ro to unit sphere
    for l = 1:size(opt.usph_el,1)
        [isHit, u, v, d] = rayTriangleIntersection ([0,0,0], ro, ...
            opt.usph_co(opt.usph_el(l,1),:), ...
            opt.usph_co(opt.usph_el(l,2),:), ...
            opt.usph_co(opt.usph_el(l,3),:)  ...
        );
        if  isHit && d>0
            pw(1+opt.usph_el(l,1)) = pw(1+opt.usph_el(l,1)) + (1-u-v)*(opt.specular * p);
            pw(1+opt.usph_el(l,2)) = pw(1+opt.usph_el(l,2)) +    u   *(opt.specular * p);
            pw(1+opt.usph_el(l,3)) = pw(1+opt.usph_el(l,3)) +      v *(opt.specular * p);
            %break; % end loop once we've found an intersection
        end
    end
    pw = (M\pw')';
end