function L = laplacianP2tri(el,co,ed)
    li = zeros(size(el,1)*36,1);
    lj = li;
    lv = li;
    [qp,qw] = gaussQuadratureTri();

    for k = 1:size(el,1)
        ar = 0.5*( norm(cross( co(el(k,2),:)-co(el(k,1),:) , co(el(k,3),:)-co(el(k,1),:) )));

        L_e = zeros(6,6);
        for i = 1:size(qp,1)
            [~,dw] = shapeFcnP2tri(co( el(k,:), :), qp(i,:)' );
            L_e = L_e + qw(i)*(dw'*dw); % dot product of shape functions
        end

        gdofs = [el(k,:) , size(co,1) + ed(k,:)]; % first node-DOFs then edge-DOFs
        idx = 36*(k-1)+(1:36);
        li(idx) = repmat(gdofs,1,6);
        lj(idx) = repelem(gdofs,6);
        lv(idx) = ar*L_e;
    end
    L = sparse(li,lj,lv);
end