function L = laplacianP1tri(el,co)
    li = zeros(size(el,1)*9,1);
    lj = li;
    lv = li;
    for k = 1:size(el,1)
        ar = 0.5*( norm(cross( co(el(k,2),:)-co(el(k,1),:) , co(el(k,3),:)-co(el(k,1),:) )));

        [~,dw] = shapeFcnP1tri(co( el(k,:), :), [1;1;1]/3 );
        L_e = dw'*dw; % dot product of shape functions

        gdofs = el(k,:);
        idx = 9*(k-1)+(1:9);
        li(idx) = repmat(gdofs,1,3);
        lj(idx) = repelem(gdofs,3);
        lv(idx) = ar*L_e;
    end
    L = sparse(li,lj,lv);
end