function [h,v,theta,phi]=hsphm_plot_interp(f1,f2,f3,w, sphm_bands,r,c,n_theta,n_phi,n,n1,n2,n3, lobe)
    theta = linspace(0, pi/2, n_theta); % theta is away from n
    phi = linspace(0, 2*pi, n_phi); % phi is in-plane orthogonal to n
    [theta, phi] = meshgrid(theta, phi);

    % ... rotate +z to n, +x to tangent
    n = n./norm(n);
    t = cross( n, [-n(2); n(3); n(1)]); t = t./norm(t); % not bullet-proof! ideally define consistent tangents over the whole mesh and store them
    % t must be (at least) consistent with the version in projectSpecularReflection_HSPHM
    % R*(+z)=n, R*(+x)=t, R*(+y)= nxt)
    R=[t, cross(n,t), n];

    v = zeros(size(theta));
    for i=1:size(v,1)
        for j=1:size(v,2)
            [x,y,z] = sph2cart(phi(i,j),pi/2-theta(i,j), 1);
            xyz = [x(:) y(:) z(:)]*R';
            xyz = xyz./norm(xyz);
            
            t1 = cross( n1, [-n1(2); n1(3); n1(1)]); t1 = t1./norm(t1);
            t2 = cross( n2, [-n2(2); n2(3); n2(1)]); t2 = t2./norm(t2);
            t3 = cross( n3, [-n3(2); n3(3); n3(1)]); t3 = t3./norm(t3);
            theta_1 = acos(dot(n1, xyz')); % theta is zenith angle from the normal
            phi_1 = atan2( dot(cross(n1,t1), xyz'), dot(t1, xyz') ); % atan2(y,x) .. y first!
            theta_2 = acos(dot(n2, xyz')); % theta is zenith angle from the normal
            phi_2 = atan2( dot(cross(n2,t2), xyz'), dot(t2, xyz') ); % atan2(y,x) .. y first!
            theta_3 = acos(dot(n3, xyz')); % theta is zenith angle from the normal
            phi_3 = atan2( dot(cross(n3,t3), xyz'), dot(t3, xyz') ); % atan2(y,x) .. y first!

            for l = 0:(sphm_bands-1)
                for m = -l:l
                    v(i,j) = v(i,j) + ...
                        f1(l*(l+1) + m +1)*w(1) * hsphm_Y(l, m, theta_1 , phi_1) +...
                        f2(l*(l+1) + m +1)*w(2) * hsphm_Y(l, m, theta_2 , phi_2) +...
                        f3(l*(l+1) + m +1)*w(3) * hsphm_Y(l, m, theta_3 , phi_3) ;
                end
            end
        end
    end

    
%     [i,j]=find(max(max(v))==v);
%     [theta(i(1),j(1)), phi(i(1),j(1))]
    
    if  lobe
        [x,y,z] = sph2cart(phi,pi/2-theta, r*abs(v)./max(abs(v(:))) );
    else
        [x,y,z] = sph2cart(phi,pi/2-theta, r*ones(size(theta)));
    end
    xyz = [x(:) y(:) z(:)]*R';
    
    x=reshape(xyz(:,1), size(x,1), size(x,2))+c(1);
    y=reshape(xyz(:,2), size(y,1), size(y,2))+c(2);
    z=reshape(xyz(:,3), size(z,1), size(z,2))+c(3);
    h=surf(x,y,z,v); shading interp;
end
