function [h,v,theta,phi]=hsphm_plot(f, sphm_bands,r,c,n_theta,n_phi,n, lobe)
    theta = linspace(0, pi/2, n_theta); % theta is away from n
    phi = linspace(0, 2*pi, n_phi); % phi is in-plane orthogonal to n
    [theta, phi] = meshgrid(theta, phi);

    v = zeros(size(theta));
    for i=1:size(v,1)
        for j=1:size(v,2)
            for l = 0:(sphm_bands-1)
                for m = -l:l
                    v(i,j) = v(i,j) + f(l*(l+1) + m +1) * hsphm_Y(l, m, theta(i,j), phi(i,j));
                end
            end
        end
    end

    % ... rotate +z to n, +x to tangent
    t = cross( n, [-n(2); n(3); n(1)]); t = t./norm(t); % not bullet-proof! ideally define consistent tangents over the whole mesh and store them
    % t must be (at least) consistent with the version in projectSpecularReflection_HSPHM
    % R*(+z)=n, R*(+x)=t, R*(+y)= nxt)
    R=[t, cross(n,t), n];
    
%     [i,j]=find(max(max(v))==v);
%     [theta(i(1),j(1)), phi(i(1),j(1))]
    
    if  lobe
        [x,y,z] = sph2cart(phi,pi/2-theta, r*abs(v)./max(abs(v(:))) );
    else
        [x,y,z] = sph2cart(phi,pi/2-theta, r*ones(size(theta)));
    end
    xyz = [x(:) y(:) z(:)]*R';
    
    x=reshape(xyz(:,1), size(x,1), size(x,2))+c(1);
    y=reshape(xyz(:,2), size(y,1), size(y,2))+c(2);
    z=reshape(xyz(:,3), size(z,1), size(z,2))+c(3);
    h=surf(x,y,z,v); shading interp;
end
