function [result] = hsphm_Y(l, m, theta, phi)
    result = 0;
    if( theta < 0 || theta > pi/2 ), return; end % refuse to evaluate on lower hemisphere

    P_cos = 2 * cos(theta) - 1; % To consider the upper part; the lower one takes 2x+1
    
    hsphm_P = sphm_P(l,abs(m),P_cos);
    hsphm_K = sqrt(((2*l+1) * factorial(l-abs(m)))/(2 * pi * factorial(l+abs(m))));
    if m == 0
        result = hsphm_K * hsphm_P;
    elseif m > 0
        result = hsphm_K * hsphm_P * cos( m*phi) *sqrt(2);
    elseif m < 0
        result = hsphm_K * hsphm_P * sin(-m*phi) *sqrt(2);
    end
end
