function [bnd, parent] = findBoundary(elems)
    % find the boundary edges of the triangles defined in elems
    edg = [
        elems(:,1) elems(:,2) (1:size(elems,1))'
        elems(:,2) elems(:,3) (1:size(elems,1))'
        elems(:,3) elems(:,1) (1:size(elems,1))'
    ];
    redg = [edg(:,2) edg(:,1)];
    [bnd,idx] = setdiff(edg(:,1:2),redg,'rows');
    parent = edg(idx,3);
end