clc; clear variables;

co = [-1 0 0
      1 2 3
      3 2 1];
% co = [-1 0 3
%       1 2 -1
%       3 2 1];
el = [ 1 2 3 ];

figure; trimesh(el,co(:,1),co(:,2),co(:,3),'FaceAlpha',0.5,'EdgeAlpha',1,'EdgeColor','k'); axis equal;

lp = [ 1,5,1 ]; ld = [0,-1,0]; ld = ld./norm(ld); rd=ld;
ds = 10;
hold on; plot3(lp(1),lp(2),lp(3),'o',[lp(1) lp(1)+ds*ld(1)],[lp(2) lp(2)+ds*ld(2)],[lp(3) lp(3)+ds*ld(3)]);

k=1;
[~, u, v, ~] = rayTriangleIntersection (lp, rd, co(el(k,1),:), co(el(k,2),:), co(el(k,3),:));
x = (1-u-v) * co(el(k,1),:) + u*co(el(k,2),:) + v*co(el(k,3),:);
plot3(x(1),x(2),x(3),'x');

e1 = co(el(k,2),:)-co(el(k,1),:);
e2 = co(el(k,3),:)-co(el(k,1),:);

% shape function gradients -- works
% how will u,v coords change if point x moves ...
% ... orthogonal (in-plane) direction, and inverse length as u,v go from 0 to 1 across the edge length
n = cross(e1,e2); n = n./norm(n);
dudx = cross(n,e2)./norm(e2); dudx = dudx./dot(e1,dudx); % first scale to unit vector, then divide by HEIGHT of triangle!
dvdx = cross(e1,n)./norm(e1); dvdx = dvdx./dot(e2,dvdx);

% quiver3(x(1),x(2),x(3), dudx(1),dudx(2),dudx(3),0); quiver3(x(1),x(2),x(3), dvdx(1),dvdx(2),dvdx(3),0);

% now we need dxdp, ie in cartesian space, how does the intersection point
% move __on the triangle__ if we change parameters
% ... maybe needlessly complicated

P = [n 0; eye(3) -rd'];
% x_= P\[dot(n,co(el(k,1),:)); lp']; % intersection ray and plane of tri (4th component is distance)
% x = P^-1 * (c;p) --> dxdp = P^-1 * (0; dpdp==eye(3))
dxdp = P\[zeros(1,3); eye(3)]; % derivative of intersection point in cartesian space (4th row is deriv. of distance) wrt. ray origin
dxdp = dxdp(1:3,1:3);
dudp = dudx*dxdp;
dvdp = dvdx*dxdp;
[dudp ; dvdp]

% from mupad P^-1 = matrix([[d_x/(d_x*n_x + d_y*n_y + d_z*n_z), (d_y*n_y + d_z*n_z)/(d_x*n_x + d_y*n_y + d_z*n_z), -(d_x*n_y)/(d_x*n_x + d_y*n_y + d_z*n_z), -(d_x*n_z)/(d_x*n_x + d_y*n_y + d_z*n_z)], [d_y/(d_x*n_x + d_y*n_y + d_z*n_z), -(d_y*n_x)/(d_x*n_x + d_y*n_y + d_z*n_z), (d_x*n_x + d_z*n_z)/(d_x*n_x + d_y*n_y + d_z*n_z), -(d_y*n_z)/(d_x*n_x + d_y*n_y + d_z*n_z)], [d_z/(d_x*n_x + d_y*n_y + d_z*n_z), -(d_z*n_x)/(d_x*n_x + d_y*n_y + d_z*n_z), -(d_z*n_y)/(d_x*n_x + d_y*n_y + d_z*n_z), (d_x*n_x + d_y*n_y)/(d_x*n_x + d_y*n_y + d_z*n_z)], [-1/(d_x*n_x + d_y*n_y + d_z*n_z), n_x/(d_x*n_x + d_y*n_y + d_z*n_z), n_y/(d_x*n_x + d_y*n_y + d_z*n_z), n_z/(d_x*n_x + d_y*n_y + d_z*n_z)]])


%%

% anayltic derivative of intersection algorithm -- works.
q  = cross(rd,e2);
a  = dot(e1,q);
dudp = q./a;
%rcross = [0 -e1(3) e1(2); e1(3) 0 -e1(1); -e1(2) e1(1) 0];
dvdp = cross(e1,rd)./a; %(rcross*rd')'./a;

quiver3(x(1),x(2),x(3), dudp(1),dudp(2),dudp(3),0); quiver3(x(1),x(2),x(3), dvdp(1),dvdp(2),dvdp(3),0);


% also implemented here:
[~, u, v, ~, dudp,dvdp] = rayTriangleIntersectionWithDerivative (lp, rd, co(el(k,1),:), co(el(k,2),:), co(el(k,3),:));

[dudp ; dvdp]

%% FD-test

fd_h = 1e-5;
fd_dudp = 0*dudp;
fd_dvdp = 0*dvdp;
for j=1:3
    dx = 0*lp; dx(j)=fd_h;
    [~, fd_u, fd_v] = rayTriangleIntersection (lp+dx, rd, co(el(k,1),:), co(el(k,2),:), co(el(k,3),:));
    fd_dudp(j) = (fd_u-u)./fd_h;
    fd_dvdp(j) = (fd_v-v)./fd_h;
end
[fd_dudp ; fd_dvdp]
quiver3(x(1),x(2),x(3), fd_dudp(1),fd_dudp(2),fd_dudp(3),0); quiver3(x(1),x(2),x(3), fd_dvdp(1),fd_dvdp(2),fd_dvdp(3),0);




