% input: triangle list (elements el) - (3 x m) array of node indices
% output: edge list (ed) - (3 x m) array of edge indices
%         edge index (edg_idx) - (2 x n) array of node indices per edge
function [ed, edg_idx] = edgeMap(el)
    edg_idx = [ el(:,[1 2]) ; el(:,[2 3]) ; el(:,[3 1]) ];
    edg_idx(edg_idx(:,1)>edg_idx(:,2),:) = edg_idx(edg_idx(:,1)>edg_idx(:,2),[2 1]);
    edg_idx = unique(edg_idx,'rows');

    ed = 0*el(:,1:2);
    for k = 1:size(el,1)
        e1 = sort(el(k,[1 2]));
        e2 = sort(el(k,[1 3]));
        e3 = sort(el(k,[2 3]));
        ed(k,1) = find(all(edg_idx == e1,2));
        ed(k,2) = find(all(edg_idx == e2,2));
        ed(k,3) = find(all(edg_idx == e3,2));
        assert(all(ed(k,:)>0),'edge index not found');
    end
end