clc;
hsh_bands = 8;
data = zeros(3, hsh_bands.^2 );
for l = 0:(hsh_bands-1)
    for m = -l:l
        v_n = hsphm_Y(l, m, 0, 0); % (theta,phi)=(0,0)
        v_t = hsphm_Y(l, m, pi/2*0.9, 0); % (theta,phi)=(81,0)
        v_b = hsphm_Y(l, m, pi/2*0.9, pi/2*0.9); % (theta,phi)=(81,81)

        idx = l*(l+1) + m +1;
        data(1,idx) = 0.2*( v_n ) / (1 + 1e-3 *((l * (l + 1)) * (l * (l + 1))));
        data(2,idx) = 0.2*( v_t ) / (1 + 1e-3 *((l * (l + 1)) * (l * (l + 1))));
        data(3,idx) = 0.2*( v_b ) / (1 + 1e-3 *((l * (l + 1)) * (l * (l + 1))));
    end
end
fprintf('%.6g, ',data');
figure;
hsphm_plot(data(1,:), hsh_bands, 0.4, [0;0;0],48,48,[0;0;1], 0); axis equal; hold all;
hsphm_plot(data(2,:), hsh_bands, 0.4, [0;1;0],48,48,[0;0;1], 0);
hsphm_plot(data(3,:), hsh_bands, 0.4, [1;0;0],48,48,[0;0;1], 0);
