function [d, dd] = convWstnDistance(el,co, x,g)
    M = consistentMass(el,co);

%     % for comparison: standard L2 distance ...
%     d = 0.5*(x-g)'*M*(x-g);
%     dd = M*(x-g);
%     return;
    
    % Convolutional 2-Wasserstein distance according to Justin: https://people.csail.mit.edu/jsolomon/assets/convolutional_w2.compressed.pdf
    scale = 1e-0;
    gamma = 1e-2;
    myeps = 1e-8;
    L = laplacianP1tri(el,co);
    Si = (M + gamma*L)\M;
    M = diag( sum(M) ); % replace by lumped masses (somehow baked into the derivation, full mass won't work properly)
    
    % x and g should be non-negative and sum to 1 (mass-weighted) ... (integrate to 1? sqrt(x'*M*x) instead of sum(M*x)???)
    mx = min(x)-eps; x = x-mx;
    nx = sum(M*x);
    x = x./nx;
    mg = min(g)-eps; g = g-mg;
    ng = sum(M*g);
    g = g./ng;
    
    d = 1/myeps;
    w1 = 0*x+1; w = w1; % v = 0*x+1;
    p0 = x; p1 = g;
    for i = 1:1000
%         tmp = Si*w;
%         tmp(abs(tmp)<myeps)=sign(tmp(abs(tmp)<myeps))*myeps; % stay away from zero
%         v = x ./ tmp; w1=v;
%         
%         tmp = Si*v;
%         tmp(abs(tmp)<myeps)=sign(tmp(abs(tmp)<myeps))*myeps; % stay away from zero
%         w = g ./ tmp;
% 
%         d_old = d;
%         d = scale*gamma*sum(  M* ( x.*log(v) + g.*log(w) )  );



        % update w0
        tmp = Si*(w1);
        tmp(abs(tmp)<myeps)=sign(tmp(abs(tmp)<myeps))*myeps; % stay away from zero: clamp(tmp, mOpt.epsilon);
        w0 = p1./ tmp;

        % update w1
        tmp = Si*(w0);
        tmp(abs(tmp)<myeps)=sign(tmp(abs(tmp)<myeps))*myeps; % stay away from zero: clamp(tmp, mOpt.epsilon);
        w1 = p0./ tmp;

        % update dist
        d_old = d;
        %d = computeKL(w0, w1);
        l0 = w0.* log(w0);
        l1 = w1.* log(w1);

        Kw0 = Si*(w0);
        Kw1 = Si*(w1);

        d = 0.0;
        d = d + dot(l0, Kw1);
        d = d + dot(l1, Kw0);
        d = scale*d;
        
        if abs(d-d_old)<myeps, break; end
%         [d i]
    end
    [d i]
    dd = scale*gamma* M*(log(w1)); % do we need to add chain rule terms in v ??? maybe ...
end