function M = consistentMassP2tri(el,ed,co)
    % reference element mass from MuPad ... *2 because ref.elem. has area 1/2
    M_e = 2.0 * [1.0/6.0e1,-1.0/3.6e2,-1.0/3.6e2,0.0,0.0,-1.0/9.0e1,-1.0/3.6e2,1.0/6.0e1,-1.0/3.6e2,0.0,-1.0/9.0e1,0.0,-1.0/3.6e2,-1.0/3.6e2,1.0/6.0e1,-1.0/9.0e1,0.0,0.0,0.0,0.0,-1.0/9.0e1,4.0/4.5e1,2.0/4.5e1,2.0/4.5e1,0.0,-1.0/9.0e1,0.0,2.0/4.5e1,4.0/4.5e1,2.0/4.5e1,-1.0/9.0e1,0.0,0.0,2.0/4.5e1,2.0/4.5e1,4.0/4.5e1];
    mi = zeros(size(el,1)*36,1);
    mj = mi;
    mv = mi;
    for k = 1:size(el,1)
        ar = 0.5*( norm(cross( co(el(k,2),:)-co(el(k,1),:) , co(el(k,3),:)-co(el(k,1),:) )));
        gdofs = [el(k,:) , size(co,1) + ed(k,:)]; % first node-DOFs then edge-DOFs
        idx = 36*(k-1)+(1:36);
        mi(idx) = repmat(gdofs,1,6);
        mj(idx) = repelem(gdofs,6);
        mv(idx) = ar*M_e;
%         M(gdofs,gdofs) = M(gdofs,gdofs) + ar*M_e;
    end
    M = sparse(mi,mj,mv);
end
