#pragma once
#include <tamashii/public.hpp>
#include <tamashii/core/scene/render_scene.hpp>

#include <list>
#include <memory>

T_BEGIN_NAMESPACE
struct RenderConfig_s {
	// statistic
	uint32_t			frame_index;
	// smoothed over multiple frames
	float				framerate_smooth;
	float				frametime_smooth;
	// raw time
	float				frametime; /* in milliseconds */

	bool				show_gui;
	bool				mark_lights;
};

class RenderSystem {
public:
										RenderSystem();
										~RenderSystem();

	//void								addBackend(std::unique_ptr<RenderBackend> aRenderBackend);
	bool								hasBackend() const { return !mRenderBackends.empty(); }

	void								init(tamashii::Window* aWindow = nullptr);
	void								registerMainWindow(tamashii::Window* aWindow) const;
	void								unregisterMainWindow(tamashii::Window* aWindow) const;
	void								shutdown();

	RenderConfig_s&						getConfig();
	bool								isInit() const;

	void								renderSurfaceResize(uint32_t aWidth, uint32_t aHeight) const;
	bool								drawOnMesh(const DrawInfo* aDrawInfo) const;

	void								processCommands();
	// scene
	const std::shared_ptr<RenderScene>& getMainScene() const;
	std::shared_ptr<RenderScene>		allocRenderScene();
	void								freeMainRenderScene();
	void								removeRenderScene(const std::shared_ptr<RenderScene>&);
	void								setMainRenderScene(std::shared_ptr<RenderScene> aRenderScene);
	// (un)load current main scene
	void								sceneLoad(const SceneBackendData& aScene) const;
	void								sceneUnload(const SceneBackendData& aScene) const;
	void								reloadCurrentScene() const;

	void								captureSwapchain(ScreenshotInfo_s* aScreenshotInfo) const;

	// swap between backend implementations
	void								addImplementation(RenderBackendImplementation* aImplementation) const;
	void								reloadBackendImplementation() const;
	void								changeBackendImplementation(int aIndex) const;
	bool								changeBackendImplementation(const char* name) const;

	std::vector<RenderBackendImplementation*>& getAvailableBackendImplementations() const;
	RenderBackendImplementation*		getCurrentBackendImplementations() const;
	RenderBackendImplementation*		findBackendImplementation(const char* name) const;

										static std::deque<std::shared_ptr<RenderBackend>> mRegisteredBackends;
private:

	void								updateStatistics();

	bool								mInit;
	RenderConfig_s						mRenderConfig;

	// scenes associated with this system
	std::list<std::shared_ptr<RenderScene>>	mScenes;
	std::shared_ptr<RenderScene>			mMainScene;


	// the renderer of this render system
	std::vector<std::shared_ptr<RenderBackend>>	mRenderBackends;
	std::shared_ptr<RenderBackend>				mCurrendRenderBackend;
};
T_END_NAMESPACE
