#pragma once
#include <tamashii/public.hpp>
#include <tamashii/core/forward.h>
#include <deque>

T_BEGIN_NAMESPACE
class MainGUI {
public:
												MainGUI();
	void										draw(UiConf_s* aUiConf);
	static void									translationValidityCheck(const std::shared_ptr<Ref>& aSelection, glm::vec3& aOldTranslation, glm::vec3& newTranslationObjectSpace);
	void										scalingValidityCheck(const std::shared_ptr<Ref> & ref, glm::vec3 &vec);


private:
	void										markLights();
	void										markCamera();
	void										showDraw();
	void										drawImGuizmo();
	void										drawGizmo() const;

	void										drawMenuBar();
	void										drawConsole();
	void										drawMenu();
	void										drawEdit();
	void										drawDraw() const;

	void										drawRightClickMenu() const;

	void										drawInfo() const;
	void										showSaveScene();
	void										showHelp();
	void										showAbout();

	static glm::quat							alignWindowWithModel(const std::unique_ptr<Light> &aLight, const RefModel &aRefModel);
	void										alignWindowWithModelRefLight(RefLight &aRefLight, const RefModel &aRefModel);

	ImGuiIO										*mIo;
	UiConf_s									*mUc;
	const float									mVerticalOffsetMenuBar;

	// imguizmo
	std::string									mOp;	// "Translate", "Scale", "Rotate"
	std::string									mMode;	// "Local", World
	std::deque<std::pair<std::shared_ptr<Ref>, glm::mat4>>	mHistory;

	bool										mShowHelp;
	bool										mShowAbout;
	bool										mShowSaveScene;
};
T_END_NAMESPACE