#define HLSL
#include "defines.h"
// #include "../utils.glsl"
// #include "../brdfs.glsl"

// #define CONV_TEXTURE_BINDING BINDLESS_IMAGE_DESC_BINDING
// #define CONV_TEXTURE_SET BINDLESS_IMAGE_DESC_SET
// #include "../convenience/glsl/texture_data.glsl"

// #define CONV_MATERIAL_BUFFER_BINDING GLOBAL_DESC_MATERIAL_BUFFER_BINDING
// #define CONV_MATERIAL_BUFFER_SET GLOBAL_DESC_SET
// #include "../convenience/glsl/material_data.glsl"

// #define CONV_LIGHT_BUFFER_BINDING GLOBAL_DESC_LIGHT_BUFFER_BINDING
// #define CONV_LIGHT_BUFFER_SET GLOBAL_DESC_SET
// #include "../convenience/glsl/light_data.glsl"


// layout(binding = GLOBAL_DESC_UBO_BINDING, set = GLOBAL_DESC_SET) uniform global_ubo { GlobalUbo ubo; };

[[vk::binding(RASTERIZER_DESC_GLOBAL_BUFFER_BINDING, RASTERIZER_DESC_SET)]] StructuredBuffer<GlobalBufferR> global_buffer;

struct VSOutput
{
    [[vk::location(0)]] float3 position : POSITION;
    [[vk::location(1)]] float4 normal : NORMAL0;
    [[vk::location(2)]] float4 tangent : TANGENT0;
    [[vk::location(3)]] float2 uv0 : TEXCOORD0;
    [[vk::location(4)]] float4 color0 : COLOR0;
};

struct PushConsts {
	float4x4 model_matrix;
	int material_idx;
};
[[vk::push_constant]] PushConsts pushConsts;

float4 main(VSOutput input) : SV_TARGET
{
	return float4(input.color0.xyz, 1.0);
}
//void main() {

    // Material_s material = material_buffer[material_idx];
    // // gl_PrimitiveID
    // vec4 baseColor = material.baseColorFactor;
    // // if no base color texture is set, use only base color factor
    // if(material.baseColorTexIdx != -1) baseColor *= texture(texture_sampler[material.baseColorTexIdx], v_uv0);
    // if (baseColor.a <= material.alphaDiscardValue) discard;

    // // occlusion
    // float occlusion = 0.0f;
    // if(material.occlusionTexIdx != -1){
    //     occlusion = texture(texture_sampler[material.occlusionTexIdx], v_uv0).r;
    //     occlusion *= material.occlusionStrength;
    //     baseColor.xyz *= occlusion;
    // }

    // // bitangent
	// vec3 b = normalize(cross(v_normal, v_tangent));
    // // normal map
    // vec3 n_nmap_ws = v_normal;
    // if(material.normalTexIdx != -1){
    //     vec3 n_nmap_ts = texture(texture_sampler[material.normalTexIdx], v_uv0).xyz;
    //     n_nmap_ws = nTangentSpaceToWorldSpace(n_nmap_ts, material.normalScale, v_tangent, b, v_normal);
    // }

    // // metallic
    // float metallic = 1.0f;
    // if(material.metallicTexIdx != -1){
    //     metallic = texture(texture_sampler[material.metallicTexIdx], v_uv0).r;
    // }
    // metallic *= material.metallicFactor;
    // // roughness
    // float roughness = 1.0f;
    // if(material.roughnessTexIdx != -1){
    //     roughness = texture(texture_sampler[material.roughnessTexIdx], v_uv0).r;
    // }
    // roughness *= material.roughnessFactor;


    // vec4 outColor = vec4(0,0,0,1);
    // // check if we have lights, otherwise just use base color
    // if(ubo.shade) {
    //     outColor.xyz += punctualLights((baseColor), frag_pos, n_nmap_ws, v_normal, roughness, metallic);
    // } else {
    //     outColor.xyz = baseColor.xyz;
    // }

    // vec3 out_srgb = linearToSRGB(outColor.xyz);
    // out_srgb = dither(out_srgb, ubo.dither_strength, randomFloatTriDist(gl_FragCoord.xy/ubo.size));
	// fragColor = vec4(out_srgb, 1);
//}