#ifndef GLSL_IALT_GGX
#define GLSL_IALT_GGX
#include "../utils/glsl/bxdfs/microfacet.glsl"
#include "../utils/glsl/bxdfs/fresnel.glsl"

bool plastic_sample_test(const vec3 wi, const vec3 n, const vec3 albedo, const float roughness, const float eta_i, const float eta_o, 
					const vec3 rand0, const vec2 rand1, out vec3 wo, out float pdf, out vec3 weight){
	const float wiDotN = dot(wi,n);
	const float sampleRoughness = roughness;//(1.2f - 0.2f*sqrt(abs(wiDotN)))*roughness;
	const float sampleAlpha = sampleRoughness * sampleRoughness;
	const vec3 m = ggx_sample(wi, n, sampleRoughness, rand0.xy);
	const float wiDotM = dot(wi,m);

	const float eta_i_m = eta_i;// wiDotM >= 0 ? eta_i : eta_o;
	const float eta_o_m = eta_o;//wiDotM >= 0 ? eta_o : eta_i;

	float cosThetaT;
	const float fi = F_Dielectric(eta_i, eta_o, wiDotN, cosThetaT);
	const bool reflection = rand0.z < fi;

	if(reflection) /* specular */ {
		wo = reflectionDir(wi, m);
	} else /* lambert */ {
		wo = normalize(tangentSpaceToWorldSpace(sampleUnitHemisphereCosine(rand1.xy), n));	
	}

    const float woDotN = dot(wo,n);
    const float woDotM = dot(wo,m);
	const float mDotN = dot(m,n);
	// make sure we are in the upper hemisphere
	// if (wiDotN <= 0.0f) return false; !!danger!!
	// make sure wi/wo are not parallel
	if (mDotN <= 0.0f) return false;
	//if (woDotN <= 0.0f) return false;
	// make sure wi and wo are correct for reflect/refract and wi/wo are not parallel
	//if (trans && reflection != ((wiDotN*woDotN) > 0.0f)) return false;
	if (all(equal(wi+wo, vec3(0.0f)))) return false;

	pdf = ggx_pdf(n, m, wi, sampleRoughness);
	//if (pdf < 1e-10f) return false;
	weight = vec3(ggx_weight(wiDotM, woDotM, wiDotN, woDotN, mDotN, sampleAlpha));
	if(reflection) /* specular */ {
		pdf *= D_PDF_M_TO_WO(woDotM);
		//equivalent (non shortened version): weight = vec3((abs(woDotN) * ggx_eval(wi,wo,n,m,roughness) * BSDF_GGX(wiDotN, woDotN)) / (pdf));
		pdf *= fi;

		//weight *= fi;
	} else /* lambert */ {
        pdf = max(woDotN, 0.0f) * M_INV_PI;
        // equivalent (non shortened version)
        //weight = (abs(woDotN) * albedo * M_INV_PI) / pdf;
        pdf *= (1.0f-fi);
        weight = albedo;
		
	}

	//if(pdf == 0) return false;
	if(isnan(pdf)) return false;

	#ifdef DEBUG_PRINT_BXDF_CHECK_NAN
	if(isnan(pdf)) debugPrintfEXT("NAN: dielectric_sample pdf");
	if(any(isnan(weight))) debugPrintfEXT("NAN: dielectric_sample weight");
	#endif
	return true;
}

bool plastic_sample(const vec3 wi, const vec3 n, const vec3 albedo, const float roughness, const float eta_i, const float eta_o, 
					const vec3 rand0, const vec2 rand1, out vec3 wo, out float pdf, out vec3 weight){
	const float wiDotN = dot(wi,n);
	const float sampleRoughness = roughness;//(1.2f - 0.2f*sqrt(abs(wiDotN)))*roughness;
	const float sampleAlpha = sampleRoughness * sampleRoughness;
	const vec3 m = ggx_sample(wi, n, sampleRoughness, rand0.xy);
	const float wiDotM = dot(wi,m);

	const float eta_i_m = eta_i;// wiDotM >= 0 ? eta_i : eta_o;
	const float eta_o_m = eta_o;//wiDotM >= 0 ? eta_o : eta_i;

	float cosThetaT;
	const float fi = F_Dielectric(eta_i, eta_o, wiDotN, cosThetaT);
	const bool reflection = rand0.z < fi;

	if(reflection) /* specular */ {
		wo = reflectionDir(wi, m);
	} else /* lambert */ {
		wo = normalize(tangentSpaceToWorldSpace(sampleUnitHemisphereCosine(rand1.xy), n));	
	}

    const float woDotN = dot(wo,n);
    const float woDotM = dot(wo,m);
	const float mDotN = dot(m,n);
	// make sure we are in the upper hemisphere
	// if (wiDotN <= 0.0f) return false; !!danger!!
	// make sure wi/wo are not parallel
	if (mDotN <= 0.0f) return false;
	//if (woDotN <= 0.0f) return false;
	// make sure wi and wo are correct for reflect/refract and wi/wo are not parallel
	//if (trans && reflection != ((wiDotN*woDotN) > 0.0f)) return false;
	if (all(equal(wi+wo, vec3(0.0f)))) return false;

	//pdf = ggx_pdf(n, m, wi, sampleRoughness);
	//if (pdf < 1e-10f) return false;
	//weight = vec3(ggx_weight(wiDotM, woDotM, wiDotN, woDotN, mDotN, sampleAlpha));
	if(reflection) /* specular */ {
		pdf = ggx_pdf(n, m, wi, sampleRoughness) * D_PDF_M_TO_WO(woDotM);
        weight = vec3(( ggx_eval(wi,wo,n,m,roughness) * BSDF_GGX(wiDotN, woDotN)));
		//equivalent (non shortened version): weight = vec3((abs(woDotN) * ggx_eval(wi,wo,n,m,roughness) * BSDF_GGX(wiDotN, woDotN)) / (pdf));
		pdf *= fi;

		//weight *= fi;
	} else /* lambert */ {
        pdf = max(woDotN, 0.0f) * M_INV_PI;
        // equivalent (non shortened version)
        weight = (albedo * M_INV_PI);
        pdf *= (1.0f-fi);
        //weight = albedo;
		
	}

	//if(pdf == 0) return false;
	if(isnan(pdf)) return false;

	#ifdef DEBUG_PRINT_BXDF_CHECK_NAN
	if(isnan(pdf)) debugPrintfEXT("NAN: dielectric_sample pdf");
	if(any(isnan(weight))) debugPrintfEXT("NAN: dielectric_sample weight");
	#endif
	return true;
}

#endif /* GLSL_IALT_GGX */
