#include "WangCloud.h"

osgCloudyDay::WangCloud::WangCloud(void) : num_indices(0), m_generator(0)
{
	vertices = (new osg::Vec3Array());
	rotation = (new osg::Vec4Array());
	center = (new osg::Vec4Array());
	ids = (new osg::Vec4Array());
	box_centers = (new osg::Vec4Array());
	color = (new osg::Vec4Array());
}


osgCloudyDay::WangCloud::WangCloud(int m_category) : num_indices(0), m_type(m_category), m_generator(0)
{
	vertices = (new osg::Vec3Array());
	rotation = (new osg::Vec4Array());
	center = (new osg::Vec4Array());
	ids = (new osg::Vec4Array());
	box_centers = (new osg::Vec4Array());
	color = (new osg::Vec4Array());
}

osgCloudyDay::WangCloud::WangCloud(int m_category, osg::ref_ptr<osg::Vec3Array> vertices, osg::ref_ptr<osg::Vec4Array> rotation, osg::ref_ptr<osg::Vec4Array> center, osg::ref_ptr<osg::Vec4Array> ids, osg::ref_ptr<osg::Vec4Array> boxcenters, osg::ref_ptr<osg::Vec3Array> ambientlight_h, osg::ref_ptr<osg::Vec3Array> ambientlight_t, osg::ref_ptr<osg::Vec3Array> diffuselight, osg::ref_ptr<osg::Vec4Array> color) : num_indices(0), m_type(m_category), m_generator(0)
{
	this->vertices = vertices;
	this->rotation = rotation;
	this->center = center;
	this->ids = ids;
	this->box_centers = boxcenters;
	this->color = color;
}

osgCloudyDay::WangCloud::~WangCloud(void)
{
	vertices->erase(vertices->begin(), vertices->end());
	rotation->erase(rotation->begin(), rotation->end());
	center->erase(center->begin(), center->end());
	ids->erase(ids->begin(), ids->end());
	box_centers->erase(box_centers->begin(), box_centers->end());
	color->erase(color->begin(), color->end());

	delete m_generator;
}

int osgCloudyDay::WangCloud::GetNumberOfParticles()
{
	return num_indices;	//-4, da ich 4 Vertices noch hinzugeben muss fr das Quad frs Blurren
}

void osgCloudyDay::WangCloud::GetBoundingBox()
{
	bb_min = osg::Vec3( 9999999.f,  99999999.f,  99999999.f);
	bb_max = osg::Vec3(-9999999.f, -99999999.f, -99999999.f);

	for(int i = vertices->size()-1; i >= 0; i--)
	{
		if(bb_min.x() > vertices->at(i).x()) bb_min.x() = vertices->at(i).x();
		if(bb_min.y() > vertices->at(i).y()) bb_min.y() = vertices->at(i).y();
		if(bb_min.z() > vertices->at(i).z()) bb_min.z() = vertices->at(i).z();

		if(bb_max.x() < vertices->at(i).x()) bb_max.x() = vertices->at(i).x();
		if(bb_max.y() < vertices->at(i).y()) bb_max.y() = vertices->at(i).y();
		if(bb_max.z() < vertices->at(i).z()) bb_max.z() = vertices->at(i).z();
	}
}

osg::Vec3 osgCloudyDay::WangCloud::BoundingBoxMin()
{
	return bb_min;
}

osg::Vec3 osgCloudyDay::WangCloud::BoundingBoxMax()
{
	return bb_max;
}

void osgCloudyDay::WangCloud::Setup()
{
	GetBoundingBox();
}

osg::Vec3Array* osgCloudyDay::WangCloud::GetVertices()
{
	return vertices;
}

osg::Vec4Array* osgCloudyDay::WangCloud::GetRotation()
{
	return rotation;
}

osg::Vec4Array* osgCloudyDay::WangCloud::GetCenter()
{
	return center;
}

osg::Vec4Array* osgCloudyDay::WangCloud::GetIds()
{
	return ids;
}

osg::Vec4Array* osgCloudyDay::WangCloud::GetBoxCenters()
{
	return box_centers;
}

osg::Vec4Array* osgCloudyDay::WangCloud::GetColor()
{
	return color;
}

void osgCloudyDay::WangCloud::SetCloudGenerator(osgCloudyDay::CloudGenerator* generator)
{
	m_generator = generator;
}

osgCloudyDay::CloudGenerator* osgCloudyDay::WangCloud::GetCloudGenerator()
{
	return m_generator;
}

int& osgCloudyDay::WangCloud::GetNumberOfIndices()
{
	return num_indices;
}

void osgCloudyDay::WangCloud::SetIds(osg::Vec4Array* id)
{
	ids = id;
}

void osgCloudyDay::WangCloud::SetCenter(osg::Vec4Array* cen)
{
	center = cen;
}

void osgCloudyDay::WangCloud::SetColor(osg::Vec4Array* col)
{
	color = col;
}

void osgCloudyDay::WangCloud::SetRotation(osg::Vec4Array* rot)
{
	rotation = rot;
}

void osgCloudyDay::WangCloud::SetVertices(osg::Vec3Array* vert)
{
	vertices = vert;
}

void osgCloudyDay::WangCloud::AddBoundingBox(osg::Vec3 origin, osg::Vec3 size, int startindex, int num_objects)
{
	boundingboxes.push_back(origin);
	boundingboxes_size.push_back(size);
	boundingboxes_start.push_back(startindex);
	boundingboxes_end.push_back(startindex+num_objects);
	m_bb2particle.push_back(std::vector<int>());
	for(int i = startindex; i < (startindex+num_objects); i++)
		m_bb2particle[m_bb2particle.size()-1].push_back(i);
}

unsigned int osgCloudyDay::WangCloud::GetNumberOfBoundingBoxes()
{
	return boundingboxes.size();
}

osg::Vec3 osgCloudyDay::WangCloud::GetBoundingBoxOriginAt(int at)
{
	return boundingboxes[at];
}

osg::Vec3 osgCloudyDay::WangCloud::GetBoundingBoxSizeAt(int at)
{
	return boundingboxes_size[at];
}

unsigned int osgCloudyDay::WangCloud::GetBoundingBoxStartIndex(int at)
{
	return boundingboxes_start[at];
}

unsigned int osgCloudyDay::WangCloud::GetBoundingBoxEndIndex(int at)
{
	return boundingboxes_end[at];
}
	
void osgCloudyDay::WangCloud::ClearBoundingBox()
{
	boundingboxes.clear();
	boundingboxes_size.clear();
	boundingboxes_start.clear();
	boundingboxes_end.clear();
	m_bb2particle.clear();
}

void osgCloudyDay::WangCloud::SetBoundingBoxStart(int n, size_t index)
{
	boundingboxes_start[n] = index;
}

void osgCloudyDay::WangCloud::SetBoundingBoxEnd(int n, size_t index)
{
	boundingboxes_end[n] = index;
}

void osgCloudyDay::WangCloud::EraseBoundingBoxAtIndex(int m)
{
	boundingboxes_start.erase(boundingboxes_start.begin()+m);
	boundingboxes_end.erase(boundingboxes_end.begin()+m);
	boundingboxes.erase(boundingboxes.begin()+m);	
	boundingboxes_size.erase(boundingboxes_size.begin()+m);	
	m_bb2particle.erase(m_bb2particle.begin()+m);	
	
}