#include "TerrainMIE.h"
#include "CloudScene.h"
#include <osgUtil/SmoothingVisitor>
#include <osgUtil/TangentSpaceGenerator>

osgCloudyDay::TerrainMIE::TerrainMIE(TerrainConfig* config)  : MyTerrain(config)
{
	mieTerrainProg = (new osg::Program);
}


osgCloudyDay::TerrainMIE::~TerrainMIE(void)
{
}

void osgCloudyDay::TerrainMIE::Initialize()
{
	std::cout << "TerrainMIE::Initialize()" << std::endl;
	osg::ref_ptr<osg::Image> img_ortho (osgDB::readImageFile(m_config->GetPath2DiffuseTexture()));
	tex_ortho = (new osg::Texture2D);
	tex_ortho->setImage(img_ortho.get());
	osg::ref_ptr<osg::Image> img_height (osgDB::readImageFile(m_config->GetPath2HeightTexture()));
	tex_height = (new osg::Texture2D);
	tex_height->setImage(img_height.get());

	osg::ref_ptr<osg::Image> img_sand (osgDB::readImageFile(m_config->GetPathAt(0)));
	osg::Texture2D* tex_sand = (new osg::Texture2D);
	tex_sand->setWrap(osg::Texture::WRAP_S, osg::Texture::REPEAT);
	tex_sand->setWrap(osg::Texture::WRAP_T, osg::Texture::REPEAT);
	tex_sand->setImage(img_sand.get());

	osg::ref_ptr<osg::Image> img_rock (osgDB::readImageFile(m_config->GetPathAt(1)));
	osg::Texture2D* tex_rock = (new osg::Texture2D);
	tex_rock->setWrap(osg::Texture::WRAP_S, osg::Texture::REPEAT);
	tex_rock->setWrap(osg::Texture::WRAP_T, osg::Texture::REPEAT);
	tex_rock->setImage(img_rock.get());

	osg::ref_ptr<osg::Image> img_grass (osgDB::readImageFile(m_config->GetPathAt(2)));
	osg::Texture2D* tex_grass = (new osg::Texture2D);
	tex_grass->setWrap(osg::Texture::WRAP_S, osg::Texture::REPEAT);
	tex_grass->setWrap(osg::Texture::WRAP_T, osg::Texture::REPEAT);
	tex_grass->setImage(img_grass.get());

	osg::ref_ptr<osg::Image> img_def (osgDB::readImageFile(m_config->GetPath2DefinationTexture()));
	tex_def = (new osg::Texture2D);
	tex_def->setWrap(osg::Texture::WRAP_S, osg::Texture::REPEAT);
	tex_def->setWrap(osg::Texture::WRAP_T, osg::Texture::REPEAT);
	tex_def->setImage(img_def.get());

	osg::ref_ptr<osg::Image> img_bump6 (osgDB::readImageFile(m_config->GetNormalPathAt(0)));
	osg::Texture2D* bump6_tex = (new osg::Texture2D);
	bump6_tex->setWrap(osg::Texture::WRAP_S, osg::Texture::REPEAT);
	bump6_tex->setWrap(osg::Texture::WRAP_T, osg::Texture::REPEAT);
	bump6_tex->setImage(img_bump6.get());

	osg::ref_ptr<osg::Image> img_bump4 (osgDB::readImageFile(m_config->GetNormalPathAt(1)));
	osg::Texture2D* bump4_tex = (new osg::Texture2D);
	bump4_tex->setWrap(osg::Texture::WRAP_S, osg::Texture::REPEAT);
	bump4_tex->setWrap(osg::Texture::WRAP_T, osg::Texture::REPEAT);
	bump4_tex->setImage(img_bump4.get());
	
	
	osg::ref_ptr<osg::Shader> mieTerrainvertShader(osg::Shader::readShaderFile (osg::Shader::VERTEX, "shaders/lightingMie.vert"));
	osg::ref_ptr<osg::Shader> mieTerrainfragShader(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/lightingMie.frag"));
	mieTerrainProg->addShader(mieTerrainvertShader.get());
	mieTerrainProg->addShader(mieTerrainfragShader.get());	


	//Binding the box shaders to its program
	
	mieTerrainProg->addBindFragDataLocation("out_color", 0);
	mieTerrainProg->addBindFragDataLocation("out_color2", 1);			
	
	osg::Node* terrain_obj = osgDB::readNodeFile(m_config->GetPath2File());		
	osg::ref_ptr<osg::Group> terrain_group = terrain_obj->asGroup();

	std::cout << "TerrainMIE::Initialize() - 9" << std::endl;

	for(unsigned int i = 0; terrain_group != 0 && i < terrain_group->getNumChildren(); i++)
	{
		osg::ref_ptr<osg::Geode> geode = terrain_group->getChild(i)->asGeode();		
		if(geode)
		{
			// Compute smoothed normals
			osgUtil::SmoothingVisitor smoother;
			smoother.apply( *geode );

			for(unsigned int j = 0; j < geode->getNumDrawables(); j++)
			{
				osg::Geometry* geo = geode->getDrawable(j)->asGeometry();
							
				if(geo)
				{				
					osg::ref_ptr< osgUtil::TangentSpaceGenerator > tsg = new osgUtil::TangentSpaceGenerator;
					tsg->generate( geo, 0 );
				
						osg::Array* tcoords = geo->getTexCoordArray(0);
						//osg::Array* norms = geo->getNormalArray();
						geo->setVertexAttribData( 1, osg::Geometry::ArrayData( tcoords, osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );					
						geo->setVertexAttribData( 5, osg::Geometry::ArrayData( tsg->getNormalArray(), osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );
						geo->setVertexAttribData( 6, osg::Geometry::ArrayData( tsg->getTangentArray(), osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );
						geo->setVertexAttribData( 7, osg::Geometry::ArrayData( tsg->getBinormalArray(), osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );								
					
				}
			}

			geode->addCullCallback(new ViewerLightCallback);
			
			osg::ref_ptr<osg::StateSet> heightmap_state = geode->getOrCreateStateSet();
			heightmap_state->addUniform(new osg::Uniform("ModelMatrix", Scene::GetViewMatrix_View()));
			heightmap_state->addUniform(new osg::Uniform("ProjectionMatrix", Scene::GetProjectionMatrix_View()));
			heightmap_state->addUniform(new osg::Uniform("ViewMatrix", Scene::GetViewMatrix_View()));			

			heightmap_state->addUniform(new osg::Uniform("v3LightPos", Scene::m_skydome->GetLightPosition()));
			
			Scene::m_skydome->SetupUniform(heightmap_state);

			heightmap_state->addUniform(new osg::Uniform("color_tex", 0));			
			
			heightmap_state->addUniform(new osg::Uniform("light_proj_matrix", Scene::GetProjectionMatrix_Light()));	
			heightmap_state->addUniform(new osg::Uniform("light_mv_matrix", Scene::GetLightCamera()->getViewMatrix()));	

			heightmap_state->addUniform(new osg::Uniform("tex0", 0));
			heightmap_state->addUniform(new osg::Uniform("shadow_tex", 1));	
			heightmap_state->addUniform(new osg::Uniform("shadow_tex2", 9));	
			heightmap_state->addUniform(new osg::Uniform("height_tex", 2));	

			heightmap_state->addUniform(new osg::Uniform("tex_sand", 3));
			heightmap_state->addUniform(new osg::Uniform("tex_rock", 4));
			heightmap_state->addUniform(new osg::Uniform("tex_grass", 5));
			heightmap_state->addUniform(new osg::Uniform("tex_def", 6));			

			heightmap_state->addUniform(new osg::Uniform("bump4_tex", 7));			
			heightmap_state->addUniform(new osg::Uniform("bump6_tex", 8));								

			heightmap_state->addUniform(new osg::Uniform("fogdensity", m_fog->GetFogDensity()));
			heightmap_state->addUniform(new osg::Uniform("fogheight", m_fog->GetFogHeight()));

			heightmap_state->setTextureAttributeAndModes(0,tex_ortho,osg::StateAttribute::ON);
			heightmap_state->setTextureAttributeAndModes(1,CloudScene::fbo_light_texture,osg::StateAttribute::ON);

			heightmap_state->setTextureAttributeAndModes(2,tex_height,osg::StateAttribute::ON);
			heightmap_state->setTextureAttributeAndModes(3,tex_sand,osg::StateAttribute::ON);
			heightmap_state->setTextureAttributeAndModes(4,tex_rock,osg::StateAttribute::ON);
			heightmap_state->setTextureAttributeAndModes(5,tex_grass,osg::StateAttribute::ON);
			heightmap_state->setTextureAttributeAndModes(6,tex_def,osg::StateAttribute::ON);			
			heightmap_state->setTextureAttributeAndModes(7,bump4_tex,osg::StateAttribute::ON);			
			heightmap_state->setTextureAttributeAndModes(8,bump6_tex,osg::StateAttribute::ON);			
			heightmap_state->setTextureAttributeAndModes(9,Scene::GetShadowTexture(),osg::StateAttribute::ON);		
	
			heightmap_state->setAttribute(mieTerrainProg.get());			
		}
	}
	
	trans = new osg::MatrixTransform(osg::Matrixd(1500.f, 0.f, 0.f, 0.f, 
												  0.f, 1500.f, 0.f, 0.f, 
												  0.f, 0.f, 1000.f, 0.f, 
												  0.f, 0.f,-1000.f, 1.f));
	trans->addChild(terrain_obj);



	osg::Node* terrain_light_obj = osgDB::readNodeFile(m_config->GetPath2File());		
	osg::ref_ptr<osg::Group> terrain_light_group = terrain_light_obj->asGroup();

	std::cout << "TerrainMIE::Initialize() - 9" << std::endl;

	for(unsigned int i = 0; terrain_light_group != 0 && i < terrain_light_group->getNumChildren(); i++)
	{
		osg::ref_ptr<osg::Geode> geode = terrain_light_group->getChild(i)->asGeode();		
		if(geode)
		{
			// Compute smoothed normals
			osgUtil::SmoothingVisitor smoother;
			smoother.apply( *geode );

			for(unsigned int j = 0; j < geode->getNumDrawables(); j++)
			{
				osg::Geometry* geo = geode->getDrawable(j)->asGeometry();
							
				if(geo)
				{									
					osg::Array* tcoords = geo->getTexCoordArray(0);
					//osg::Array* norms = geo->getNormalArray();
					geo->setVertexAttribData( 1, osg::Geometry::ArrayData( tcoords, osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );											
				}
			}

			geode->addCullCallback(new ViewerLightCallback);
			
			osg::ref_ptr<osg::StateSet> heightmap_state = geode->getOrCreateStateSet();
			heightmap_state->addUniform(new osg::Uniform("ModelMatrix", Scene::GetViewMatrix_View()));
			heightmap_state->addUniform(new osg::Uniform("ProjectionMatrix", Scene::GetProjectionMatrix_View()));
			heightmap_state->addUniform(new osg::Uniform("ViewMatrix", Scene::GetViewMatrix_View()));			

			heightmap_state->addUniform(new osg::Uniform("v3LightPos", Scene::m_skydome->GetLightPosition()));
			
			Scene::m_skydome->SetupUniform(heightmap_state);

			heightmap_state->addUniform(new osg::Uniform("color_tex", 0));			
			
			heightmap_state->addUniform(new osg::Uniform("light_proj_matrix", Scene::GetProjectionMatrix_Light()));	
			heightmap_state->addUniform(new osg::Uniform("light_mv_matrix", Scene::GetLightCamera()->getViewMatrix()));				
	
			heightmap_state->setAttribute(Scene::GetShadingProgram().get());			
		}
	}
	
	trans_light = new osg::MatrixTransform(osg::Matrixd(1500.f, 0.f, 0.f, 0.f, 
												  0.f, 1500.f, 0.f, 0.f, 
												  0.f, 0.f, 1000.f, 0.f, 
												  0.f, 0.f,-1000.f, 1.f));
	trans_light->addChild(terrain_light_obj);

	std::cout << "TerrainMIE::Initialize() - 12" << std::endl;
	
}