#include "TerrainHimmel.h"
#include "CloudScene.h"
#include <osg/PolygonMode>
#include <osgUtil/SmoothingVisitor>
#include <osgUtil/TangentSpaceGenerator>

osgCloudyDay::TerrainHimmel::TerrainHimmel(TerrainConfig* config, bool use_geometry_shader) : MyTerrain(config), fbo_lightshaft1(0), fbo_lightshaft2(0)
{
	m_use_geometry_shader = use_geometry_shader;
}


osgCloudyDay::TerrainHimmel::~TerrainHimmel(void)
{
}

void osgCloudyDay::TerrainHimmel::Initialize()
{
	osg::ref_ptr<osg::Image> img_ortho (osgDB::readImageFile(m_config->GetPath2DiffuseTexture()));
	tex_ortho = (new osg::Texture2D);
	tex_ortho->setImage(img_ortho.get());
	tex_ortho->setInternalFormat(GL_SRGB8);
	tex_ortho->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	tex_ortho->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);
	tex_ortho->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP);
	tex_ortho->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP);
	tex_ortho->setMaxAnisotropy(16.f);

	osg::ref_ptr<osg::Image> img_height (osgDB::readImageFile(m_config->GetPath2HeightTexture()));
	tex_height = (new osg::Texture2D);
	tex_height->setImage(img_height.get());
	tex_height->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	tex_height->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);
	tex_height->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP);
	tex_height->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP);
	tex_height->setMaxAnisotropy(16.f);

	/*osg::ref_ptr<osg::Image> img_nor (osgDB::readImageFile(m_config->GetPath2NormalTexture()));
	osg::Texture2D* tex_nor = (new osg::Texture2D);
	tex_nor->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP);
	tex_nor->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP);
	tex_nor->setImage(img_nor.get());	
	tex_nor->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	tex_nor->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);*/

	osg::ref_ptr<osg::Image> img_sand (osgDB::readImageFile(m_config->GetPathAt(0)));
	osg::Texture2D* tex_sand = (new osg::Texture2D);
	tex_sand->setWrap(osg::Texture::WRAP_S, osg::Texture::REPEAT);
	tex_sand->setWrap(osg::Texture::WRAP_T, osg::Texture::REPEAT);
	tex_sand->setImage(img_sand.get());
	tex_sand->setInternalFormat(GL_SRGB8);
	tex_sand->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	tex_sand->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);

	osg::ref_ptr<osg::Image> img_rock (osgDB::readImageFile(m_config->GetPathAt(1)));
	osg::Texture2D* tex_rock = (new osg::Texture2D);
	tex_rock->setWrap(osg::Texture::WRAP_S, osg::Texture::REPEAT);
	tex_rock->setWrap(osg::Texture::WRAP_T, osg::Texture::REPEAT);
	tex_rock->setImage(img_rock.get());
	tex_rock->setInternalFormat(GL_SRGB8);
	tex_rock->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	tex_rock->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);	

	osg::ref_ptr<osg::Image> img_grass (osgDB::readImageFile(m_config->GetPathAt(2)));
	osg::Texture2D* tex_grass = (new osg::Texture2D);
	tex_grass->setWrap(osg::Texture::WRAP_S, osg::Texture::REPEAT);
	tex_grass->setWrap(osg::Texture::WRAP_T, osg::Texture::REPEAT);
	tex_grass->setImage(img_grass.get());
	tex_grass->setInternalFormat(GL_SRGB8);
	tex_grass->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	tex_grass->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);

	osg::ref_ptr<osg::Image> img_rock2 (osgDB::readImageFile(m_config->GetPathAt(3)));
	osg::Texture2D* tex_rock2 = (new osg::Texture2D);
	tex_rock2->setWrap(osg::Texture::WRAP_S, osg::Texture::REPEAT);
	tex_rock2->setWrap(osg::Texture::WRAP_T, osg::Texture::REPEAT);
	tex_rock2->setImage(img_rock2.get());
	tex_rock2->setInternalFormat(GL_SRGB8);
	tex_rock2->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	tex_rock2->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);


	osg::ref_ptr<osg::Image> img_def (osgDB::readImageFile(m_config->GetPath2DefinationTexture()));
	tex_def = (new osg::Texture2D);
	tex_def->setWrap(osg::Texture::WRAP_S, osg::Texture::REPEAT);
	tex_def->setWrap(osg::Texture::WRAP_T, osg::Texture::REPEAT);
	tex_def->setImage(img_def.get());
	tex_def->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	tex_def->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);
	tex_def->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP);
	tex_def->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP);
	tex_def->setMaxAnisotropy(16.f);

	osg::ref_ptr<osg::Image> img_bump6 (osgDB::readImageFile(m_config->GetNormalPathAt(0)));
	osg::Texture2D* bump6_tex = (new osg::Texture2D);
	bump6_tex->setWrap(osg::Texture::WRAP_S, osg::Texture::REPEAT);
	bump6_tex->setWrap(osg::Texture::WRAP_T, osg::Texture::REPEAT);
	bump6_tex->setImage(img_bump6.get());
	bump6_tex->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	bump6_tex->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);	
	bump6_tex->setMaxAnisotropy(16.f);

	osg::ref_ptr<osg::Image> img_bump4 (osgDB::readImageFile(m_config->GetNormalPathAt(1)));
	osg::Texture2D* bump4_tex = (new osg::Texture2D);
	bump4_tex->setWrap(osg::Texture::WRAP_S, osg::Texture::REPEAT);
	bump4_tex->setWrap(osg::Texture::WRAP_T, osg::Texture::REPEAT);
	bump4_tex->setImage(img_bump4.get());	
	bump4_tex->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	bump4_tex->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);	
	bump4_tex->setMaxAnisotropy(16.f);

	osg::ref_ptr<osg::Image> img_glare (osgDB::readImageFile("../data/textures/atmosphere/sunglare.bmp"));
	osg::Texture2D* glare_tex = (new osg::Texture2D);
	glare_tex->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP);
	glare_tex->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP);
	glare_tex->setInternalFormat(GL_RGBA8);
	glare_tex->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	glare_tex->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);
	glare_tex->setImage(img_glare.get());

	std::cout << "texture 9" << std::endl;
	mieTerrainProg = (new osg::Program);	
	if(!m_use_geometry_shader)
	{
		osg::ref_ptr<osg::Shader> mieTerrainvertShader(osg::Shader::readShaderFile (osg::Shader::VERTEX, "shaders/precomputed.vert"));
		osg::ref_ptr<osg::Shader> mieTerrainfragShader(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/precomputed.frag"));
		mieTerrainProg->addShader(mieTerrainvertShader.get());
		mieTerrainProg->addShader(mieTerrainfragShader.get());	
	}
	else
	{
		osg::ref_ptr<osg::Shader> mieTerrainvertShader(osg::Shader::readShaderFile (osg::Shader::VERTEX,		"shaders/lightingHimmelDisp.vert"));
		osg::ref_ptr<osg::Shader> mieTerrainconShader(osg::Shader::readShaderFile (osg::Shader::TESSCONTROL,	"shaders/lightingHimmelDisp.con"));
		osg::ref_ptr<osg::Shader> mieTerrainevaShader(osg::Shader::readShaderFile (osg::Shader::TESSEVALUATION, "shaders/lightingHimmelDisp.eva"));
		osg::ref_ptr<osg::Shader> mieTerrainfragShader(osg::Shader::readShaderFile (osg::Shader::FRAGMENT,		"shaders/lightingHimmelDisp.frag"));

		mieTerrainProg->addShader(mieTerrainvertShader.get());
		mieTerrainProg->addShader(mieTerrainconShader.get());	
		mieTerrainProg->addShader(mieTerrainevaShader.get());	
		mieTerrainProg->addShader(mieTerrainfragShader.get());


		terrainShadowProg = new osg::Program;
		osg::ref_ptr<osg::Shader> mieTerrainvertShader2(osg::Shader::readShaderFile (osg::Shader::VERTEX,		"shaders/lightingHimmelDisp_shadow.vert"));
		osg::ref_ptr<osg::Shader> mieTerrainconShader2(osg::Shader::readShaderFile (osg::Shader::TESSCONTROL,	"shaders/lightingHimmelDisp_shadow.con"));
		osg::ref_ptr<osg::Shader> mieTerrainevaShader2(osg::Shader::readShaderFile (osg::Shader::TESSEVALUATION, "shaders/lightingHimmelDisp_shadow.eva"));
		osg::ref_ptr<osg::Shader> mieTerrainfragShader2(osg::Shader::readShaderFile (osg::Shader::FRAGMENT,		"shaders/lightingHimmelDisp_shadow.frag"));

		terrainShadowProg->addShader(mieTerrainvertShader2.get());
		terrainShadowProg->addShader(mieTerrainconShader2.get());	
		terrainShadowProg->addShader(mieTerrainevaShader2.get());	
		terrainShadowProg->addShader(mieTerrainfragShader2.get());
	}

	
	//Binding the box shaders to its program	
	mieTerrainProg->addBindFragDataLocation("out_color", 0);
	mieTerrainProg->addBindFragDataLocation("out_color2", 1);			
	if(m_use_geometry_shader)
	{
		mieTerrainProg->setParameter(GL_PATCH_VERTICES, 3);
		terrainShadowProg->addBindFragDataLocation("out_color", 0);
	}

	std::cout << "texture 11: " << m_config->GetPath2File() << std::endl;
	osg::Node* terrain_obj = osgDB::readNodeFile(m_config->GetPath2File());		
	osg::ref_ptr<osg::Group> terrain_group = terrain_obj->asGroup();

	std::cout << "texture 12" << std::endl;
	/*osg::Group** terrain_group2 = new osg::Group*[6];
	for(int i = 0; i < 6; i++)
		terrain_group2[i] = new osg::Group();
		*/	

	osg::ref_ptr<osg::PolygonMode> mode(new osg::PolygonMode());
	mode->setMode(  osg::PolygonMode::FRONT_AND_BACK, osg::PolygonMode::LINE );
	
	for(unsigned int i = 0; terrain_group != 0 && i < terrain_group->getNumChildren(); i++)
	{
		osg::ref_ptr<osg::Geode> geode = terrain_group->getChild(i)->asGeode();		
		if(geode)
		{
			// Compute smoothed normals
			osgUtil::SmoothingVisitor smoother;
			smoother.apply( *geode );

			for(unsigned int j = 0; j < geode->getNumDrawables(); j++)
			{
				osg::Geometry* geo = geode->getDrawable(j)->asGeometry();
							
				if(geo)
				{				
					osg::ref_ptr< osgUtil::TangentSpaceGenerator > tsg = new osgUtil::TangentSpaceGenerator;
					tsg->generate( geo, 0 );

					geo->setUseDisplayList(false);
					
					osg::Array* tcoords = geo->getTexCoordArray(0);
					//osg::Array* norms = geo->getNormalArray();
					geo->setVertexAttribData( 1, osg::Geometry::ArrayData( tcoords, osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );					
					geo->setVertexAttribData( 5, osg::Geometry::ArrayData( tsg->getNormalArray(), osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );
					geo->setVertexAttribData( 6, osg::Geometry::ArrayData( tsg->getTangentArray(), osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );
					geo->setVertexAttribData( 7, osg::Geometry::ArrayData( tsg->getBinormalArray(), osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );		
					
					//CONVERT FROM TRIANGLE_LIST TO TRIANGLE
					for(unsigned int k = 0; k < geo->getNumPrimitiveSets() && m_use_geometry_shader; k++)
					{											
						if(geo->getPrimitiveSet(k)->getMode() == 5 || geo->getPrimitiveSet(k)->getType() == 4)
						{						
							//osg::PrimitiveSet::Type::
							if(geo->getPrimitiveSet(k)->getType() == 4)
							{
								GLushort* oldindices = (GLushort*)(geo->getPrimitiveSet(k)->getDataPointer());																
								GLushort* indices = new GLushort[(geo->getPrimitiveSet(k)->getNumIndices()-2)*3];
							
								for(unsigned int l = 2; l < geo->getPrimitiveSet(k)->getNumIndices(); l++)
								{									
									indices[((l-2)*3)+0] = oldindices[l-0];
									indices[((l-2)*3)+1] = oldindices[l-1];
									indices[((l-2)*3)+2] = oldindices[l-2];																
								}

								geo->setPrimitiveSet(k, new osg::DrawElementsUShort( osg::PrimitiveSet::PATCHES, (geo->getPrimitiveSet(k)->getNumIndices()-2)*3, indices));								
							}
							else if(geo->getPrimitiveSet(k)->getType() == 1)
							{
								osg::DrawArrays* oldindices = static_cast<osg::DrawArrays*>(geo->getPrimitiveSet(k));																
								GLuint* indices = new GLuint[(geo->getPrimitiveSet(k)->getNumIndices()-2)*3];


								for(unsigned int l = 2; l < geo->getPrimitiveSet(k)->getNumIndices(); l++)
								{
									indices[((l-2)*3)+0] = (l-0);
									indices[((l-2)*3)+1] = (l-1);
									indices[((l-2)*3)+2] = (l-2);					
								}
															
								geo->setPrimitiveSet(k, new osg::DrawElementsUInt(osg::PrimitiveSet::PATCHES, (geo->getPrimitiveSet(k)->getNumIndices()-2)*3, &indices[0]));
							}							
						}						
						else	geo->getPrimitiveSet(k)->setMode(osg::PrimitiveSet::PATCHES);						
						geo->getPrimitiveSet(k)->dirty();
						geo->dirtyBound();
					}			
				}
			}
			geode->getOrCreateStateSet()->setMode( GL_CULL_FACE, osg::StateAttribute::OFF ); 
			geode->addCullCallback(new ViewerLightTerrainCallback);			
			geode->addUpdateCallback(new ViewerLightTerrainCallback);			
			

			osg::StateSet* heightmap_state = geode->getOrCreateStateSet();
			heightmap_state->addUniform(new osg::Uniform("ModelMatrix", Scene::GetViewMatrix_View()));
			heightmap_state->addUniform(new osg::Uniform("ProjectionMatrix", Scene::GetProjectionMatrix_View()));
			heightmap_state->addUniform(new osg::Uniform("ViewMatrix", Scene::GetViewMatrix_View()));			

			heightmap_state->addUniform(new osg::Uniform("v3LightPos", Scene::m_skydome->GetLightPosition()));			
			heightmap_state->addUniform(new osg::Uniform("color_tex", 0));			
			
			heightmap_state->addUniform(new osg::Uniform("light_proj_matrix", Scene::GetProjectionMatrix_Light()));	
			heightmap_state->addUniform(new osg::Uniform("light_mv_matrix", Scene::GetLightCamera()->getViewMatrix()));	

			if(m_fog)
			{
				heightmap_state->addUniform(new osg::Uniform("fogdensity", m_fog->GetFogDensity()));
				heightmap_state->addUniform(new osg::Uniform("fogheight", m_fog->GetFogHeight()));
			}
			else
			{
				heightmap_state->addUniform(new osg::Uniform("fogdensity", 0.f));
				heightmap_state->addUniform(new osg::Uniform("fogheight", 0.f));
			}

			heightmap_state->addUniform(new osg::Uniform("tex0", 0));
			heightmap_state->addUniform(new osg::Uniform("shadow_tex", 1));	
			heightmap_state->addUniform(new osg::Uniform("height_tex", 2));	

			heightmap_state->addUniform(new osg::Uniform("tex_sand", 3));	
			heightmap_state->addUniform(new osg::Uniform("tex_rock", 4));	
			heightmap_state->addUniform(new osg::Uniform("tex_grass", 5));	
			
			heightmap_state->addUniform(new osg::Uniform("tex_def", 6));			

			heightmap_state->addUniform(new osg::Uniform("bump4_tex", 7));			
			heightmap_state->addUniform(new osg::Uniform("bump6_tex", 17));				
			heightmap_state->addUniform(new osg::Uniform("bolder_tex", 15));															
			heightmap_state->addUniform(new osg::Uniform("shadow_tex2", 16));		

			heightmap_state->addUniform(new osg::Uniform("deltaAdd_tex", 13));							
			heightmap_state->addUniform(new osg::Uniform("deltaMult_tex", 14));									
			
			//heightmap_state->setAttribute(mode);

			heightmap_state->setTextureAttributeAndModes(0,tex_ortho,osg::StateAttribute::ON);
			heightmap_state->setTextureAttributeAndModes(1,CloudScene::fbo_light_texture,osg::StateAttribute::ON);

			heightmap_state->setTextureAttributeAndModes(2,tex_height,osg::StateAttribute::ON);
			
			heightmap_state->setTextureAttributeAndModes(3,tex_sand,osg::StateAttribute::ON);
			heightmap_state->setTextureAttributeAndModes(4,tex_rock,osg::StateAttribute::ON);
			heightmap_state->setTextureAttributeAndModes(5,tex_grass,osg::StateAttribute::ON);

			heightmap_state->setTextureAttributeAndModes(6,tex_def,osg::StateAttribute::ON);			

			heightmap_state->setTextureAttributeAndModes(7,bump4_tex,osg::StateAttribute::ON);			
			heightmap_state->setTextureAttributeAndModes(17,bump6_tex,osg::StateAttribute::ON);					
			heightmap_state->setTextureAttributeAndModes(15,tex_rock2,osg::StateAttribute::ON);		
			heightmap_state->setTextureAttributeAndModes(16,Scene::GetShadowTexture(),osg::StateAttribute::ON);		
			if(fbo_lightshaft1) heightmap_state->setTextureAttributeAndModes(13,fbo_lightshaft1);		
			if(fbo_lightshaft2) heightmap_state->setTextureAttributeAndModes(14,fbo_lightshaft2);		

			Scene::m_skydome->SetupUniform(heightmap_state);

			if(fbo_lightshaft1) heightmap_state->setTextureAttributeAndModes(13,fbo_lightshaft1);		
			if(fbo_lightshaft2) heightmap_state->setTextureAttributeAndModes(14,fbo_lightshaft2);		
			
			heightmap_state->setAttribute(mieTerrainProg.get());		
		}
	}
	
	osg::Node* terrainLight_obj = osgDB::readNodeFile(m_config->GetPath2File());		
	osg::ref_ptr<osg::Group> terrainLight_group = terrainLight_obj->asGroup();
	for(unsigned int i = 0; terrainLight_group != 0 && i < terrainLight_group->getNumChildren(); i++)
	{
		osg::ref_ptr<osg::Geode> geode = terrainLight_group->getChild(i)->asGeode();		
		if(geode)
		{
			// Compute smoothed normals
			osgUtil::SmoothingVisitor smoother;
			smoother.apply( *geode );

			for(unsigned int j = 0; j < geode->getNumDrawables(); j++)
			{
				osg::Geometry* geo = geode->getDrawable(j)->asGeometry();
							
				if(geo)
				{				
					osg::ref_ptr< osgUtil::TangentSpaceGenerator > tsg = new osgUtil::TangentSpaceGenerator;
					tsg->generate( geo, 0 );

					geo->setUseDisplayList(false);
					
					osg::Vec3Array* vecArray3 = dynamic_cast<osg::Vec3Array*>(geo->getVertexArray());					
					osg::Vec4Array* vecArray4 = dynamic_cast<osg::Vec4Array*>(geo->getVertexArray());

					if(!vecArray3) std::cerr << "VEC3 NULL" << std::endl;
					if(!vecArray4) std::cerr << "VEC4 NULL" << std::endl;

					osg::Array* tcoords = geo->getTexCoordArray(0);
					//osg::Array* norms = geo->getNormalArray();
					geo->setVertexAttribData( 1, osg::Geometry::ArrayData( tcoords, osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );					
					geo->setVertexAttribData( 5, osg::Geometry::ArrayData( tsg->getNormalArray(), osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );
					geo->setVertexAttribData( 6, osg::Geometry::ArrayData( tsg->getTangentArray(), osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );
					geo->setVertexAttribData( 7, osg::Geometry::ArrayData( tsg->getBinormalArray(), osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );		
					
					//CONVERT FROM TRIANGLE_LIST TO TRIANGLE
					for(unsigned int k = 0; k < geo->getNumPrimitiveSets() && m_use_geometry_shader; k++)
					{						
						//std::cout << "geo->getPrimitiveSet(k)->getMode(): " << geo->getPrimitiveSet(k)->getMode() << std::endl;
						if(geo->getPrimitiveSet(k)->getMode() == 5 || geo->getPrimitiveSet(k)->getType() == 4)
						{						
							//osg::PrimitiveSet::Type::
							if(geo->getPrimitiveSet(k)->getType() == 4)
							{
								GLushort* oldindices = (GLushort*)(geo->getPrimitiveSet(k)->getDataPointer());																
								GLushort* indices = new GLushort[(geo->getPrimitiveSet(k)->getNumIndices()-2)*3];
							
								for(unsigned int l = 2; l < geo->getPrimitiveSet(k)->getNumIndices(); l++)
								{
									osg::Vec3 d1 = vecArray3->at(oldindices[l-1]) - vecArray3->at(oldindices[l-2]);
									osg::Vec3 d2 = vecArray3->at(oldindices[l-0]) - vecArray3->at(oldindices[l-2]);
									osg::Vec3 h = d1^d2;

									if(h.z() > 0.f)
									{
										indices[((l-2)*3)+0] = oldindices[l-2];
										indices[((l-2)*3)+1] = oldindices[l-1];
										indices[((l-2)*3)+2] = oldindices[l-0];																
									}
									else
									{
										indices[((l-2)*3)+0] = oldindices[l-0];
										indices[((l-2)*3)+1] = oldindices[l-1];
										indices[((l-2)*3)+2] = oldindices[l-2];																
									}
								}

								geo->setPrimitiveSet(k, new osg::DrawElementsUShort( osg::PrimitiveSet::PATCHES, (geo->getPrimitiveSet(k)->getNumIndices()-2)*3, indices));								
							}
							else if(geo->getPrimitiveSet(k)->getType() == 1)
							{
								osg::DrawArrays* oldindices = static_cast<osg::DrawArrays*>(geo->getPrimitiveSet(k));																
								GLuint* indices = new GLuint[(geo->getPrimitiveSet(k)->getNumIndices()-2)*3];

								for(unsigned int l = 2; l < geo->getPrimitiveSet(k)->getNumIndices(); l++)
								{
									indices[((l-2)*3)+0] = (l-2);
									indices[((l-2)*3)+1] = (l-1);
									indices[((l-2)*3)+2] = (l-0);					
								}
															
								geo->setPrimitiveSet(k, new osg::DrawElementsUInt(osg::PrimitiveSet::PATCHES, (geo->getPrimitiveSet(k)->getNumIndices()-2)*3, &indices[0]));
							}
							else
							{
								std::cout << "Ende" << std::endl;
							}
						}						
						else	geo->getPrimitiveSet(k)->setMode(osg::PrimitiveSet::PATCHES);						
						geo->getPrimitiveSet(k)->dirty();
						geo->dirtyBound();
					}			
				}
			}
			
			osg::CullFace* cull2 = new osg::CullFace();
			cull2->setMode(osg::CullFace::FRONT);
			geode->getOrCreateStateSet()->setAttributeAndModes(cull2, osg::StateAttribute::ON);	

			geode->addCullCallback(new ViewerLightTerrainCallback);			
			geode->addUpdateCallback(new ViewerLightTerrainCallback);			
			
			osg::StateSet* heightmap_state = geode->getOrCreateStateSet();
			heightmap_state->addUniform(new osg::Uniform("ModelMatrix", Scene::GetViewMatrix_View()));
			heightmap_state->addUniform(new osg::Uniform("ProjectionMatrix", Scene::GetProjectionMatrix_View()));
			heightmap_state->addUniform(new osg::Uniform("ViewMatrix", Scene::GetViewMatrix_View()));			

			heightmap_state->addUniform(new osg::Uniform("v3LightPos", Scene::m_skydome->GetLightPosition()));
			
			heightmap_state->addUniform(new osg::Uniform("color_tex", 0));			
			
			heightmap_state->addUniform(new osg::Uniform("light_proj_matrix", Scene::GetProjectionMatrix_Light()));	
			heightmap_state->addUniform(new osg::Uniform("light_mv_matrix", Scene::GetLightCamera()->getViewMatrix()));				



			heightmap_state->addUniform(new osg::Uniform("tex0", 0));			
			heightmap_state->addUniform(new osg::Uniform("height_tex", 2));				
			heightmap_state->addUniform(new osg::Uniform("tex_def", 6));			

			heightmap_state->addUniform(new osg::Uniform("bump4_tex", 7));			
			heightmap_state->addUniform(new osg::Uniform("bump6_tex", 17));				
			heightmap_state->addUniform(new osg::Uniform("bolder_tex", 15));															

			heightmap_state->addUniform(new osg::Uniform("deltaAdd_tex", 13));							
			heightmap_state->addUniform(new osg::Uniform("deltaMult_tex", 14));									

			heightmap_state->setTextureAttributeAndModes(0,tex_ortho,osg::StateAttribute::ON);
			heightmap_state->setTextureAttributeAndModes(2,tex_height,osg::StateAttribute::ON);
			heightmap_state->setTextureAttributeAndModes(6,tex_def,osg::StateAttribute::ON);			
			heightmap_state->setTextureAttributeAndModes(7,bump4_tex,osg::StateAttribute::ON);			
			heightmap_state->setTextureAttributeAndModes(17,bump6_tex,osg::StateAttribute::ON);					
			heightmap_state->setTextureAttributeAndModes(15,tex_rock2,osg::StateAttribute::ON);		

			if(fbo_lightshaft1) heightmap_state->setTextureAttributeAndModes(13,fbo_lightshaft1);		
			if(fbo_lightshaft2) heightmap_state->setTextureAttributeAndModes(14,fbo_lightshaft2);		
			
			Scene::m_skydome->SetupUniform(heightmap_state);			

			if(!m_use_geometry_shader)	heightmap_state->setAttribute(Scene::GetShadingProgram().get());		
			else						heightmap_state->setAttribute(terrainShadowProg.get());		
		}
	}
	
	trans = new osg::MatrixTransform(osg::Matrixd(3000.f, 0.f, 0.f, 0.f, 
													0.f, 3000.f, 0.f, 0.f, 
													0.f, 0.f,1250.f, 0.f, 
													0.f, 0.f,-1250.f, 1.f));
	trans->addChild(terrain_obj);	


	trans_light = new osg::MatrixTransform( osg::Matrixd(3000.f, 0.f, 0.f, 0.f, 
														  0.f, 3000.f, 0.f, 0.f, 
														  0.f, 0.f,1250.f, 0.f, 
														  0.f, 0.f,-1250.f, 1.f));	
	trans_light->addChild(terrainLight_obj);
}

osg::ref_ptr<osg::Texture2D> osgCloudyDay::TerrainHimmel::GetLightshaft1()
{
	return fbo_lightshaft1;
}

osg::ref_ptr<osg::Texture2D> osgCloudyDay::TerrainHimmel::GetLightshaft2()
{
	return fbo_lightshaft2;
}

void osgCloudyDay::TerrainHimmel::SetLightshaft1(osg::ref_ptr<osg::Texture2D> tex)
{
	fbo_lightshaft1 = tex;
}

void osgCloudyDay::TerrainHimmel::SetLightshaft2(osg::ref_ptr<osg::Texture2D> tex)
{
	fbo_lightshaft2 = tex;
}