#include "TerrainGeometry.h"
#include <osgUtil/SmoothingVisitor>
#include <osgUtil/TangentSpaceGenerator>
#include "CloudScene.h"

osgCloudyDay::TerrainGeometry::TerrainGeometry(TerrainConfig* config)  : MyTerrain(config)
{
}


osgCloudyDay::TerrainGeometry::~TerrainGeometry(void)
{
}

void osgCloudyDay::TerrainGeometry::Initialize()
{
	osg::ref_ptr<osg::Image> img_ortho (osgDB::readImageFile(m_config->GetPath2DiffuseTexture()));
	tex_ortho = (new osg::Texture2D);
	tex_ortho->setImage(img_ortho.get());
	tex_ortho->setInternalFormat(GL_SRGB8);
	tex_ortho->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	tex_ortho->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);
	tex_ortho->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP);
	tex_ortho->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP);
	tex_ortho->setMaxAnisotropy(16.f);

	osg::ref_ptr<osg::Image> img_height (osgDB::readImageFile(m_config->GetPath2HeightTexture()));
	tex_height = (new osg::Texture2D);
	tex_height->setImage(img_height.get());
	tex_height->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	tex_height->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);
	tex_height->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP);
	tex_height->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP);
	tex_height->setMaxAnisotropy(16.f);

	osg::ref_ptr<osg::Image> img_sand (osgDB::readImageFile(m_config->GetPathAt(0)));
	osg::Texture2D* tex_sand = (new osg::Texture2D);
	tex_sand->setWrap(osg::Texture::WRAP_S, osg::Texture::REPEAT);
	tex_sand->setWrap(osg::Texture::WRAP_T, osg::Texture::REPEAT);
	tex_sand->setImage(img_sand.get());
	tex_sand->setWrap(osg::Texture::WRAP_S, osg::Texture::REPEAT);
	tex_sand->setWrap(osg::Texture::WRAP_T, osg::Texture::REPEAT);
	tex_sand->setImage(img_sand.get());
	tex_sand->setInternalFormat(GL_SRGB8);
	tex_sand->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	tex_sand->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);

	osg::ref_ptr<osg::Image> img_rock (osgDB::readImageFile(m_config->GetPathAt(1)));
	osg::Texture2D* tex_rock = (new osg::Texture2D);
	tex_rock->setImage(img_rock.get());
	tex_rock->setWrap(osg::Texture::WRAP_S, osg::Texture::REPEAT);
	tex_rock->setWrap(osg::Texture::WRAP_T, osg::Texture::REPEAT);
	tex_rock->setImage(img_rock.get());
	tex_rock->setInternalFormat(GL_SRGB8);
	tex_rock->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	tex_rock->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);	

	osg::ref_ptr<osg::Image> img_grass (osgDB::readImageFile(m_config->GetPathAt(2)));
	osg::Texture2D* tex_grass = (new osg::Texture2D);
	tex_grass->setWrap(osg::Texture::WRAP_S, osg::Texture::REPEAT);
	tex_grass->setWrap(osg::Texture::WRAP_T, osg::Texture::REPEAT);
	tex_grass->setImage(img_grass.get());
	tex_grass->setInternalFormat(GL_SRGB8);
	tex_grass->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	tex_grass->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);

	osg::ref_ptr<osg::Image> img_rock2 (osgDB::readImageFile(m_config->GetPathAt(3)));
	osg::Texture2D* tex_rock2 = (new osg::Texture2D);
	tex_rock2->setWrap(osg::Texture::WRAP_S, osg::Texture::REPEAT);
	tex_rock2->setWrap(osg::Texture::WRAP_T, osg::Texture::REPEAT);
	tex_rock2->setImage(img_rock2.get());
	tex_rock2->setInternalFormat(GL_SRGB8);
	tex_rock2->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	tex_rock2->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);


	osg::ref_ptr<osg::Image> img_def (osgDB::readImageFile(m_config->GetPath2DefinationTexture()));
	tex_def = (new osg::Texture2D);
	tex_def->setWrap(osg::Texture::WRAP_S, osg::Texture::REPEAT);
	tex_def->setWrap(osg::Texture::WRAP_T, osg::Texture::REPEAT);
	tex_def->setImage(img_def.get());
	tex_def->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	tex_def->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);
	tex_def->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP);
	tex_def->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP);
	tex_def->setMaxAnisotropy(16.f);

	osg::ref_ptr<osg::Image> img_bump6 (osgDB::readImageFile(m_config->GetNormalPathAt(0)));
	osg::Texture2D* bump6_tex = (new osg::Texture2D);
	bump6_tex->setWrap(osg::Texture::WRAP_S, osg::Texture::REPEAT);
	bump6_tex->setWrap(osg::Texture::WRAP_T, osg::Texture::REPEAT);
	bump6_tex->setImage(img_bump6.get());
	bump6_tex->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	bump6_tex->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);	
	bump6_tex->setMaxAnisotropy(16.f);

	osg::ref_ptr<osg::Image> img_bump4 (osgDB::readImageFile(m_config->GetNormalPathAt(1)));
	osg::Texture2D* bump4_tex = (new osg::Texture2D);
	bump4_tex->setWrap(osg::Texture::WRAP_S, osg::Texture::REPEAT);
	bump4_tex->setWrap(osg::Texture::WRAP_T, osg::Texture::REPEAT);
	bump4_tex->setImage(img_bump4.get());	
	bump4_tex->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	bump4_tex->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);	
	bump4_tex->setMaxAnisotropy(16.f);
	
	osg::ref_ptr<osg::Program> mieTerrainProg (new osg::Program);
	osg::ref_ptr<osg::Shader> mieTerrainvertShader(osg::Shader::readShaderFile (osg::Shader::VERTEX, "shaders/lightingMieDisp.vert"));
	osg::ref_ptr<osg::Shader> mieTerrainconShader(osg::Shader::readShaderFile (osg::Shader::TESSCONTROL, "shaders/lightingMieDisp.con"));
	osg::ref_ptr<osg::Shader> mieTerrainevaShader(osg::Shader::readShaderFile (osg::Shader::TESSEVALUATION, "shaders/lightingMieDisp.eva"));
	osg::ref_ptr<osg::Shader> mieTerrainfragShader(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/lightingMieDisp.frag"));

	//Binding the box shaders to its program
	mieTerrainProg->addShader(mieTerrainvertShader.get());
	mieTerrainProg->addShader(mieTerrainconShader.get());	
	mieTerrainProg->addShader(mieTerrainevaShader.get());	
	mieTerrainProg->addShader(mieTerrainfragShader.get());	
	mieTerrainProg->addBindFragDataLocation("out_color", 0);
	mieTerrainProg->addBindFragDataLocation("out_color2", 1);	
	mieTerrainProg->setParameter(GL_PATCH_VERTICES, 3);
	//mieTerrainProg->setParameter(GL_GEOMETRY_INPUT_TYPE_EXT, GL_TRIANGLES);
	//mieTerrainProg->setParameter(GL_GEOMETRY_OUTPUT_TYPE_EXT, GL_TRIANGLES);

	osg::Node* terrain_obj = osgDB::readNodeFile(m_config->GetPath2File());		
	osg::ref_ptr<osg::Group> terrain_group = terrain_obj->asGroup();	

	for(unsigned int i = 0; terrain_group != 0 && i < terrain_group->getNumChildren(); i++)
	{
		osg::ref_ptr<osg::Geode> geode = terrain_group->getChild(i)->asGeode();		
		if(geode)
		{
			for(unsigned int j = 0; j < geode->getNumDrawables(); j++)
			{
				osg::Geometry* geo = geode->getDrawable(j)->asGeometry();				

				if(geo)
				{				
					osg::ref_ptr< osgUtil::TangentSpaceGenerator > tsg = new osgUtil::TangentSpaceGenerator;
					tsg->generate( geo, 0 );

					geo->setUseDisplayList(false);
					
					osg::Array* tcoords = geo->getTexCoordArray(0);
					//osg::Array* norms = geo->getNormalArray();
					geo->setVertexAttribData( 1, osg::Geometry::ArrayData( tcoords, osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );					
					geo->setVertexAttribData( 5, osg::Geometry::ArrayData( tsg->getNormalArray(), osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );
					geo->setVertexAttribData( 6, osg::Geometry::ArrayData( tsg->getTangentArray(), osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );
					geo->setVertexAttribData( 7, osg::Geometry::ArrayData( tsg->getBinormalArray(), osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );		
					
					std::cout << "geo->getNumPrimitiveSets: " << geo->getNumPrimitiveSets() << std::endl;
					//CONVERT FROM TRIANGLE_LIST TO TRIANGLE
					for(unsigned int k = 0; k < geo->getNumPrimitiveSets() && m_use_geometry_shader; k++)
					{						
						//std::cout << "geo->getPrimitiveSet(k)->getMode(): " << geo->getPrimitiveSet(k)->getMode() << std::endl;
						if(geo->getPrimitiveSet(k)->getMode() == 5 || geo->getPrimitiveSet(k)->getType() == 4)
						{																				
							if(geo->getPrimitiveSet(k)->getType() == 4)
							{
								GLushort* oldindices = (GLushort*)(geo->getPrimitiveSet(k)->getDataPointer());																
								GLushort* indices = new GLushort[(geo->getPrimitiveSet(k)->getNumIndices()-2)*3];
							
								for(unsigned int l = 2; l < geo->getPrimitiveSet(k)->getNumIndices(); l++)
								{
									indices[((l-2)*3)+0] = oldindices[l-2];
									indices[((l-2)*3)+1] = oldindices[l-1];
									indices[((l-2)*3)+2] = oldindices[l-0];																
								}

								geo->setPrimitiveSet(k, new osg::DrawElementsUShort( osg::PrimitiveSet::PATCHES, (geo->getPrimitiveSet(k)->getNumIndices()-2)*3, indices));								
							}
							else if(geo->getPrimitiveSet(k)->getType() == 1)
							{
								osg::DrawArrays* oldindices = static_cast<osg::DrawArrays*>(geo->getPrimitiveSet(k));																
								GLuint* indices = new GLuint[(geo->getPrimitiveSet(k)->getNumIndices()-2)*3];

								for(unsigned int l = 2; l < geo->getPrimitiveSet(k)->getNumIndices(); l++)
								{
									indices[((l-2)*3)+0] = (l-2);
									indices[((l-2)*3)+1] = (l-1);
									indices[((l-2)*3)+2] = (l-0);					
								}
															
								geo->setPrimitiveSet(k, new osg::DrawElementsUInt(osg::PrimitiveSet::PATCHES, (geo->getPrimitiveSet(k)->getNumIndices()-2)*3, &indices[0]));
							}
							else
							{
								std::cout << "Ende" << std::endl;
							}
						}						
						else	geo->getPrimitiveSet(k)->setMode(osg::PrimitiveSet::PATCHES);						
						geo->getPrimitiveSet(k)->dirty();
						geo->dirtyBound();
					}			
				}
			}
			
			geode->getOrCreateStateSet()->setMode( GL_CULL_FACE, osg::StateAttribute::OFF ); 
			geode->addCullCallback(new ViewerLightCallback);

			osg::StateSet* heightmap_state = geode->getOrCreateStateSet();
			//heightmap_state->setTextureAttributeAndModes(0,tex_ortho,osg::StateAttribute::ON);			
			heightmap_state->addUniform(new osg::Uniform("ProjectionMatrix", Scene::GetProjectionMatrix_View()));
			heightmap_state->addUniform(new osg::Uniform("ViewMatrix", Scene::GetViewMatrix_View()));
			heightmap_state->addUniform(new osg::Uniform("ModelMatrix", osg::Matrixd()));	

			heightmap_state->addUniform(new osg::Uniform("fogdensity", m_fog->GetFogDensity()));
			heightmap_state->addUniform(new osg::Uniform("fogheight", m_fog->GetFogHeight()));

#ifdef SHADOW_MAPPING
			heightmap_state->addUniform(new osg::Uniform("light_proj_matrix", Scene::GetProjectionMatrix_Light()));	
			heightmap_state->addUniform(new osg::Uniform("light_mv_matrix", Scene::GetLightCamera()->getViewMatrix()));	
#endif
			heightmap_state->addUniform(new osg::Uniform("tex0", 0));
			heightmap_state->addUniform(new osg::Uniform("shadow_tex", 1));				
			heightmap_state->addUniform(new osg::Uniform("height_tex", 2));	

			heightmap_state->addUniform(new osg::Uniform("tex_sand", 3));
			heightmap_state->addUniform(new osg::Uniform("tex_rock", 4));
			heightmap_state->addUniform(new osg::Uniform("tex_grass", 5));
			heightmap_state->addUniform(new osg::Uniform("tex_def", 6));			

			heightmap_state->addUniform(new osg::Uniform("bump4_tex", 7));			
			heightmap_state->addUniform(new osg::Uniform("bump6_tex", 8));			

			heightmap_state->addUniform(new osg::Uniform("tex_def", 9));	
			heightmap_state->addUniform(new osg::Uniform("shadow_tex2", 10));	

			//__________
			heightmap_state->addUniform(new osg::Uniform("v3LightPos", Scene::m_skydome->GetLightPosition()));
			Scene::m_skydome->SetupUniform(heightmap_state);
			heightmap_state->addUniform(new osg::Uniform("color_tex", 0));		
			//__________

/*
osg::PolygonMode *polyModeObj;
polyModeObj = dynamic_cast< osg::PolygonMode*>( heightmap_state->getAttribute( osg::StateAttribute::POLYGONMODE ));
if ( !polyModeObj ) {
	polyModeObj = new osg::PolygonMode;
	heightmap_state->setAttribute( polyModeObj );    
}
*/
			heightmap_state->setAttribute(mieTerrainProg.get());
	
			heightmap_state->setTextureAttributeAndModes(0,tex_ortho,osg::StateAttribute::ON);			
			heightmap_state->setTextureAttributeAndModes(1,CloudScene::fbo_light_texture,osg::StateAttribute::ON);

			heightmap_state->setTextureAttributeAndModes(2,tex_height,osg::StateAttribute::ON);
			heightmap_state->setTextureAttributeAndModes(3,tex_sand,osg::StateAttribute::ON);
			heightmap_state->setTextureAttributeAndModes(4,tex_rock,osg::StateAttribute::ON);
			heightmap_state->setTextureAttributeAndModes(5,tex_grass,osg::StateAttribute::ON);
			heightmap_state->setTextureAttributeAndModes(6,tex_def,osg::StateAttribute::ON);			

			heightmap_state->setTextureAttributeAndModes(7,bump4_tex,osg::StateAttribute::ON);			
			heightmap_state->setTextureAttributeAndModes(8,bump6_tex,osg::StateAttribute::ON);
			heightmap_state->setTextureAttributeAndModes(9,tex_rock2,osg::StateAttribute::ON);
			heightmap_state->setTextureAttributeAndModes(10,Scene::GetShadowTexture(),osg::StateAttribute::ON);
		}
	}	

	trans = new osg::MatrixTransform(osg::Matrixd(1500.f, 0.f, 0.f, 0.f, 
												  0.f, 1500.f, 0.f, 0.f, 
												  0.f, 0.f,1000.f, 0.f, 
												  0.f, 0.f,-1000.f, 1.f));	
	trans->addChild(terrain_obj);






	terrainShadowProg = new osg::Program;
	osg::ref_ptr<osg::Shader> mieTerrainvertShader2(osg::Shader::readShaderFile (osg::Shader::VERTEX,		"shaders/lightingMieDisp_shadow.vert"));
	osg::ref_ptr<osg::Shader> mieTerrainconShader2(osg::Shader::readShaderFile (osg::Shader::TESSCONTROL,	"shaders/lightingMieDisp_shadow.con"));
	osg::ref_ptr<osg::Shader> mieTerrainevaShader2(osg::Shader::readShaderFile (osg::Shader::TESSEVALUATION, "shaders/lightingMieDisp_shadow.eva"));
	osg::ref_ptr<osg::Shader> mieTerrainfragShader2(osg::Shader::readShaderFile (osg::Shader::FRAGMENT,		"shaders/lightingMieDisp_shadow.frag"));

	terrainShadowProg->addShader(mieTerrainvertShader2.get());
	terrainShadowProg->addShader(mieTerrainconShader2.get());	
	terrainShadowProg->addShader(mieTerrainevaShader2.get());	
	terrainShadowProg->addShader(mieTerrainfragShader2.get());


	osg::Node* terrain_light_obj = osgDB::readNodeFile(m_config->GetPath2File());		
	osg::ref_ptr<osg::Group> terrain_light_group = terrain_light_obj->asGroup();	

	for(unsigned int i = 0; terrain_light_group != 0 && i < terrain_light_group->getNumChildren(); i++)
	{
		osg::ref_ptr<osg::Geode> geode = terrain_light_group->getChild(i)->asGeode();		
		if(geode)
		{
			for(unsigned int j = 0; j < geode->getNumDrawables(); j++)
			{
				osg::Geometry* geo = geode->getDrawable(j)->asGeometry();				

				if(geo)
				{				
					osg::ref_ptr< osgUtil::TangentSpaceGenerator > tsg = new osgUtil::TangentSpaceGenerator;
					tsg->generate( geo, 0 );

					geo->setUseDisplayList(false);
					
					osg::Array* tcoords = geo->getTexCoordArray(0);
					//osg::Array* norms = geo->getNormalArray();
					geo->setVertexAttribData( 1, osg::Geometry::ArrayData( tcoords, osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );					
					geo->setVertexAttribData( 5, osg::Geometry::ArrayData( tsg->getNormalArray(), osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );
					geo->setVertexAttribData( 6, osg::Geometry::ArrayData( tsg->getTangentArray(), osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );
					geo->setVertexAttribData( 7, osg::Geometry::ArrayData( tsg->getBinormalArray(), osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );		
					
					std::cout << "geo->getNumPrimitiveSets: " << geo->getNumPrimitiveSets() << std::endl;
					//CONVERT FROM TRIANGLE_LIST TO TRIANGLE
					for(unsigned int k = 0; k < geo->getNumPrimitiveSets() && m_use_geometry_shader; k++)
					{						
						//std::cout << "geo->getPrimitiveSet(k)->getMode(): " << geo->getPrimitiveSet(k)->getMode() << std::endl;
						if(geo->getPrimitiveSet(k)->getMode() == 5 || geo->getPrimitiveSet(k)->getType() == 4)
						{																				
							if(geo->getPrimitiveSet(k)->getType() == 4)
							{
								GLushort* oldindices = (GLushort*)(geo->getPrimitiveSet(k)->getDataPointer());																
								GLushort* indices = new GLushort[(geo->getPrimitiveSet(k)->getNumIndices()-2)*3];
							
								for(unsigned int l = 2; l < geo->getPrimitiveSet(k)->getNumIndices(); l++)
								{
									indices[((l-2)*3)+0] = oldindices[l-2];
									indices[((l-2)*3)+1] = oldindices[l-1];
									indices[((l-2)*3)+2] = oldindices[l-0];																
								}

								geo->setPrimitiveSet(k, new osg::DrawElementsUShort( osg::PrimitiveSet::PATCHES, (geo->getPrimitiveSet(k)->getNumIndices()-2)*3, indices));								
							}
							else if(geo->getPrimitiveSet(k)->getType() == 1)
							{
								osg::DrawArrays* oldindices = static_cast<osg::DrawArrays*>(geo->getPrimitiveSet(k));																
								GLuint* indices = new GLuint[(geo->getPrimitiveSet(k)->getNumIndices()-2)*3];

								for(unsigned int l = 2; l < geo->getPrimitiveSet(k)->getNumIndices(); l++)
								{
									indices[((l-2)*3)+0] = (l-2);
									indices[((l-2)*3)+1] = (l-1);
									indices[((l-2)*3)+2] = (l-0);					
								}
															
								geo->setPrimitiveSet(k, new osg::DrawElementsUInt(osg::PrimitiveSet::PATCHES, (geo->getPrimitiveSet(k)->getNumIndices()-2)*3, &indices[0]));
							}
							else
							{
								std::cout << "Ende" << std::endl;
							}
						}						
						else	geo->getPrimitiveSet(k)->setMode(osg::PrimitiveSet::PATCHES);						
						geo->getPrimitiveSet(k)->dirty();
						geo->dirtyBound();
					}			
				}
			}
			
			geode->getOrCreateStateSet()->setMode( GL_CULL_FACE, osg::StateAttribute::OFF ); 
			geode->addCullCallback(new ViewerLightCallback);

			osg::StateSet* heightmap_state = geode->getOrCreateStateSet();
			//heightmap_state->setTextureAttributeAndModes(0,tex_ortho,osg::StateAttribute::ON);			
			heightmap_state->addUniform(new osg::Uniform("ProjectionMatrix", Scene::GetProjectionMatrix_View()));
			heightmap_state->addUniform(new osg::Uniform("ViewMatrix", Scene::GetViewMatrix_View()));
			heightmap_state->addUniform(new osg::Uniform("ModelMatrix", osg::Matrixd()));	

			heightmap_state->addUniform(new osg::Uniform("fogdensity", m_fog->GetFogDensity()));
			heightmap_state->addUniform(new osg::Uniform("fogheight", m_fog->GetFogHeight()));

#ifdef SHADOW_MAPPING
			heightmap_state->addUniform(new osg::Uniform("light_proj_matrix", Scene::GetProjectionMatrix_Light()));	
			heightmap_state->addUniform(new osg::Uniform("light_mv_matrix", Scene::GetLightCamera()->getViewMatrix()));	
#endif
			heightmap_state->addUniform(new osg::Uniform("tex0", 0));
			heightmap_state->addUniform(new osg::Uniform("height_tex", 2));	
			heightmap_state->addUniform(new osg::Uniform("tex_def", 6));			

			heightmap_state->addUniform(new osg::Uniform("bump4_tex", 7));			
			heightmap_state->addUniform(new osg::Uniform("bump6_tex", 8));			

			heightmap_state->addUniform(new osg::Uniform("tex_def", 9));			

			//__________
			heightmap_state->addUniform(new osg::Uniform("v3LightPos", Scene::m_skydome->GetLightPosition()));
			Scene::m_skydome->SetupUniform(heightmap_state);
			heightmap_state->addUniform(new osg::Uniform("color_tex", 0));		
			//__________

			heightmap_state->setAttribute(terrainShadowProg.get());
	
			heightmap_state->setTextureAttributeAndModes(0,tex_ortho,osg::StateAttribute::ON);						

			heightmap_state->setTextureAttributeAndModes(2,tex_height,osg::StateAttribute::ON);
			heightmap_state->setTextureAttributeAndModes(6,tex_def,osg::StateAttribute::ON);			

			heightmap_state->setTextureAttributeAndModes(7,bump4_tex,osg::StateAttribute::ON);			
			heightmap_state->setTextureAttributeAndModes(8,bump6_tex,osg::StateAttribute::ON);
			heightmap_state->setTextureAttributeAndModes(9,tex_rock2,osg::StateAttribute::ON);
		}
	}	

	trans_light = new osg::MatrixTransform(osg::Matrixd(1500.f, 0.f, 0.f, 0.f, 
												  0.f, 1500.f, 0.f, 0.f, 
												  0.f, 0.f,1000.f, 0.f, 
												  0.f, 0.f,-1000.f, 1.f));	
	trans_light->addChild(terrain_light_obj);
}