#include "TerrainConfig.h"


osgCloudyDay::TerrainConfig::TerrainConfig(void) : m_use_geometry_shader(false)
{
}

osgCloudyDay::TerrainConfig::~TerrainConfig(void)
{
}

void osgCloudyDay::TerrainConfig::SetPath2File(std::string path)
{
	m_path2file = path;
}

std::string osgCloudyDay::TerrainConfig::GetPath2File()
{
	return m_path2file;
}

void osgCloudyDay::TerrainConfig::SetPath2DiffuseTexture(std::string path)
{
	m_diffuse_texture = path;
}

std::string osgCloudyDay::TerrainConfig::GetPath2DiffuseTexture()
{
	return m_diffuse_texture;
}

void osgCloudyDay::TerrainConfig::SetPath2DefinationTexture(std::string path)
{
	m_defination = path;
}

std::string osgCloudyDay::TerrainConfig::GetPath2DefinationTexture()
{
	return m_defination;
}

void osgCloudyDay::TerrainConfig::AddPath2Texture(std::string path)
{
	m_textures.push_back(path);
}

std::string osgCloudyDay::TerrainConfig::GetPathAt(int at)
{
	return m_textures.at(at);
}

int osgCloudyDay::TerrainConfig::GetNumberOfTexture()
{
	return m_textures.size();
}

void osgCloudyDay::TerrainConfig::SetPath2HeightTexture(std::string path)
{
	m_heightmap  = path;	
}

std::string osgCloudyDay::TerrainConfig::GetPath2HeightTexture()
{
	return m_heightmap;
}

void osgCloudyDay::TerrainConfig::AddPath2NormalTexture(std::string path)
{
	m_textures_normal.push_back(path);
}

int osgCloudyDay::TerrainConfig::GetNumberOfNormalTexture()
{
	return m_textures_normal.size();
}

std::string osgCloudyDay::TerrainConfig::GetNormalPathAt(int at)
{
	return m_textures_normal.at(at);
}


bool osgCloudyDay::TerrainConfig::UseTesselationShader()
{
	return m_use_geometry_shader;
}

void osgCloudyDay::TerrainConfig::SetTesselationShader(bool value)
{
	m_use_geometry_shader = value;
}