#include "Terrain.h"


osgCloudyDay::MyTerrain::MyTerrain(TerrainConfig* config) : m_config(config), m_use_geometry_shader(true),
	m_fog(0), tex_height(0), tex_def(0), tex_ortho(0),	
	terrainShadowProg(0), mieTerrainProg(0), trans(0), trans_light(0)
{
}

osgCloudyDay::MyTerrain::~MyTerrain(void)
{
}

osg::MatrixTransform* osgCloudyDay::MyTerrain::GetNode()
{
	return trans;
}

osg::MatrixTransform* osgCloudyDay::MyTerrain::GetLightNode()
{
	return trans_light;
}

void osgCloudyDay::MyTerrain::SetFog(Fog* fog)
{
	m_fog = fog;
}

osg::ref_ptr<osg::Texture2D> osgCloudyDay::MyTerrain::GetHeightTexture()
{
	return tex_height;
}

osg::ref_ptr<osg::Texture2D> osgCloudyDay::MyTerrain::GetDefinitionTexture()
{
	return tex_def;
}

osg::ref_ptr<osg::Texture2D> osgCloudyDay::MyTerrain::GetOrthogonalTexture()
{
	return tex_ortho;
}