#include "StratoCumulusGenerator.h"
#include "CloudScene.h"

osgCloudyDay::StratoCumulusGenerator::StratoCumulusGenerator(osg::Vec4 layer) : CloudGenerator(layer)
{
	m_category = CloudScene::CT_StratoCumulusGenerator;
}


osgCloudyDay::StratoCumulusGenerator::~StratoCumulusGenerator(void)
{
}

bool osgCloudyDay::StratoCumulusGenerator::Update()
{
	return false;
}

void osgCloudyDay::StratoCumulusGenerator::Initialize()
{	
	osg::Vec3 randVer = m_middlepoint;	
	osg::Vec3 sizes = osg::Vec3(2, 2, 2);
	
	std::cout << "Create Humilis" << std::endl;
	int XM = 4;
	int YM = 4;
	int ZM = 2;
	int num_boxes=0;

	for(int z = 0; z < 2; z++)
	{
		for(int y = -2; y < 3; y++)
		{
			for(int x = -2; x < 3; x++)
			{
				//if((y != 0 && y != (YM-1) && x < 2 && x > (XM-3)) || (rand() % (z+1)) <= 1)
				if((rand() % 12) <= (5-z))
				{
					osg::Vec3 posHelper = randVer + osg::Vec3(x*180.f, y*180.f, z*180.f);

					osg::Vec3 size = osg::Vec3();
					size.x() = 150.0f+(std::max(frand(),0.5f)*70.f);
					size.y() = 150.0f+(std::max(frand(),0.5f)*70.f);
					size.z() = 130.0f+(std::max(frand(),0.5f)*70.f);

					AddCloudBox(num_boxes, posHelper, sizes, size, size, z == 0, 350.f, osg::Vec4(5.f, 10.f, 5.f, 10.f), m_density);
					num_boxes++;
					AddBox(dBoxes_vertices, posHelper, size);
				}
			}
		}
	}
	std::cout << "Humilis created: " << num_boxes << std::endl;
	
	EliminateRedudantSprites();	
	
	dBoxes_indices.resize(dBoxes_vertices->size());
	for(unsigned int i = 0; i < dBoxes_vertices->size(); i++)
	{
		dBoxes_indices[i] = i;
	}
	dBoxes_geometry->setVertexArray (dBoxes_vertices.get());
	dBoxes_geometry->addPrimitiveSet(
		new osg::DrawElementsUShort(osg::PrimitiveSet::TRIANGLES, dBoxes_vertices->size(), &dBoxes_indices[0])
	);
	dBoxes_geometry->getPrimitiveSet(0)->getDrawElements()->setDataVariance(osg::Object::STATIC);
	dBoxes->addDrawable(dBoxes_geometry.get());
	dBoxes->getOrCreateStateSet()->setMode(GL_CULL_FACE, osg::StateAttribute::OFF );
	dBoxes->setCullingActive(false);
	//dBoxes->getOrCreateStateSet()->setMode(GL_FRONT_AND_BACK, osg::PolygonMode::LINE );

	ex->AddCloud(m_cloud->GetVertices(), m_cloud->GetRotation(), m_cloud->GetColor(), m_cloud->GetCenter(), m_cloud->GetIds(), m_cloud->GetBoxCenters(), num_boxes);

}