#include "SkydomeMie.h"


osgCloudyDay::SkydomeMie::SkydomeMie(void) : Skydome()
{
	/*
	m_invWaveLength = osg::Vec3(0.65f, 0.57f, 0.475f);	
	m_innerR = 10.f;
	m_otherR = 10.25f;
	m_g = -0.95f;
	m_ESun = 20.f;
	m_kr = 0.01f;
	m_km = 0.001f;
	m_RayleighScaleDepth = 0.25f;	*/
	
	m_invWaveLength = osg::Vec3(0.65f, 0.57f, 0.475f);	
	m_innerR = 1.f;
	m_otherR = 1.025f;
	m_g = -0.95f;
	m_ESun = 10.f;	
	m_km = 0.015f;
	m_kr = m_km/2.0;
	m_RayleighScaleDepth = 0.25f;	
}


osgCloudyDay::SkydomeMie::~SkydomeMie(void)
{
}

float osgCloudyDay::SkydomeMie::GetInnerRadius()
{
	return m_innerR;
}
void osgCloudyDay::SkydomeMie::SetInnerRadius(float innerR)
{
	m_innerR = innerR;
}

float osgCloudyDay::SkydomeMie::GetOtherRadius()
{
	return m_otherR;
}
void osgCloudyDay::SkydomeMie::SetOtherRadius(float otherR)
{
	m_otherR = otherR;
}

float osgCloudyDay::SkydomeMie::GetKr()
{
	return m_kr;
}
void osgCloudyDay::SkydomeMie::SetKr(float kr)
{
	m_kr = kr;
}

float osgCloudyDay::SkydomeMie::GetKm()
{
	return m_km;
}
void osgCloudyDay::SkydomeMie::SetKm(float km)
{
	m_km = km;
}

float osgCloudyDay::SkydomeMie::GetESun()
{
	return m_ESun;
}
void osgCloudyDay::SkydomeMie::SetESun(float ESun)
{
	m_ESun = ESun;
}

float osgCloudyDay::SkydomeMie::GetG()
{
	return m_g;
}
void osgCloudyDay::SkydomeMie::SetG(float g)
{
	m_g = g;
}

float osgCloudyDay::SkydomeMie::GetRayleighScaleDepth()
{
	return m_RayleighScaleDepth;
}
void osgCloudyDay::SkydomeMie::SetRayleighScaleDepth(float rayleighscaledepth)
{
	m_RayleighScaleDepth = rayleighscaledepth;
}

osg::Vec3 osgCloudyDay::SkydomeMie::GetInverseWaveLength()
{
	return m_invWaveLength;
}
void osgCloudyDay::SkydomeMie::SetInverseWaveLength(osg::Vec3 invWaveLength)
{
	 m_invWaveLength = invWaveLength;
}

float scale(float fCos)
{
	float x = 1.0 - fCos;
	return 0.25f * exp(-0.00287 + x*(0.459 + x*(3.83 + x*(-6.80 + x*5.25))));
}

osg::Vec3 osgCloudyDay::SkydomeMie::CalculateSunColor(osg::Matrixd view)
{
	osg::Vec3 invWaveLength = osg::Vec3(0.65f, 0.57f, 0.475f);
	invWaveLength = osg::Vec3(1.f/powf(invWaveLength.x(), 4.f), 1.f/powf(invWaveLength.y(), 4.f), 1.f/powf(invWaveLength.z(), 4.f));

	float innerRadius = GetInnerRadius();
	float outerRadius = GetOtherRadius();
	float g = -GetG();
	float ESun = GetESun();
	float kr = GetKr();
	float km = GetKm();
	float m_fRayleighScaleDepth = GetRayleighScaleDepth();

	osg::Vec3 v3CameraPos = osg::Matrixd::inverse(view) *(osg::Vec3(0.0, 0.0, 0.0));
		
	osg::Vec3 vecCamera = v3CameraPos;
	vecCamera /= 1000000.f*innerRadius;
	vecCamera.z() += innerRadius;
	vecCamera.x() = 0.0;
	vecCamera.y() = 0.0;	
	
	float fCameraHeight = (vecCamera.length());
	float fCameraHeight2 = pow(vecCamera.z(), 2.f);	
		
	osg::Vec3 lightPos = GetLightPosition();
	lightPos.normalize();

	// Get the ray from the camera to the vertex, and its length (which is the far point of the ray passing through the atmosphere)
	osg::Vec3 v3Pos = GetLightPosition();
//	v3Pos.normalize()*innerRadius;
	v3Pos.z() += innerRadius;
	osg::Vec3 v3Ray = v3Pos - vecCamera;
	float fFar = v3Ray.length();
	v3Ray /= fFar;

	// Calculate the ray's starting position, then calculate its scattering offset
	osg::Vec3 v3Start = vecCamera;
	float fHeight = v3Start.length();
	float fDepth = exp(0.25 * (10.f - fCameraHeight));
	float fStartAngle = (v3Ray * v3Start) / fHeight;
	float fStartOffset = fDepth*scale(fStartAngle);

	// Initialize the scattering loop variables
	float fSampleLength = fFar / 20.0f;
	float fScaledLength = fSampleLength * 0.25f;
	osg::Vec3 v3SampleRay = v3Ray * fSampleLength;
	osg::Vec3 v3SamplePoint = v3Start + (v3SampleRay * 0.5f);

	// Now loop through the sample rays
	osg::Vec3 v3FrontColor = osg::Vec3();
	for(int i=0; i<20; i++)
	{
		float fHeight = v3SamplePoint.length();
		float fDepth = exp((1.f / (outerRadius - innerRadius)) / m_fRayleighScaleDepth * (innerRadius - fHeight));
		float fLightAngle = (lightPos * v3SamplePoint) / fHeight;
		float fCameraAngle = (v3Ray * v3SamplePoint) / fHeight;
		float fScatter = (fStartOffset + fDepth*(scale(fLightAngle) - scale(fCameraAngle)));
		osg::Vec3 helper = ((invWaveLength * (float)(kr*4.f*PI)) + osg::Vec3( (float)(km*4.f*PI), (float)(km*4.f*PI), (float)(km*4.f*PI))) * -fScatter;
		osg::Vec3 v3Attenuate = osg::Vec3(exp(helper.x()), exp(helper.y()), exp(helper.z()));
		v3FrontColor = v3FrontColor + ( v3Attenuate * (fDepth * fScaledLength));
		v3SamplePoint += v3SampleRay;
	}

	
	// Finally, scale the Mie and Rayleigh colors and set up the varying variables for the pixel shader
	osg::Vec3 help;
	help.x() = (v3FrontColor.x() * invWaveLength.x() * (float)(kr*ESun));
	help.y() = (v3FrontColor.y() * invWaveLength.y() * (float)(kr*ESun));
	help.z() = (v3FrontColor.z() * invWaveLength.z() * (float)(kr*ESun));

	osg::Vec3 ex_v3Direction = vecCamera - v3Pos;

	float g2 = powf(g,2.f);
	float fCos = (lightPos * ex_v3Direction) / ex_v3Direction.length();
	float fMiePhase = 1.5 * ((1.0 - g2) / (2.0 + g2)) * (1.0 + fCos*fCos) / pow(1.0 + g2 - 2.0*g*fCos, 1.5);
	osg::Vec3 LightColor = v3FrontColor * (float)(km*ESun) + (help*fMiePhase);

	LightColor.x() = exp(LightColor.x()*-5.f);
	LightColor.y() = exp(LightColor.y()*-5.f);
	LightColor.z() = exp(LightColor.z()*-5.f);

	LightColor.x() = std::min(std::max(LightColor.x(), 0.f), 1.f);
	LightColor.y() = std::min(std::max(LightColor.y(), 0.f), 1.f);
	LightColor.z() = std::min(std::max(LightColor.z(), 0.f), 1.f);

	LightColor = osg::Vec3(1.f, 1.f, 1.f) - LightColor;

	//std::cout << "LightColor: " << LightColor.x() << " " << LightColor.y() << " " << LightColor.z() << std::endl;

	return LightColor;
}

void osgCloudyDay::SkydomeMie::SetupUniform(osg::StateSet* nodess4)
{
	nodess4->addUniform(new osg::Uniform("v3InvWavelength", osg::Vec3(1.f/powf(GetInverseWaveLength().x(), 4.f), 1.f/powf(GetInverseWaveLength().y(), 4.f), 1.f/powf(GetInverseWaveLength().z(), 4.f))));
	nodess4->addUniform(new osg::Uniform("fOuterRadius", GetOtherRadius()));
	nodess4->addUniform(new osg::Uniform("fOuterRadius2", powf(GetOtherRadius(),2.f)));
	nodess4->addUniform(new osg::Uniform("fInnerRadius", GetInnerRadius()));
	nodess4->addUniform(new osg::Uniform("fInnerRadius2", powf(GetInnerRadius(),2.f)));
	nodess4->addUniform(new osg::Uniform("fKrESun", GetKr()*GetESun()));
	nodess4->addUniform(new osg::Uniform("fKmESun", GetKm()*GetESun()));
	nodess4->addUniform(new osg::Uniform("fKr4PI", GetKr()*4.f*(float)PI));
	nodess4->addUniform(new osg::Uniform("fKm4PI", GetKm()*4.f*(float)PI));
	nodess4->addUniform(new osg::Uniform("fScale", 1.f / (GetOtherRadius() - GetInnerRadius())));
	nodess4->addUniform(new osg::Uniform("fScaleDepth", GetRayleighScaleDepth()));
	nodess4->addUniform(new osg::Uniform("fScaleOverScaleDepth", (1.f / (GetOtherRadius() - GetInnerRadius())) / GetRayleighScaleDepth()));
	nodess4->addUniform(new osg::Uniform("g", GetG()));
	nodess4->addUniform(new osg::Uniform("g2", (powf(GetG(),2.f))));
	nodess4->addUniform(new osg::Uniform("un_sunLight", osg::Vec3(1.f, 1.f, 1.f)));
}